<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Releases Controller
 *
 * @property \App\Model\Table\ReleasesTable $Releases
 *
 * @method \App\Model\Entity\Release[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ReleasesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $releases = $this->paginate($this->Releases);

        $this->set(compact('releases'));
    }

    /**
     * View method
     *
     * @param string|null $id Release id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $releaseitens = $this->getAllTableWhere('releaseitens',['idrelease'=>$id],[]);
        $sql = "select * from chamado c
        inner join releaseitens r on r.idchamado = c.idchamado
        where r.idrelease = $id";
        $chamado = $this->query($sql);
        $release = $this->Releases->get($id, [
            'contain' => []
        ]);

        $this->set(compact(['release','releaseitens','chamado']));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $produtos = $this->getAllTableWhere('produto',[],['grupo'=>'asc','subgrupo'=>'asc','nome'=>'asc']);

        $release = $this->Releases->newEntity();
        if ($this->request->is('post')) {
            $release = $this->Releases->patchEntity($release, $this->request->getData());

            if($this->validaData($_POST['previsaoentrega'])){
                $release->previsaoentrega = $this->formatDataToDatabase($_POST['previsaoentrega']);
            }else{
                $release->previsaoentrega = null;
            }

            if ($this->Releases->save($release)) {
                $this->Flash->success(__('release foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('release não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact(['release','produtos']));
    }

    /**
     * Edit method
     *
     * @param string|null $id Release id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $produtos = $this->getAllTableWhere('produto',[],['grupo'=>'asc','subgrupo'=>'asc','nome'=>'asc']);
        $release = $this->Releases->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $release = $this->Releases->patchEntity($release, $this->request->getData());
            if ($this->Releases->save($release)) {
                $this->Flash->success(__('release salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('release não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact(['release','produtos']));
    }

    /**
     * Delete method
     *
     * @param string|null $id Release id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $release = $this->Releases->get($id);
        if ($this->Releases->delete($release)) {
            $this->Flash->success(__('release deletado com sucesso.'));
        } else {
            $this->Flash->error(__('release não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function addchamados($id=null)
    {
        $release = $this->Releases->get($id, [
            'contain' => []
        ]);

        $idproduto = $release->idproduto;

        $sql = "select * from chamado c
        where ('-1' = '$idproduto' OR c.idproduto = $idproduto)
                and c.idchamadostatus not in (5,7,8)
                and not exists (select r.idchamado from releaseitens r where r.idchamado = c.idchamado)";
        $chamado = $this->query($sql);



        if ($this->request->is(['post'])) {
            $data = $this->request->getData();
            if(array_key_exists('check', $data)){
                foreach ($data['check'] as $item) {
                    $this->insert('releaseitens',[
                        'idrelease'=>$id
                        ,'idchamado'=>$item
                    ]);
                }
                return $this->redirect(['action' => 'view',$id]);
            }else{
                $this->Flash->error(__('Selecione pelo menos um chamado da lista.'));
            }

            //$this->d($data);
        }

        //$this->d($chamado);

        $this->set(compact(['release','chamado']));
    }
}
