<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Sprint Controller
 *
 * @property \App\Model\Table\SprintTable $Sprint
 *
 * @method \App\Model\Entity\Sprint[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class SprintController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $sprint = $this->paginate($this->Sprint);

        $this->set(compact('sprint'));
    }

    /**
     * View method
     *
     * @param string|null $id Sprint id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $sprintitens = $this->getAllTableWhere('sprintitens',['idsprint'=>$id],[]);
        $sql = "select * from chamado c
        inner join sprintitens s on s.idchamado = c.idchamado
        where s.idsprint = $id";
        $chamado = $this->query($sql);

        $sprint = $this->Sprint->get($id, [
            'contain' => []
        ]);

         $this->set(compact(['sprint','sprintitens','chamado']));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $sprint = $this->Sprint->newEntity();
        if ($this->request->is('post')) {
            $sprint = $this->Sprint->patchEntity($sprint, $this->request->getData());

            if($this->validaData($_POST['previsaoentrega'])){
                $sprint->previsaoentrega = $this->formatDataToDatabase($_POST['previsaoentrega']);
            }else{
                $sprint->previsaoentrega = null;
            }

            if ($this->Sprint->save($sprint)) {
                $this->Flash->success(__('sprint foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('sprint não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('sprint'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Sprint id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $sprint = $this->Sprint->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $sprint = $this->Sprint->patchEntity($sprint, $this->request->getData());
            if ($this->Sprint->save($sprint)) {
                $this->Flash->success(__('sprint salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('sprint não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('sprint'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Sprint id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $sprint = $this->Sprint->get($id);
        if ($this->Sprint->delete($sprint)) {
            $this->Flash->success(__('sprint deletado com sucesso.'));
        } else {
            $this->Flash->error(__('sprint não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function addchamados($id=null)
    {
        $sprint = $this->Sprint->get($id, [
            'contain' => []
        ]);


        $sql = "select * from chamado c
        inner join releaseitens ri on ri.idchamado = c.idchamado
                inner join releases r on r.idrelease = ri.idrelease
                where c.idchamadostatus not in (5,7,8)
                and r.situacao = 'ABERTA'
                and not exists (select s.idchamado from sprintitens s where s.idchamado = c.idchamado)";
        $chamado = $this->query($sql);



        if ($this->request->is(['post'])) {
            $data = $this->request->getData();
            if(array_key_exists('check', $data)){
                foreach ($data['check'] as $item) {
                    $this->insert('sprintitens',[
                        'idsprint'=>$id
                        ,'idchamado'=>$item
                    ]);
                }
                return $this->redirect(['action' => 'view',$id]);
            }else{
                $this->Flash->error(__('Selecione pelo menos um chamado da lista.'));
            }

            //$this->d($data);
        }

        //$this->d($chamado);

        $this->set(compact(['sprint','chamado']));
    }
}
