<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Texto Controller
 *
 * @property \App\Model\Table\TextoTable $Texto
 *
 * @method \App\Model\Entity\Texto[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TextoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $texto = $this->paginate($this->Texto);

        $this->set(compact('texto'));
    }

    /**
     * View method
     *
     * @param string|null $id Texto id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $texto = $this->Texto->get($id, [
            'contain' => []
        ]);

        $this->set('texto', $texto);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $texto = $this->Texto->newEntity();
        if ($this->request->is('post')) {
            $texto = $this->Texto->patchEntity($texto, $this->request->getData());
            if ($this->Texto->save($texto)) {
                $this->Flash->success(__('texto foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('texto não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('texto'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Texto id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $texto = $this->Texto->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $texto = $this->Texto->patchEntity($texto, $this->request->getData());
            if ($this->Texto->save($texto)) {
                $this->Flash->success(__('texto salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('texto não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('texto'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Texto id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $texto = $this->Texto->get($id);
        if ($this->Texto->delete($texto)) {
            $this->Flash->success(__('texto deletado com sucesso.'));
        } else {
            $this->Flash->error(__('texto não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
