<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;

/**
 * Todo Controller
 *
 * @property \App\Model\Table\TodoTable $Todo
 *
 * @method \App\Model\Entity\Todo[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TodoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index($id = null)
    {
        $todo = $this->query("SELECT * FROM todo WHERE idchamado = $id");

        $total = count($todo);
            $concluido = 0;
            foreach ($todo as $item) {
                if($item->concluido == 1){
                    $concluido =+ $concluido+1;
                }
            }
            if($total > 0){
                $percentual = ($concluido / $total)*100;
                $percentual = round($percentual,2);
            } else {
                $percentual = 0;
            }


        $this->set(compact('todo','total','concluido','percentual'));
    }

    /**
     * View method
     *
     * @param string|null $id Todo id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $todo = $this->Todo->get($id, [
            'contain' => []
        ]);

        $this->set('todo', $todo);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $todo = $this->Todo->newEntity();
        if ($this->request->is('post')) {
            $todo = $this->Todo->patchEntity($todo, $this->request->getData());
            if ($this->Todo->save($todo)) {
                $this->Flash->success(__('todo foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('todo não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('todo'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Todo id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $todo = $this->Todo->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $todo = $this->Todo->patchEntity($todo, $this->request->getData());
            if ($this->Todo->save($todo)) {
                $this->Flash->success(__('todo salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('todo não pode ser salvo. Favor, tentar novamente.'));
        }
        $this->set(compact('todo'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Todo id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $todo = $this->Todo->get($id);
        if ($this->Todo->delete($todo)) {
            $this->Flash->success(__('todo deletado com sucesso.'));
        } else {
            $this->Flash->error(__('todo não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function concluido($id = null){
        $concluido = $this->query("SELECT concluido from todo where id = $id")[0]->concluido;

        if($concluido == 0){
            $this->update('todo',[
                'concluido'=>1
            ],[
                'id'=>$id
            ]);
        } else {
            $this->update('todo',[
                'concluido'=>0
            ],[
                'id'=>$id
            ]);
        }

        $this->response->body("ok");
        return $this->response;
        exit();
    }

    public function addajax($id = null){

        //$this->d($_POST);

        $this->insert('todo',[
            'descricao'=>$_POST['description']
            ,'idusuario'=>$this->usuarioid()
            ,'idchamado'=> $id
            ,'concluido'=> 0
        ]);

        //$this->d($_POST['descricao']);

        $this->response->body("ok");
        return $this->response;
        exit();
    }

    public function deletar($id = null) {
        $this->remove('todo',[
            'id'=>$id
        ]);

        $this->response->body("ok");
        return $this->response;
        exit();
    }

}
