<?php
namespace App\Controller\Controladoria;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Datasource\ConnectionManager;

/**
 * Usuario Controller
 *
 * @property \App\Model\Table\UsuarioTable $Usuario
 *
 * @method \App\Model\Entity\Usuario[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsuarioController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $usuario = $this->Usuario->find('All')
			->order(['nome'=>'asc']);

        $this->set(compact('usuario'));
    }

	public function login($id = null)
    {
        $usuario = $this->Usuario->get($id, [
            'contain' => []
        ]);
        
        $empresa = $this->get('Empresa','idempresa',$usuario->idempresa);
        $users = $this->getAllTableWhere('Usuario', ['idempresa'=>$usuario->idempresa],[]);
        $lista_usuarios = [];
        foreach ($users as $user) {
            array_push($lista_usuarios, (object) ['idusuario'=>$user->idusuario,'nome'=>$user->nome,'cpf'=>$user->cpf]);
        }
		$erp     = $this->get('Erp','chave',$empresa->erp);
		$perfil  = $this->get('Perfil','idperfil',$usuario->idperfil);
        // $perfilCrmTable  = TableRegistry::get('perfil_crm');
        // $perfilCrm = $perfilCrmTable->find('all')
        //     ->innerJoin('perfilusuario_crm',['perfil_crm.idperfil_crm = perfilusuario_crm.idperfil_crm'])
        //     ->where([
        //     'perfilusuario_crm.ativo'=> 1
        //     ,'perfilusuario_crm.usuarioid'=>$usuario->idusuario
        // ]);
		$moduloTable  = TableRegistry::get('modulo');
		$modulos = $moduloTable->find('all')
				->innerJoin('modulousuario', [
								'modulousuario.idmodulo = modulo.idmodulo'
							])
				->where([
					'modulo.ativo'=> 1
					,'modulousuario.idusuario'=>$usuario->idusuario
				])
				->order(['modulo.ordem_menu'=>'ASC'])
				->toArray();

		//bloqueio de usuario por filial
		$bloqueiousuariofilial = $this->getAllTableWhere('bloqueiousuariofilial',[
			'idusuario'=>$usuario->idusuario
		],[])->toArray();
		$bloqueiousuariofilialarr = [];
		foreach($bloqueiousuariofilial as $item){
			array_push($bloqueiousuariofilialarr,$item->coderpfilial);
		}

		$session = $this->request->session();
		$session->write([
						'login.usuario'	=>$usuario
						,'login.empresa'=>$empresa
						,'login.usuario_lista'=>$lista_usuarios
						,'login.erp'	=>$erp
                        ,'login.perfil'	=>$perfil
                        // ,'login.perfis_crm'=>$perfilCrm->toArray()
						,'login.modulos'=>$modulos
						,'login.bloqueiousuariofilial'=>$bloqueiousuariofilialarr
					]);

		$this->redirect('/adm');
	}

    /**
     * View method
     *
     * @param string|null $id Usuario id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $usuario = $this->Usuario->get($id, [
            'contain' => []
        ]);

		$modulosusuario = $this->getAllTableWhere('modulousuario',['idusuario'=>$id],['idmodulo'=>'asc']);

		$bloqueiousuariofilial = $this->getAllTableWhere('bloqueiousuariofilial',['idusuario'=>$id],['data_criacao'=>'asc']);


        $empresa = $this->get('Empresa','idempresa', $usuario->idempresa);
        ConnectionManager::drop('client_db');
        $config = ConnectionManager::config('client_db', [
            'className' => 'Cake\Database\Connection',
            'driver' => 'Cake\Database\Driver\Mysql',
            'persistent' => true,
            'host' 	   => $empresa->bancoflygestor_host,
            'username' => $empresa->bancoflygestor_usuario,
            'password' => $empresa->bancoflygestor_senha,
            'database' => $empresa->bancoflygestor,
            'encoding' => 'utf8',
            'timezone' => '-3:00',
            'cacheMetadata' => true,
        ]);
            
        $conn = ConnectionManager::get('client_db');
        
        //criar pessoa no crm:
        // $sql = "SELECT e.razaosocial, e.empresaid FROM empresa_crm e INNER JOIN usuario_crm u ON (u.empresaid = e.empresaid) WHERE u.usuarioid = $id";
        // $query = $conn->execute($sql)->fetchall('assoc');
        // $empresa = $this->arrayToArrayObj($query);
        // $sql = "SELECT * FROM empresa_crm";
        // $query = $conn->execute($sql)->fetchall('assoc');
        // $empresas = $this->arrayToArrayObj($query);

        $this->set('usuario', $usuario);
		$this->set([
			'modulosusuario'=>$modulosusuario
            ,'idusuario'=>$id
            ,'empresa'=>$empresa
            // ,'empresas'=>$empresas
			,'bloqueiousuariofilial'=>$bloqueiousuariofilial
		]);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($id = null)
    {
        
        
        $usuario = $this->Usuario->newEntity();
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $idperfil = $data['idperfil'];      
            $usuario = $this->Usuario->patchEntity($usuario, $data);
			$session = $this->request->session();
            $usuario->usuario_criacao = $session->read('login.usuario')->idusuario;
            $usuario = $this->Usuario->save($usuario);
            $criarvendedor = false;
            if ($usuario) {
                if( array_key_exists('idperfilcrm', $data) ){
                    foreach ($data['idperfilcrm'] as $item) {
                        $perfilCrmTable  = TableRegistry::get('perfilusuario_crm');
                        $perfilcrm = $this->get('perfil_crm','idperfil_crm',$item);
                        $usuarioPerfilCrm = $perfilCrmTable->newEntity();
                        $usuarioPerfilCrm->idperfil_crm = (integer) $item;
                        $usuarioPerfilCrm->usuarioid = (integer) $usuario->idusuario;
                        $usuarioPerfilCrm->ativo = 1;
                        $usuarioPerfilCrm->pagina_inicial = $perfilcrm->pagina_inicial;
                        if ($item == 5) {
                            $criarvendedor = true;
                        }
                        if (!$perfilCrmTable->save($usuarioPerfilCrm)) {
                            $this->Flash->error(__('Ocorreu um erro ao salvar perfil CRM'));
                        }
                    }
                }
                if($idperfil == 2){
                    $this->insert('modulousuario',[
                        'idmodulo'=>1
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>2
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>3
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>5
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>29
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                }
                if($idperfil == 9){
                    $this->insert('modulousuario',[
                        'idmodulo'=>39
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                }
                if($idperfil == 10){
                    $this->insert('modulousuario',[
                        'idmodulo'=>41
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);
                    
                }
                if($idperfil == 11){
                    $this->insert('modulousuario',[
                        'idmodulo'=>40
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                }

                if($idperfil == 4){
                    $this->insert('modulousuario',[
                        'idmodulo'=>7
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>8
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                 $this->insert('modulousuario',[
                        'idmodulo'=>29
                        ,'idusuario'=>$usuario->idusuario
                        ,'usuario_criacao'=>$this->usuarioid()
                    ]);

                }
                //trocar conexão
                $empresa = $this->get('Empresa','idempresa', $id);
				ConnectionManager::drop('client_db');
				$config = ConnectionManager::config('client_db', [
					'className' => 'Cake\Database\Connection',
					'driver' => 'Cake\Database\Driver\Mysql',
					'persistent' => true,
					'host' 	   => $empresa->bancoflygestor_host,
					'username' => $empresa->bancoflygestor_usuario,
					'password' => $empresa->bancoflygestor_senha,
					'database' => $empresa->bancoflygestor,
					'encoding' => 'utf8',
					'timezone' => '-3:00',
					'cacheMetadata' => true,
				]);
                $conn = ConnectionManager::get('client_db');
                //criar pessoa no crm:
                $sql = "INSERT INTO `pessoa` (`pessoaid`, `nome`, `cpf`, `email`, `data_criacao`, `empresaid`) 
                VALUES (NULL, '$usuario->nome', '$usuario->cpf', '$usuario->email', current_timestamp(), '1')";
                $conn->execute($sql);
                //criar usuario_crm:
                $sql = "SELECT * FROM pessoa WHERE nome = '$usuario->nome' AND cpf = '$usuario->cpf' ORDER BY data_criacao LIMIT 1";
				$query = $conn->execute($sql)->fetchall('assoc');
                $pessoa = $this->arrayToArrayObj($query);
                $pessoa = $pessoa[0];
                $sql = "INSERT INTO `usuario_crm` (`usuariocrmid`, `usuarioid`, `empresaid`, `pessoaid`) 
                VALUES (NULL, '$usuario->idusuario', '1', '$pessoa->pessoaid')";
                $conn->execute($sql);
                //criar vendedor?
                if ($criarvendedor) {
                    $sql = "INSERT INTO `vendedor` (`pessoaid`, `idempresa_crm`) 
                    VALUES ('$pessoa->pessoaid', '1')";
                    $conn->execute($sql);
                }
                $this->Flash->success(__('usuário salvo com sucesso.'));

                return $this->redirect(['controller'=>'Empresa','action' => 'view',$id]);
            }
            $this->Flash->error(__('Usuário não pode ser salvo. Favor, tentar novamente.'));
        }
		$empresas = $this->getAllTableWhere('empresa',['1'=>1],['nome'=>'asc']);
        $perfis = $this->getAllTableWhere('perfil' ,['1'=>1],['perfil'=>'asc']);
        // $perfiscrm = $this->getAllTableWhere('perfil_crm' ,['1'=>1],['nome'=>'asc']);
        $perfiscrm = null;
		$this->set([
			'empresas'=>$empresas
            ,'perfis'=>$perfis
            ,'perfiscrm' => $perfiscrm
            ,'id'=>$id
		]);
        $this->set(compact('usuario'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Usuario id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $usuario = $this->Usuario->get($id, [
            'contain' => []
        ]);
        $empresa = $this->get('Empresa','idempresa', $usuario->idempresa);
        ConnectionManager::drop('client_db');
        $config = ConnectionManager::config('client_db', [
            'className' => 'Cake\Database\Connection',
            'driver' => 'Cake\Database\Driver\Mysql',
            'persistent' => true,
            'host' 	   => $empresa->bancoflygestor_host,
            'username' => $empresa->bancoflygestor_usuario,
            'password' => $empresa->bancoflygestor_senha,
            'database' => $empresa->bancoflygestor,
            'encoding' => 'utf8',
            'timezone' => '-3:00',
            'cacheMetadata' => true,
        ]);
        $conn = ConnectionManager::get('client_db');
        
        //puxar pessoa do crm:
        $sql = "SELECT pessoaid FROM usuario_crm WHERE usuarioid = $id";
        $query = $conn->execute($sql)->fetchall('assoc');
        $pessoa = $this->arrayToArrayObj($query);
        if (!empty($pessoa)) {
            $pessoaid = $pessoa[0];
        }
        if ($this->request->is(['patch', 'post', 'put'])) {
            $data = $this->request->getData();
            $usuario = $this->Usuario->patchEntity($usuario, $data);
            $usuario = $this->Usuario->save($usuario);
            if ($usuario) {
                $perfilCrmTable  = TableRegistry::get('perfilusuario_crm');
                $perfis = $this->getAllTableWhere('perfilusuario_crm', ['usuarioid'=>$id],[]);
                foreach ($perfis as $item) {
                    $perfilCrmTable->delete($item);
                }
                $isvendedor = false;
                if( array_key_exists('idperfilcrm', $data) ){
                    foreach ($data['idperfilcrm'] as $item) {
                        if ($item == 5) {
                            $isvendedor = true;
                        }
                        $perfilcrm = $this->get('perfil_crm','idperfil_crm',$item);
                        $usuarioPerfilCrm = $perfilCrmTable->newEntity();
                        $usuarioPerfilCrm->idperfil_crm = (integer) $item;
                        $usuarioPerfilCrm->usuarioid = (integer) $usuario->idusuario;
                        $usuarioPerfilCrm->ativo = 1;
                        $usuarioPerfilCrm->pagina_inicial = $perfilcrm->pagina_inicial;
                        if (!$perfilCrmTable->save($usuarioPerfilCrm)) {
                            $this->Flash->error(__('Ocorreu um erro ao salvar perfil CRM'));
                        }
                    }
                }
                //trocar conexão
                $empresa = $this->get('Empresa','idempresa', $usuario->idempresa);
				ConnectionManager::drop('client_db');
				$config = ConnectionManager::config('client_db', [
					'className' => 'Cake\Database\Connection',
					'driver' => 'Cake\Database\Driver\Mysql',
					'persistent' => true,
					'host' 	   => $empresa->bancoflygestor_host,
					'username' => $empresa->bancoflygestor_usuario,
					'password' => $empresa->bancoflygestor_senha,
					'database' => $empresa->bancoflygestor,
					'encoding' => 'utf8',
					'timezone' => '-3:00',
					'cacheMetadata' => true,
				]);
                $conn = ConnectionManager::get('client_db');

                //puxar pessoa do crm:
                $sql = "SELECT pessoaid, empresaid FROM usuario_crm WHERE usuarioid = $id";
                $query = $conn->execute($sql)->fetchall('assoc');
                $pessoa = $this->arrayToArrayObj($query);
                if (!empty($pessoa)) {
                    $pessoaid = $pessoa[0];
                    $sql = "UPDATE `pessoa` SET `cpfcnpj` = '$usuario->cpf', `nome` = '$usuario->nome' WHERE `pessoa`.`pessoaid` = $pessoaid->pessoaid";
                    $conn->execute($sql);
                } else {
                    $sql = "INSERT INTO `pessoa` (`pessoaid`, `nome`, `cpfcnpj`, `email`, `data_criacao`, `empresaid`) 
                    VALUES (NULL, '$usuario->nome', '$usuario->cpf', '$usuario->email', current_timestamp(), '1')";
                    $conn->execute($sql);
                    //criar usuario_crm:
                    $sql = "SELECT * FROM pessoa WHERE nome = '$usuario->nome' AND cpfcnpj = '$usuario->cpf' ORDER BY data_criacao LIMIT 1";
                    $query = $conn->execute($sql)->fetchall('assoc');
                    $pessoa = $this->arrayToArrayObj($query);
                    $pessoa = $pessoa[0];
                    $sql = "INSERT INTO `usuario_crm` (`usuariocrmid`, `usuarioid`, `empresaid`, `pessoaid`) 
                    VALUES (NULL, '$usuario->idusuario', '1', '$pessoa->pessoaid')";
                    $conn->execute($sql);
                    $pessoaid = $pessoa;
                }
                
                if ($isvendedor) {
                    $sql = "SELECT * FROM vendedor WHERE pessoaid = $pessoaid->pessoaid";
                    $query = $conn->execute($sql)->fetchall('assoc');
                    $vendedor = $this->arrayToArrayObj($query);
                    if (empty($vendedor)) {
                        $sql = "INSERT INTO `vendedor` (`pessoaid`, `idempresa_crm`) VALUES ('$pessoaid->pessoaid', '$pessoaid->empresaid')";
                        $conn->execute($sql);
                    } else {
                        $sql = "UPDATE `vendedor` SET `empresaid` = '$pessoaid->empresaid', `pessoaid` = '$pessoaid->pessoaid' WHERE `vendedor`.`pessoaid` = $pessoaid->pessoaid";
                        $conn->execute($sql);                        
                    }
                }
                
                $this->Flash->success(__('usuário salvo com sucesso.'));
                return $this->redirect(['action' => 'view',$usuario->idusuario]);
            }
            $this->Flash->error(__('Usuário não pode ser salvo. Por Favor, tente novamente.'));
        }
		$empresas = $this->getAllTableWhere('empresa',['1'=>1],['nome'=>'asc']);
        $perfis = $this->getAllTableWhere('perfil' ,['1'=>1],['perfil'=>'asc']);
        $perfis_crm = $this->getAllTableWhere('perfil_crm',[],[]); 
        $perfis_cadastrados_crm = $this->query("SELECT p.nome, p.idperfil_crm FROM perfil_crm p INNER JOIN perfilusuario_crm pu ON pu.idperfil_crm = p.idperfil_crm WHERE pu.usuarioid = $id");
        $perfis_cadastrados = [];
        foreach ($perfis_cadastrados_crm as $item) {
            array_push($perfis_cadastrados, $item->idperfil_crm);
        }
		$this->set([
			'empresas'=>$empresas
			,'perfis'=>$perfis
			,'perfis_crm'=>$perfis_crm
			,'perfis_cadastrados'=>$perfis_cadastrados
		]);
        $this->set(compact('usuario'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Usuario id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $usuario = $this->Usuario->get($id);
        if ($this->Usuario->delete($usuario)) {
			$this->remove('modulousuario',['idusuario'=>$id]);
            $this->Flash->success(__('usuário foi deletado.'));
        } else {
            $this->Flash->error(__('Usuário não pode ser deletado. Favor, tentar novamente.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
