<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Perfil Controller
 *
 * @property \App\Model\Table\PerfilTable $Perfil
 */
class ControladoriaController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Network\Response|null
     */
    public function index()
    {

        $sql = "select 
				e.idempresa
                ,e.nome as empresa
                ,co.idchamado
                ,co.observacao
                ,co.arquivo
                ,u.idusuario
                ,u.nome
                ,c.assunto
                ,c.status
                ,DATE_FORMAT(co.data_criacao, '%d/%m/%Y %H:%i') as data_criacao
                ,DATE_FORMAT(c.data_criacao, '%d/%m/%Y %H:%i') as data_chamado
				,p.idprojeto
				,p.nome as projeto
                from chamado c 
                INNER JOIN chamadoobs co on c.idchamado = co.idchamado
                INNER JOIN empresa e on e.idempresa = c.idempresa
                INNER JOIN usuario u on u.idusuario = co.idusuario
				left join projeto p on p.idprojeto = c.idprojeto
                ORDER by co.data_criacao DESC
				limit 500
                ";

         $observacoes2 = $this->query($sql);

    	$this->set([
            'observacoes2'=>$observacoes2
		]);
    }

}
