<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
use \DateTime;

class BaixacontaController extends AppController
{
    public function tabelabaixas($conta){
        $contaid = $conta;
        $contabx = $this->getAllTableWhere('contabaixa',['contaid'=>$conta],[]);
        $formapagcondpag = $this->getAllTablewhere('formapag_condpag',[],[])->all();
		foreach($formapagcondpag as $item){
			$item->formapag = $this->get('formapag','formapagid',$item->idformapag)->nome;
			$item->condpag = $this->get('condpag','idcondpag',$item->idcondpag)->descricao;
		}
        $contabanco = $this->getAllTableWhere('contabanco',[],[]);
        $this->set(compact('contaid','contabx','formapagcondpag','contabanco'));
    }


    public function dadosbaixa($id){
        $contabaixa = $this->get('contabaixa','contabaixaid',$id);
        $conta=$this->get('conta','contaid',$contabaixa->contaid);
		$formapagcondpag = $this->getAllTablewhere('formapag_condpag',[],[])->all();
		foreach($formapagcondpag as $item){
			$item->formapag = $this->get('formapag','formapagid',$item->idformapag)->nome;
			$item->condpag = $this->get('condpag','idcondpag',$item->idcondpag)->descricao;
		}
        $contabanco = $this->getAllTableWhere('contabanco',[],[]);

		$this->set(compact('contabaixa','conta','formapagcondpag','contabanco'));

	}

    public function salvadadosbaixa(){
        if ($this->request->is('post')) {
            $data = $this->request->getData();

            $data['valorpago']=str_replace(',','.',str_replace('.','',$data['valorpago']));
            $data['juros'] = $data['juros']=='0' ? '' : str_replace(',','.',str_replace('.','',$data['juros']));
            $data['desconto'] = $data['desconto']=='0' ? '' : str_replace(',','.',str_replace('.','',$data['desconto']));

            $contabxTable = TableRegistry::get('contabaixa');
            $contabancoTable = TableRegistry::get('contabanco');
            $contabx = $this->get('contabaixa','contabaixaid',$data['contabx']);

            $valorantigo = $contabx->valorpago;
            //$this->d($valorantigo);
            $formapagcondpag = $this->get('formapag_condpag','idformapagcondpag',$data['formapag']);

            $contabxsave = ['formapagid'=>$formapagcondpag->idformapag,'condpagid'=>$formapagcondpag->idcondpag,'data_baixa'=>$data['datapag'],
            'valorpago'=>$data['valorpago'], 'juros'=>$data['juros'], 'desconto' => $data['desconto']];

            $contabx = $contabxTable->patchEntity($contabx,$contabxsave);
            $contabx = $contabxTable->save($contabx);
            if($contabx){
                $contaTable = TableRegistry::get('conta');
                $baixas = $this->getAllTableWhere('contabaixa',['contaid'=>$data['contaid']],[]);
                $conta = $this->get('conta','contaid',$data['contaid']);
                
                if($conta->parcela ==1){
                    $conta->valor = $conta->valorparcela;
                }else{
                    $conta->valor = $conta->totalliquido;
                }
                $totalpago = 0;
                foreach($baixas as $baixa){
                    $totalpago += $baixa->valorpago;
                }
                
                if($totalpago >= $conta->valor){
                    $contaarr = ['contaid'=> $conta->contaid, 'status' => 'PAGO'];
                }elseif($totalpago > 0 && $totalpago < $conta->valor ){
                    $contaarr = ['contaid'=> $conta->contaid, 'status' => 'PAGAMENTO PARCIAL'];
                }else {
                    $contaarr = ['contaid'=> $conta->contaid, 'status' => 'PENDENTE PAGAMENTO'];
                }

                $conta = $contaTable->patchEntity($conta,$contaarr);
                $conta = $contaTable->save($conta);
                if($conta){
                    $contabanco = $this->get('contabanco','contabancoid',$contabx->contabancoid);
                    if($conta->tipocontaid==1){ //RECEBER
                        $saldoatual = ($contabanco->saldoatual - $valorantigo) + $contabx->valorpago;
                        
                        $contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
                        $contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
                        $contabancoTable->save($contabanco);
                        
                    }else{ //PAGAR
                        $saldoatual = ($contabanco->saldoatual + $valorantigo) - $contabx->valorpago;
                        $contabancosave = ['saldoanterior'=>$conta->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
                        $contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
                        $contabancoTable->save($contabanco);
                    }
                }
                $this->set('val','Dados da baixa salvos com sucesso.');
                $this->set('_serialize',array('val'));
                $this->response->statusCode(200);
            }else{
                $this->set('val','Ocorreu um erro ao salvar dados da baixa.');
                $this->set('_serialize',array('val'));
                $this->response->statusCode(500);
            }

		}
    }
    public function addbaixa(){
        $data = $this->request->getData();
        
        $contaTable = TableRegistry::get('conta');
        $conta = $this->get('conta','contaid',$data['id']);
        
        $contabxTable = TableRegistry::get('contabaixa');
        $contabancoTable = TableRegistry::get('contabanco');
        $contabxsave = [];
 
        for ($i=0; $i <count($data['formapag']) ; $i++) { 
            $data['valorpago'][$i]=str_replace(',','.',str_replace('.','',$data['valorpago'][$i]));
            $data['juros'][$i] = $data['juros'][$i]=='0' ? '' : str_replace(',','.',str_replace('.','',$data['juros'][$i]));
            $data['desconto'][$i] = $data['desconto'][$i]=='0' ? '' : str_replace(',','.',str_replace('.','',$data['desconto'][$i]));
            $formapagcondpag = $this->get('formapag_condpag','idformapagcondpag', $data['formapag'][$i]);
            
            $arr = ['contaid'=>$data['id'],'formapagid'=> $formapagcondpag['idformapag'],'condpagid'=> $formapagcondpag['idcondpag'],'contabancoid'=>$data['conta'][$i],
            'data_baixa'=>$data['datapag'][$i],'valorpago'=>$data['valorpago'][$i],'juros'=>$data['juros'][$i],'desconto'=>$data['desconto'][$i]];
         
            array_push($contabxsave,$arr);
        }
        
        $contasbx = $contabxTable->newEntity();
        
        $contasbx = $contabxTable->patchEntities($contasbx,$contabxsave);
        
        $cbxsalvos = $contabxTable->saveMany($contasbx);
        if($cbxsalvos){
            $baixas = $this->getAllTableWhere('contabaixa',['contaid'=>$data['id']],[]);
            $totalpago = 0;
            foreach($baixas as $baixa){
                $totalpago += $baixa->valorpago;
            }
            if($conta->parcela ==1){
                $conta->valor = $conta->valorparcela;
            }else{
                $conta->valor = $conta->totalliquido;
            }
            
            if($totalpago >= $conta->valor){
                $contaarr = ['contaid'=> $conta->contaid, 'status' => 'PAGO'];

            }elseif($totalpago > 0 && $totalpago < $conta->valor ){
                $contaarr = ['contaid'=> $conta->contaid, 'status' => 'PAGAMENTO PARCIAL'];
            }else {
                $contaarr = ['contaid'=> $conta->contaid, 'status' => 'PENDENTE PAGAMENTO'];
            }
            $conta = $contaTable->patchEntity($conta,$contaarr);
            
            if(!$contaTable->save($conta)){
				$contabxTable->deleteAll($cbxsalvos);
            }else{
                foreach($cbxsalvos as $cbx){
                    $contabanco = $this->get('contabanco','contabancoid',$cbx->contabancoid);
                    if($conta->tipocontaid==1){ //RECEBER
                        $saldoatual = $contabanco->saldoatual + $cbx->valorpago;
                        $contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
                        $contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
                        $contabancoTable->save($contabanco);
                    }else{ //PAGAR
                        $saldoatual = $contabanco->saldoatual - $cbx->valorpago;
                        $contabancosave = ['saldoanterior'=>$conta->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
                        $contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
                        $contabancoTable->save($contabanco);
                    }
                }
            }
            
            $this->set('val','Dados da baixa salvos com sucesso.');
                $this->set('_serialize',array('val'));
                $this->response->statusCode(200);
        }else{
            $this->set('val','Ocorreu um erro ao salvar dados da baixa.');
            $this->set('_serialize',array('val'));
            $this->response->statusCode(500);
        }
    }

	public function deletedadosbaixa($id){
        $contabx = $this->get('contabaixa','contabaixaid',$id);
        $contabxTable = TableRegistry::get('contabaixa');

        $contabancoTable = TableRegistry::get('contabanco');

        $conta = $this->get('conta','contaid',$contabx->contaid);

        $contabanco = $this->get('contabanco','contabancoid',$contabx->contabancoid);
        if($conta->tipocontaid==1){ //RECEBER
            $saldoatual = $contabanco->saldoatual - $contabx->valorpago;
            $contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
            $contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
            $contabancoTable->save($contabanco);
        }else{ //PAGAR
            $saldoatual = $contabanco->saldoatual + $contabx->valorpago;
            $contabancosave = ['saldoanterior'=>$conta->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
            $contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
            $contabancoTable->save($contabanco);
        }
		$contabxTable->deleteAll(['contabaixaid'=>$contabx->contabaixaid]);

	}
}