<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;


class CategoriaController extends AppController
{
    public function cadfinanceiro(){
        $data = $_GET['data'];
        
        $categoriaTable = TableRegistry::get('categoria');
        $categoria = $categoriaTable->newEntity();

        $categoria->nome = $data;
        $categoria->descricao = $data;
        $categoria->ativo = 1;
        $empresaid = $this->empresaid();
        $categoria->empresaid = $empresaid;
        $categoriasave = $categoriaTable->save($categoria);
        if($categoriasave){
            $this->set('val','Categoria salva com sucesso.');
            $this->set('id',$categoriasave->categoriaid);
            $this->set('nome',$categoriasave->nome);
            $this->set('_serialize',array('val','id','nome'));
            $this->response->statusCode(200);
        }else{
            $this->set('val','Categoria não pode ser salva.');
            $this->set('_serialize',array('val'));
            $this->response->statusCode(500);
        }

    }

    public function index(){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $categoria = $this->getAllTableWhere('categoria',['empresaid'=>$empresaid],['ativo'=>'DESC', 'ordem'=>'ASC']);
        $this->set(compact([
            'categoria'
            ,'empresa'
        ]));
    }

    public function add(){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $categoriaTable = TableRegistry::get('categoria');
            $categoria = $categoriaTable->newEntity();
            $categoria->nome = $data['nome'];
            $categoria->descricao = $data['descricao'];
            $categoria->ordem = $data['ordem'];
            $categoria->ativo = $data['ativo'];
            $categoria->empresaid = $empresaid;
            if (!$categoriaTable->save($categoria)) {
                $this->Flash->error("Não foi Possível cadastrar o Categoria! Por favor, tente novamente.");
            } else {
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
            }
            return $this->redirect('/flystart/financeiro/');

        }
        $this->set(compact([
            'empresa'
        ]));
    }

    public function edit($id){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $categoria = $this->get('categoria', 'categoriaid', $id);

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $categoriaTable = TableRegistry::get('categoria');
            $categoria->nome = $data['nome'];
            $categoria->descricao = $data['descricao'];
            $categoria->ordem = $data['ordem'];
            $categoria->ativo = $data['ativo'];
            $categoria->empresaid = $empresaid;
            if (!$categoriaTable->save($categoria)) {
                $this->Flash->error("Não foi Possível cadastrar o Centro de Custo! Por favor, tente novamente.");
            } else {
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
            }
            return $this->redirect('/flystart/financeiro/');
        }
        $this->set(compact([
            'empresa'
            ,'categoria'
        ]));


    }

    public function delete($id){
        $categoriaTable = TableRegistry::get('categoria');
        $categoria = $this->get('categoria','categoriaid',$id);

        if($categoriaTable->delete($categoria)){
            $this->Flash->success("Centro Custo excluído com Sucesso!");
            return $this->redirect('/flystart/financeiro/');
        }
        $this->Flash->success("Ocorreu um erro ao tentar excluir Centro Custo");
    }
}