<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;


class CentrocustoController extends AppController
{/*
    public function beforeRender(Event $event)
    {
		$session = $this->request->session();
		$count = 0;
		foreach ($session->read('login.modulos') as $modulo) {
			if ($modulo->chave == 'estoque'){
				$count = 1;
				break;
			} 
		}
		if ($count == 0) {
            $this->Flash->error("Acesso Negado!");
			return $this->redirect($this->referer());	
		}
    }*/
    public function index() {
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $centroscusto = $this->getAllTableWhere('Centrocusto',['empresaid'=>$empresaid],['ativo'=>'DESC', 'ordem'=>'ASC']);

        $this->set(compact([
            'centroscusto'
            ,'empresa'
        ]));
    }
    
    public function cadfinanceiro(){
        $data = $_GET['data'];
        
        $centrocustoTable = TableRegistry::get('Centrocusto');
        $centrocusto = $centrocustoTable->newEntity();

        $centrocusto->nome = $data;
        $centrocusto->ativo = 1;
        $centrocusto->empresaid = $this->empresaid();
        $centrocusto->usuariooperacao = $this->usuarioid();

        $centrosave = $centrocustoTable->save($centrocusto);
        if($centrosave){
            $this->set('val','Centro Custo salvo com sucesso.');
            $this->set('id',$centrosave->centrocustoid);
            $this->set('nome',$centrosave->nome);
            $this->set('_serialize',array('val','id','nome'));
            $this->response->statusCode(200);
        }else{
            $this->set('val','Centro Custo não pode ser salvo.');
            $this->set('_serialize',array('val'));
            $this->response->statusCode(500);
        }

    }

    public function add() {
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $centrocustoTable = TableRegistry::get('Centrocusto');
            $centrocusto = $centrocustoTable->newEntity();
            $centrocusto->nome = $data['nome'];
            $centrocusto->ativo = $data['ativo'];
            $centrocusto->ordem = $data['ordem'];
            $centrocusto->empresaid = $empresaid;
            $centrocusto->usuariooperacao = $this->usuarioid();

            if (!$centrocustoTable->save($centrocusto)) {
                $this->Flash->error("Não foi Possível cadastrar o Centro de Custo! Por favor, tente novamente.");
            } else {
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
            }
            return $this->redirect('/flystart/financeiro/');
        }

        $this->set(compact([
            'empresa'
        ]));
    }

    public function edit($id) {
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $centrocusto = $this->get('Centrocusto', 'centrocustoid', $id);
        
        if (!isset($centrocusto->centrocustoid)) {
            $this->Flash->error("Centro Custo não Cadastrado!");
            return $this->redirect($this->referer());
        }
        if ($empresaid != $centrocusto->empresaid) {
            $this->Flash->error("Acesso Negado!");
            return $this->redirect($this->referer());
        }

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $centrocustoTable = TableRegistry::get('Centrocusto');
            $centrocusto->nome = $data['nome'];
            $centrocusto->ativo = $data['ativo'];
            $centrocusto->ordem = $data['ordem'];
            $centrocusto->empresaid = $empresaid;
            $centrocusto->usuariooperacao = $this->usuarioid();

            if (!$centrocustoTable->save($centrocusto)) {
                $this->Flash->error("Não foi Possível cadastrar o Centro de Custo! Por favor, tente novamente.");
            } else {
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
            }
            return $this->redirect('/flystart/financeiro/');
        }

        $this->set(compact([
            'centrocusto'
            ,'empresa'
        ]));
    }

    public function delete($id){
        $centrocustoTable = TableRegistry::get('centrocusto');
        $centrocusto = $this->get('centrocusto','centrocustoid',$id);

        if($centrocustoTable->delete($centrocusto)){
            $this->Flash->success("Centro Custo excluído com Sucesso!");
            return $this->redirect('/flystart/financeiro/');
        }
        $this->Flash->success("Ocorreu um erro ao tentar excluir Centro Custo");
    }
}