<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;


class CliforController extends AppController
{
    public function initialize() {
        parent::initialize();
        $this->loadComponent('RequestHandler');
    }

    public function index(){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $pessoa = $this->getAllTableWhere('pessoa',[],[]);
        $this->set(compact([
            'pessoa'
            ,'empresa'
        ]));
    }
    public function cadfinanceiro(){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $this->set(compact([
            'empresa'
        ]));
    }

    public function salvarpessoafinanceiro(){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        if ($this->request->is('post')) {
            $data = $this->request->getData();   
            $cpfcnpj = $data['cpfcnpj'];
            $cpfcnpj = str_replace(".","",$cpfcnpj);
            $cpfcnpj = str_replace(",","",$cpfcnpj);
            $cpfcnpj = str_replace("-","",$cpfcnpj);
            $cpfcnpj = str_replace("/","",$cpfcnpj);
            $pessoaTable = TableRegistry::get('pessoa');
            $pessoa = $pessoaTable->newEntity();
            $pessoa = $pessoaTable->patchEntity($pessoa,$data);
            $pessoa->nome = $data['nome'];
            $pessoa->cpfcnpj = $cpfcnpj;
            $pessoa->empresaid=$empresaid;
            $pessoa = $pessoaTable->save($pessoa);
            if ($pessoa) {
                $this->set('val','Cliente/Fornecedor salvo com sucesso.');
                $this->set('id',$pessoa->pessoaid);
                $this->set('nome',$pessoa->nome);
                $this->set('_serialize',array('val','id','nome'));
                $this->response->statusCode(200);
            } else {
                $this->set('val','Cliente/Fornecedor não pode ser salvo.');
                $this->set('_serialize',array('val'));
                $this->response->statusCode(500);
            }
        }

        /*  $this->response->body('ok!');
         return $this->response; */
       
    }

    public function add(){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $cpfcnpj = $data['cpfcnpj'];
            $cpfcnpj = str_replace(".","",$cpfcnpj);
            $cpfcnpj = str_replace(",","",$cpfcnpj);
            $cpfcnpj = str_replace("-","",$cpfcnpj);
            $cpfcnpj = str_replace("/","",$cpfcnpj);
            $pessoaTable = TableRegistry::get('pessoa');
            $pessoa = $pessoaTable->newEntity();
            $pessoa = $pessoaTable->patchEntity($pessoa,$data);
            $pessoa->empresaid=$empresaid;
            if (!$pessoaTable->save($pessoa)) {
                $this->Flash->error("Não foi Possível cadastrar o Cliente/Fornecedor! Por favor, tente novamente.");
            } else {
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
            }
            return $this->redirect('/flystart/financeiro/');

        }
        $this->set(compact([
            'empresa'
        ]));
    }

    public function edit($id){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $pessoa = $this->get('pessoa', 'pessoaid', $id);
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $pessoaTable = TableRegistry::get('pessoa');
            $pessoa = $pessoaTable->newEntity();
            $pessoa = $pessoaTable->patchEntity($pessoa,$data);
            $pessoa->empresaid=$empresaid;
            //$this->d($pessoa);
            if (!$pessoaTable->save($pessoa)) {
                $this->Flash->error("Não foi Possível cadastrar o Centro de Custo! Por favor, tente novamente.");
            } else {
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
            }
            return $this->redirect('/flystart/financeiro/');
        }
        $this->set(compact([
            'empresa'
            ,'pessoa'
        ]));


    }

    public function buscapessoa($busca=null){ 
        if($busca != null){
            $busca = str_replace("/","",str_replace("-","",str_replace(".","",$busca)));
            $sql = "
                SELECT pessoa.pessoaid, UPPER(pessoa.nome) as nome, pessoa.datanascimento, pessoa.tipopessoa, REPLACE(REPLACE(REPLACE(pessoa.cpfcnpj, '/',''),'-',''),'.','') as cpfcnpj from pessoa
                where pessoa.nome like ('%$busca%') or REPLACE(REPLACE(REPLACE(pessoa.cpfcnpj, '/',''),'-',''),'.','') like ('%$busca%')
                group by pessoa.pessoaid
                LIMIT 20
            ";
            $pessoa = $this->query($sql);
            $this->set([
                'pessoa' => $pessoa,
            ]);
        }
    }

    public function delete($id){
        $pessoaTable = TableRegistry::get('pessoa');
        $pessoa = $this->get('pessoa','pessoaid',$id);

        if($pessoaTable->delete($pessoa)){
            $this->Flash->success("Cliente/Fornecedor excluído com Sucesso!");
            return $this->redirect('/flystart/financeiro/');
        }
        $this->Flash->success("Ocorreu um erro ao tentar excluir Centro Custo");
    }
}