<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;


class ContabancoController extends AppController
{   
    public function index(){
        $contabanco = $this->getAllTableWhere('contabanco',[],[])->all();
        //$this->d($contas->all());
        $this->set(compact([
            'contabanco'
        ]));
    }
    
    public function add(){
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $bancos = $this->getAllTableWhere('banco',[],[])->all();
        
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $contabancoTable = TableRegistry::get('contabanco');
            $data['saldoatual']=str_replace(',','.',str_replace('.','',$data['saldoatual']));
            $contabanco = $contabancoTable->newEntity();
            $contabanco = $contabancoTable->patchEntity($contabanco,$data);
            if($contabancoTable->save($contabanco)){
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
                return $this->redirect('/flystart/financeiro/');
            }
            $this->Flash->error("Não foi Possível cadastrar a Conta Bancária! Por favor, tente novamente.");
            
        }
        $this->set(compact([
            'empresa',
            'bancos'
        ]));
    }

    public function edit($id){
        $contabanco = $this->get('contabanco','contabancoid',$id);
        $bancos = $this->getAllTableWhere('banco',[],[])->all();
        $tipoconta =[];
        array_push($tipoconta,'Corrente');
        array_push($tipoconta,'Poupança');

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $contabancoTable = TableRegistry::get('contabanco');
            $data['saldoatual']=str_replace(',','.',str_replace('.','',$data['saldoatual']));
            $data['saldoanterior'] = $contabanco->saldoatual;
            $data['saldoanterior_data']= Date('Y-m-d h:i:s');
            $contabanco = $contabancoTable->patchEntity($contabanco,$data);
            if($contabancoTable->save($contabanco)){
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
                return $this->redirect('/flystart/financeiro/');
            }
            $this->Flash->error("Não foi Possível cadastrar a Conta Bancária! Por favor, tente novamente.");
            
        }

        $this->set(compact([
            'contabanco',
            'bancos',
            'tipoconta'
        ])); 
    }

    public function delete($id){
        $contabancoTable = TableRegistry::get('contabanco');
        $contabanco = $this->get('contabanco','contabancoid',$id);

        if($contabancoTable->delete($contabanco)){
            $this->Flash->success("Conta Bancária excluída com Sucesso!");
            return $this->redirect('/flystart/financeiro/');
        }
        $this->Flash->success("Ocorreu um erro ao tentar excluir Conta Bancária");

    }
}