<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Datasource\ConnectionManager;

/**
 * Modulo Controller
 *
 * @property \App\Model\Table\ModuloTable $Modulo
 *
 * @method \App\Model\Entity\Modulo[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ModuloController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $modulo = $this->paginate($this->Modulo);
        $this->set(compact('modulo'));
    }

    /**
     * View method
     *
     * @param string|null $id Modulo id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $modulo = $this->get('Modulo','idmodulo',$id);
        $this->set('modulo', $modulo);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $moduloTable = TableRegistry::get('Modulo');
        $modulo = $moduloTable->newEntity();
        if ($this->request->is('post')) {
            $modulo = $moduloTable->patchEntity($modulo, $this->request->getData());
            if ($moduloTable->save($modulo)) {
                $this->Flash->success(__('The modulo has been saved.'));
                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The modulo could not be saved. Please, try again.'));
        }
        $this->set(compact('modulo'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Modulo id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $modulo = $this->get('Modulo','idmodulo',$id);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $moduloTable = TableRegistry::get('Modulo');
            $modulo = $moduloTable->patchEntity($modulo, $this->request->getData());
            if ($moduloTable->save($modulo)) {
                $this->Flash->success(__('The modulo has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The modulo could not be saved. Please, try again.'));
        }
        $this->set(compact('modulo'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Modulo id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $modulo = $moduloTable->get($id);
        $moduloTable = TableRegistry::get('Modulo');
        if ($moduloTable->delete($modulo)) {
            $this->Flash->success(__('The modulo has been deleted.'));
        } else {
            $this->Flash->error(__('The modulo could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
