<?php
namespace App\Controller\Adm;

use App\Controller\AppController;

/**
 * Operadora Controller
 *
 * @property \App\Model\Table\OperadoraTable $Operadora
 *
 * @method \App\Model\Entity\Operadora[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class OperadoraController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $operadora = $this->paginate($this->Operadora);

        $this->set(compact('operadora'));
    }

    /**
     * View method
     *
     * @param string|null $id Operadora id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $operadora = $this->Operadora->get($id, [
            'contain' => []
        ]);

        $this->set('operadora', $operadora);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $operadora = $this->Operadora->newEntity();
        if ($this->request->is('post')) {
            $operadora = $this->Operadora->patchEntity($operadora, $this->request->getData());
            if ($this->Operadora->save($operadora)) {
                $this->Flash->success(__('The operadora has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The operadora could not be saved. Please, try again.'));
        }
        $this->set(compact('operadora'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Operadora id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $operadora = $this->Operadora->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $operadora = $this->Operadora->patchEntity($operadora, $this->request->getData());
            if ($this->Operadora->save($operadora)) {
                $this->Flash->success(__('The operadora has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The operadora could not be saved. Please, try again.'));
        }
        $this->set(compact('operadora'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Operadora id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $operadora = $this->Operadora->get($id);
        if ($this->Operadora->delete($operadora)) {
            $this->Flash->success(__('The operadora has been deleted.'));
        } else {
            $this->Flash->error(__('The operadora could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
