<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\ORM\TableRegistry;


class PlanocontaController extends AppController
{/*
    public function beforeRender(Event $event)
    {
		$session = $this->request->session();
		$count = 0;
		foreach ($session->read('login.modulos') as $modulo) {
			if ($modulo->chave == 'estoque'){
				$count = 1;
				break;
			} 
		}
		if ($count == 0) {
            $this->Flash->error("Acesso Negado!");
			return $this->redirect($this->referer());	
		}
    }*/
    public function index() {
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $planosconta = $this->getAllTableWhere('Planoconta',['empresaid'=>$empresaid],['ativo'=>'DESC', 'ordem'=>'ASC']);

        $this->set(compact([
            'planosconta'
            ,'empresa'
        ]));
    }
    
    public function cadfinanceiro(){
        $data = $_GET['data'];
        
        $planocontaTable = TableRegistry::get('planoconta');
        $planoconta = $planocontaTable->newEntity();

        $planoconta->nome = $data;
        $planoconta->ativo = 1;
        $planoconta->empresaid = $this->empresaid();
        $planoconta->usuariooperacao = $this->usuarioid();

        $planosave = $planocontaTable->save($planoconta);
        if($planosave){
            $this->set('val','Plano Conta salvo com sucesso.');
            $this->set('id',$planosave->planocontaid);
            $this->set('nome',$planosave->nome);
            $this->set('_serialize',array('val','id','nome'));
            $this->response->statusCode(200);
        }else{
            $this->set('val','Plano Conta não pode ser salvo.');
            $this->set('_serialize',array('val'));
            $this->response->statusCode(500);
        }

    }

    public function add() {
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $planocontaTable = TableRegistry::get('Planoconta');
            $planoconta = $planocontaTable->newEntity();
            $planoconta->nome = $data['nome'];
            $planoconta->ativo = $data['ativo'];
            $planoconta->ordem = $data['ordem'];
            $planoconta->empresaid = $empresaid;
            $planoconta->usuariooperacao = $this->usuarioid();

            if (!$planocontaTable->save($planoconta)) {
                $this->Flash->error("Não foi Possível cadastrar o Plano de Conta! Por favor, tente novamente.");
            } else {
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
            }
            return $this->redirect('/flystart/financeiro/');
        }

        $this->set(compact([
            'empresa'
        ]));
    }

    public function edit($id) {
        $empresaid = $this->empresaid();
        $empresa = $this->get('Empresa_crm', 'empresaid', $empresaid);
        $planoconta = $this->get('Planoconta', 'planocontaid', $id);
        
        if (!isset($planoconta->planocontaid)) {
            $this->Flash->error("Plano Conta não Cadastrado!");
            return $this->redirect($this->referer());
        }
        if ($empresaid != $planoconta->empresaid) {
            $this->Flash->error("Acesso Negado!");
            return $this->redirect($this->referer());
        }

        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $planocontaTable = TableRegistry::get('Planoconta');
            $planoconta->nome = $data['nome'];
            $planoconta->ativo = $data['ativo'];
            $planoconta->ordem = $data['ordem'];
            $planoconta->empresaid = $empresaid;
            $planoconta->usuariooperacao = $this->usuarioid();

            if (!$planocontaTable->save($planoconta)) {
                $this->Flash->error("Não foi Possível cadastrar o Plano de Conta! Por favor, tente novamente.");
            } else {
                $this->Flash->success("Cadastro Efetuado com Sucesso!");
            }
            return $this->redirect('/flystart/financeiro/');
        }

        $this->set(compact([
            'planoconta'
            ,'empresa'
        ]));
    }

    public function delete($id){
        $planocontaTable = TableRegistry::get('planoconta');
        $planoconta = $this->get('planoconta','planocontaid',$id);

        if($planocontaTable->delete($planoconta)){
            $this->Flash->success("Plano Conta excluído com Sucesso!");
            return $this->redirect('/flystart/financeiro/');
        }
        $this->Flash->success("Ocorreu um erro ao tentar excluir Plano Conta");
    }
}