<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;

/**
 * Segmento Controller
 *
 * @property \App\Model\Table\SegmentoTable $Segmento
 *
 * @method \App\Model\Entity\Segmento[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class SegmentoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $segmento = $this->paginate($this->Segmento);

        $this->set(compact('segmento'));
    }

    /**
     * View method
     *
     * @param string|null $id Segmento id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $segmento = $this->Segmento->get($id, [
            'contain' => []
        ]);

        $this->set('segmento', $segmento);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $segmento = $this->Segmento->newEntity();
        if ($this->request->is('post')) {
            $segmento = $this->Segmento->patchEntity($segmento, $this->request->getData());
            if ($this->Segmento->save($segmento)) {
                $this->Flash->success(__('Segmento salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Segmento não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('segmento'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Segmento id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $segmento = $this->Segmento->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $segmento = $this->Segmento->patchEntity($segmento, $this->request->getData());
            if ($this->Segmento->save($segmento)) {
                $this->Flash->success(__('Segmento salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Segmento não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('segmento'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Segmento id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $segmento = $this->Segmento->get($id);
        if ($this->Segmento->delete($segmento)) {
            $this->Flash->success(__('Segmento deletado com sucesso'));
        } else {
            $this->Flash->error(__('TSegmento não pode ser deletado. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
