<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;

/**
 * Statuscontato Controller
 *
 * @property \App\Model\Table\StatuscontatoTable $Statuscontato
 *
 * @method \App\Model\Entity\Statuscontato[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class StatuscontatoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {   
        $sql = "SELECT f.descricao,f.idfunil, GROUP_CONCAT(st.nome SEPARATOR ', ') AS statuscontato FROM statuscontato st
                LEFT JOIN funil f on f.idfunil = st.funilid 
                GROUP BY st.funilid";
        $statusfunil = $this->query($sql);

        $this->set(compact('statusfunil'));
    }

    public function list($idfunil){
        $allstatuscontato = $this->getAllTableWhere('statuscontato',['funilid'=>$idfunil],[]);
        $statuscontato = $this->paginate($allstatuscontato);

        $this->set(compact('statuscontato'));
    }
    /**
     * View method
     *
     * @param string|null $id Statuscontato id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $statuscontato = $this->Statuscontato->get($id, [
            'contain' => []
        ]);

        $this->set('statuscontato', $statuscontato);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $funis = $this->getAllTableWhere('funil',[],[])->all();
        $statuscontato = $this->Statuscontato->newEntity();
        if ($this->request->is('post')) {
            $statuscontato = $this->Statuscontato->patchEntity($statuscontato, $this->request->getData());
            if ($this->Statuscontato->save($statuscontato)) {
                $this->Flash->success(__('Status Contato salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Status Contato não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('statuscontato','funis'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Statuscontato id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $statuscontato = $this->Statuscontato->get($id, [
            'contain' => []
        ]);
        $funis = $this->getAllTableWhere('funil',[],[])->all();
        if ($this->request->is(['patch', 'post', 'put'])) {
            $statuscontato = $this->Statuscontato->patchEntity($statuscontato, $this->request->getData());
            if ($this->Statuscontato->save($statuscontato)) {
                $this->Flash->success(__('Status Contato salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Status Contato não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('statuscontato','funis'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Statuscontato id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $statuscontato = $this->Statuscontato->get($id);
        if ($this->Statuscontato->delete($statuscontato)) {
            $this->Flash->success(__('Status Contato deletado com sucesso.'));
        } else {
            $this->Flash->error(__('Status Contato não pode ser deletado. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
