<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;

/**
 * Tipoacomodacao Controller
 *
 * @property \App\Model\Table\TipoacomodacaoTable $Tipoacomodacao
 *
 * @method \App\Model\Entity\Tipoacomodacao[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TipoacomodacaoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $tipoacomodacao = $this->paginate($this->Tipoacomodacao);

        $this->set(compact('tipoacomodacao'));
    }

    /**
     * View method
     *
     * @param string|null $id Tipoacomodacao id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $tipoacomodacao = $this->Tipoacomodacao->get($id, [
            'contain' => []
        ]);

        $this->set('tipoacomodacao', $tipoacomodacao);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tipoacomodacao = $this->Tipoacomodacao->newEntity();
        if ($this->request->is('post')) {
            $tipoacomodacao = $this->Tipoacomodacao->patchEntity($tipoacomodacao, $this->request->getData());
			$tipoacomodacao->pessoaidcadastro = $this->pessoaid();
			$tipoacomodacao->empresaid        = $this->empresaid();
            if ($this->Tipoacomodacao->save($tipoacomodacao)) {
                $this->Flash->success(__('Tipo Acomodação salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Tipo Acomodação não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('tipoacomodacao'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Tipoacomodacao id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tipoacomodacao = $this->Tipoacomodacao->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $tipoacomodacao = $this->Tipoacomodacao->patchEntity($tipoacomodacao, $this->request->getData());
            if ($this->Tipoacomodacao->save($tipoacomodacao)) {
                $this->Flash->success(__('Tipo Acomodação salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Tipo Acomodação não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('tipoacomodacao'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Tipoacomodacao id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $tipoacomodacao = $this->Tipoacomodacao->get($id);
        if ($this->Tipoacomodacao->delete($tipoacomodacao)) {
            $this->Flash->success(__('Tipo Acomodação salvo com sucesso.'));
        } else {
            $this->Flash->error(__('Tipo Acomodação não pode ser salvo. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
