<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;

/**
 * Tipocontato Controller
 *
 * @property \App\Model\Table\TipocontatoTable $Tipocontato
 *
 * @method \App\Model\Entity\Tipocontato[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TipocontatoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $tipocontato = $this->paginate($this->Tipocontato);

        $this->set(compact('tipocontato'));
    }

    /**
     * View method
     *
     * @param string|null $id Tipocontato id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $tipocontato = $this->Tipocontato->get($id, [
            'contain' => []
        ]);

        $this->set('tipocontato', $tipocontato);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tipocontato = $this->Tipocontato->newEntity();
        if ($this->request->is('post')) {
            $tipocontato = $this->Tipocontato->patchEntity($tipocontato, $this->request->getData());
            if ($this->Tipocontato->save($tipocontato)) {
                $this->Flash->success(__('Tipo Contato salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Tipo Contato não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('tipocontato'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Tipocontato id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tipocontato = $this->Tipocontato->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $tipocontato = $this->Tipocontato->patchEntity($tipocontato, $this->request->getData());
            if ($this->Tipocontato->save($tipocontato)) {
                $this->Flash->success(__('Tipo Contato salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Tipo Contato não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('tipocontato'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Tipocontato id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $tipocontato = $this->Tipocontato->get($id);
        if ($this->Tipocontato->delete($tipocontato)) {
            $this->Flash->success(__('Tipo Contato deletado com sucesso.'));
        } else {
            $this->Flash->error(__('Tipo Contato não pode ser deletado. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
