<?php
namespace App\Controller\Flystart\Cfg;

use App\Controller\AppController;

/**
 * Tipolead Controller
 *
 * @property \App\Model\Table\TipoleadTable $Tipolead
 *
 * @method \App\Model\Entity\Tipolead[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TipoleadController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $tipolead = $this->paginate($this->Tipolead);

        $this->set(compact('tipolead'));
    }

    /**
     * View method
     *
     * @param string|null $id Tipolead id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $tipolead = $this->Tipolead->get($id, [
            'contain' => []
        ]);

        $this->set('tipolead', $tipolead);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $tipolead = $this->Tipolead->newEntity();
        if ($this->request->is('post')) {
            $tipolead = $this->Tipolead->patchEntity($tipolead, $this->request->getData());
            if ($this->Tipolead->save($tipolead)) {
                $this->Flash->success(__('Tipo Lead salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Tipo Lead não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('tipolead'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Tipolead id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $tipolead = $this->Tipolead->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $tipolead = $this->Tipolead->patchEntity($tipolead, $this->request->getData());
            if ($this->Tipolead->save($tipolead)) {
                $this->Flash->success(__('Tipo Lead salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Tipo Lead não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('tipolead'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Tipolead id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $tipolead = $this->Tipolead->get($id);
        if ($this->Tipolead->delete($tipolead)) {
            $this->Flash->success(__('Tipo Lead deletado com sucesso.'));
        } else {
            $this->Flash->error(__('Tipo Lead não pode ser deletado. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
