<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
use \DateTime;

class ClienteController extends AppController
{
	public function beforeRender(Event $event) {
        
		$perfilid = $this->perfilid();
		$empresaid = $this->empresaid();
        

		$action = $this->request->getParam('action');
		if($this->$perfilid == 5 && in_array($action,['view','edit'])){
			$id = $this->request->getParam('pass');
			
			$cliente = $this->Cliente->get($id, [
				'contain' => []
			]);
			
			if($empresaid != $cliente->empresaid){
				echo "Cliente não pertence à sua empresa.";
				exit();
			}
			
		}
		return parent::beforeRender($event);
	}

	public function apibuscar($id = null){
		$sql = "SELECT 
					c.clienteid
					,p.nome
					,p.cpfcnpj AS cpf
					,p.datanascimento
					,CASE WHEN p.datanascimento <> TRIM('')
						then YEAR(FROM_DAYS(TO_DAYS(NOW())-TO_DAYS(p.datanascimento)))
						ELSE NULL END AS idade
					,p.email
					,'' AS telefone
					,'' AS logradouro
					,'' AS numero
					,'' AS bairro
					,'' AS complemento
					,'' AS cep 
				FROM cliente c 
				INNER JOIN pessoa p ON p.pessoaid = c.pessoaid
				WHERE 
					(p.cpfcnpj = '$id' OR p.nome LIKE '%$id%' )
					AND p.datanascimento IS NOT NULL
					AND p.cpfcnpj IS NOT NULL
				ORDER BY p.nome
				LIMIT 100";
		$result = $this->query($sql);
		header('Content-type: application/json');
		echo json_encode( $result );
		exit();
	}
	
	public function buscar(){
		$busca = "";
		if(isset($_GET['busca'])){
			$busca = preg_replace("/[^a-zA-Z0-9-'\s]+/", "", $_GET['busca']);
		}
		
		$perfilid = $this->perfilid();
		$clientewherearr = ["1"=>"2"];
		
		//adm empresa, gerente, secretaria
		if(in_array($perfilid,[3,4,6])){
			$clientewherearr = ['cliente.empresaid'=>$this->empresaid()];
		}
		
		//adm grupo
		if(in_array($perfilid,[2])){
			$clientewherearr = ['cliente.empresaid IN'=>$this->grupoempresarialid()];
		}
		
		$clienteTable = TableRegistry::get('cliente');
		$query = $clienteTable->find('all')
						->innerJoin('pessoa','pessoa.pessoaid = cliente.pessoaid')
						->where([
							'pessoa.nome like'=>"%$busca%"
						])->orWhere([
							'pessoa.razaosocial like'=>"%$busca%"
							])->orWhere([
							'pessoa.cpfmae like'=>"%$busca%"
						])->orWhere([
							'cliente.clienteid'=>$busca
						])->andWhere($clientewherearr)
						->order(['pessoa.nome'=>'ASC'
								,'pessoa.razaosocial' =>'ASC'
								,'pessoa.data_criacao'=>'DESC'
								]);

		$resultadoarr = $this->paginate($query,['limit'=>20]);

		$clienteidarr = [];
		foreach ($resultadoarr as $resultado){
			array_push($clienteidarr, $resultado->clienteid);
		}
		
		$temcontatoarr = [];
		for($i=0; $i < count($clienteidarr); $i++){
			$sql = "SELECT * from contato where clienteid = '$clienteidarr[$i]'";
			$temcontato = $this->query($sql);

			if(empty($temcontato)){
				array_push($temcontatoarr, 0);
			} else{
				array_push($temcontatoarr, 1);
			}

		}
	

		$this->set('_serialize', ['resultadoarr']);
		$this->set([
			'resultadoarr'=>$resultadoarr
			,'busca'=>$busca
			,'temcontatoarr'=>$temcontatoarr
		]);
	}

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
		
		$perfilid =$this->perfilid();
		$empresaid =$this->empresaid();
		$clientewherearr = ['1 = 1'];
		
		//adm empresa, gerente, secretaria
		if(in_array($perfilid,[3,4,6])){
			$clientewherearr = ['empresaid'=>$empresaid];
		}else if($perfilid==5){
			$clientewherearr = ['vendedorid'=>$this->vendedorid()];
		}
				
		$clientes = $this->getAllTableWhere('Cliente',[$clientewherearr],['clienteid'=>'DESC']);
        $this->set(compact('clientes'));
		$this->set([
			'perfilid'=>$perfilid
		]);
    }

    /**
     * View method
     *
     * @param string|null $id Cliente id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {	
		$perfilid = $this->perfilid();
        $cliente = $this->Cliente->get($id, [
            'contain' => []
		]);
		$pessoa = $this->get('pessoa','pessoaid',$cliente->pessoaid);
		$telefones = $this->getAllTableWhere('telefone',['pessoaid'=>$pessoa->pessoaid],['tipotelefone'=>'asc'])->toArray();
		$enderecos = $this->getAllTableWhere('endereco',['pessoaid'=>$pessoa->pessoaid],['tipoendereco'=>'asc'])->toArray();
	
		$isAjax = false;
		if(isset($_GET['isAjax']) && $_GET['isAjax'] == 1){
			$isAjax = true;
		}
		
        $this->set([
			'cliente'=>$cliente
			,'pessoa'=>$pessoa
			,'telefones'=>$telefones
			,'enderecos'=>$enderecos
			,'isAjax'=>$isAjax
			,'perfilid'=> $perfilid
		]);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
	
		$perfilid = $this->perfilid();
        $cliente = $this->Cliente->newEntity();
		$vendedorid =  $this->vendedorid();
		$empresaid =$this->empresaid();
		$segmento = $this->getAllTableWhere('segmento',[],['nome'=>'asc']);
		
        if ($this->request->is('post')) {
            $data = $this->request->getData();
			
			//administrador e secretaria sistema
			if(in_array($perfilid,[1,7]) && strlen($data['empresaid'])>0){
				$empresaid = $data['empresaid'];
			}
			
			if(in_array($perfilid,[1,2,3,4,6])){
				$vendedorid = $data['vendedorid'];
			}
			
			//pessoa
			$pessoaTable = TableRegistry::get('Pessoa');
			$pessoa = $pessoaTable->newEntity();
			
			if($this->validaData($data['datanascimento'])){
				$data['datanascimento'] = $this->formatDataToDatabase($data['datanascimento']);
			}else{
				$data['datanascimento'] = null;
			}
			$pessoa = $pessoaTable->patchEntity($pessoa, $data);
			$pessoa->pessoaidcadastro = $this->pessoaid();
			$pessoa->empresaid = $empresaid;
			
			if(!$pessoaTable->save($pessoa)){
				echo "Pessoa não pode ser salva<br>";$this->d($pessoa);
			}
			
			$pessoaid = $pessoa->pessoaid;
			
			//cliente
			$clienteTable = TableRegistry::get('Cliente');
			$cliente = $clienteTable->newEntity();
			
			if($this->validaData($data['data_cliente'])){
				$data['data_cliente'] = $this->formatDataToDatabase($data['data_cliente']).' 00:00:00';
			}else{
				$data['data_cliente'] = null;
			}
			
			$cliente = $clienteTable->patchEntity($cliente, $data);
			$cliente->pessoaid = $pessoaid;
			$cliente->pessoaidcadastro = $this->pessoaid();
			$cliente->empresaid  = $empresaid;
			$cliente->vendedorid = $vendedorid;
			if(!$clienteTable->save($cliente)){
				$this->remove('pessoa',[
					'pessoaid'=>$pessoaid
				]);
				echo "Cliente não pode ser salvo<br>";$this->d($cliente);
			}
			
			$clienteid = $cliente->clienteid;
			
			
			if(isset($data['produtoid'])){
				$contatoTable = TableRegistry::get('contato');
				$contato = $contatoTable->newEntity();
				$contato->pessoaidcadastro = $this->pessoaid();
				$contato->empresaid = $this->empresaid();
				$contato->clienteid = $clienteid;
				if(!$contatoTable->save($contato)){
					$this->remove('pessoa',[
						'pessoaid'=>$pessoaid
					]);
					$this->remove('cliente',[
						'pessoaid'=>$pessoaid
					]);
					echo "Contato não pode ser salvo<br>";$this->d($contato);
				}
				
				foreach($data['produtoid'] as $item){
					$this->insert('produtointeresse',[
						'contatoid'      =>$contato->contatoid
						,'clienteid'  	 =>$clienteid
						,'produtoid'     =>$item
						,'empresaid'	 =>$empresaid
						,'pessoaidcadastro'=>$this->pessoaid()
					]);
				}
			}
			
			
			if(isset($data['telnumero1']) && strlen($data['telnumero1']) > 0){
				$this->insert('telefone',[
					'pessoaid'	     	=>$pessoaid
					,'codigopais'	 	=>$data['codigopais1']
					,'ddd'				=>$data['ddd1']
					,'numero'			=>$data['telnumero1']
					,'tipotelefone'	    =>$data['tipotelefone1']
					,'empresaid'	 	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(isset($data['telnumero2']) && strlen($data['telnumero2']) > 0){
				$this->insert('telefone',[
					'pessoaid'	     	=>$pessoaid
					,'codigopais'	 	=>$data['codigopais2']
					,'ddd'				=>$data['ddd2']
					,'numero'			=>$data['telnumero2']
					,'tipotelefone'  	=>$data['tipotelefone2']
					,'empresaid'	 	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(isset($data['telnumero3']) && strlen($data['telnumero3']) > 0){
				$this->insert('telefone',[
					'pessoaid'	     	=>$pessoaid
					,'codigopais'	 	=>$data['codigopais3']
					,'ddd'				=>$data['ddd3']
					,'numero'			=>$data['telnumero3']
					,'tipotelefone'  	=>$data['tipotelefone3']
					,'empresaid'	 	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(strlen($data['cep1']) >0 
			|| strlen($data['logradouro1'])>0 
			|| strlen($data['bairro1']    )>0
			|| strlen($data['cidade1']    )>0
			|| strlen($data['estado1']    )>0){
				$this->insert('endereco',[
					'pessoaid'	    =>$pessoaid
					,'logradouro'   =>$data['logradouro1'  ]
					,'cidade' 	    =>$data['cidade1' 	   ]
					,'estado' 	    =>$data['estado1' 	   ]
					,'pais' 	    =>$data['pais1' 	   ]
					,'bairro' 	    =>$data['bairro1' 	   ]
					,'numero' 	    =>$data['numero1' 	   ]
					,'complemento'  =>$data['complemento1' ]	
					,'tipoendereco' =>$data['tipoendereco1']
					,'cep' 	        =>$data['cep1' 	       ]
					,'observacoes ' =>$data['observacoes1' ]	
					,'latlong'      =>$data['latlong1'     ]
					,'empresaid'	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(strlen($data['cep2']) >0 
			|| strlen($data['logradouro2'])>0 
			|| strlen($data['bairro2']    )>0
			|| strlen($data['cidade2']    )>0
			|| strlen($data['estado2']    )>0){
				
				$this->insert('endereco',[
					'pessoaid'	    =>$pessoaid
					,'logradouro'   =>$data['logradouro2'  ]
					,'cidade' 	    =>$data['cidade2' 	   ]
					,'estado' 	    =>$data['estado2' 	   ]
					,'pais' 	    =>$data['pais2' 	   ]
					,'bairro' 	    =>$data['bairro2' 	   ]
					,'numero' 	    =>$data['numero2' 	   ]
					,'complemento'  =>$data['complemento2' ]	
					,'tipoendereco' =>$data['tipoendereco2']
					,'cep' 	        =>$data['cep2' 	       ]
					,'observacoes ' =>$data['observacoes2' ]	
					,'latlong'      =>$data['latlong2'     ]
					,'empresaid'	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			

            $this->Flash->success(__('Cliente cadastrado com sucesso'));
            return $this->redirect(['action' => 'index']);
        }
        $this->set(compact('cliente'));
		$this->set([
			'perfilid'=>$perfilid
			,'empresaid'=>$this->empresaid()
			,'segmento'=>$segmento
		]);
    }
    /**
     * Add_Rapido method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add_rapido()
    {
  
        $perfilid = $this->perfilid();
        $cliente = $this->Cliente->newEntity();
		$vendedorid =  $this->vendedorid();
		$empresaid = $this->empresaid();
		$segmento = $this->getAllTableWhere('segmento',[],['nome'=>'asc']);
		
        if ($this->request->is('post')) {
            $data = $this->request->getData();
			
			//administrador e secretaria sistema
			if(in_array($perfilid,[1,7]) && strlen($data['empresaid'])>0){
				$empresaid = $data['empresaid'];
			}
			
			if(in_array($perfilid,[1,2,3,4,6])){
				$vendedorid = $data['vendedorid'];
			}
			
			//pessoa
			$pessoaTable = TableRegistry::get('Pessoa');
			$pessoa = $pessoaTable->newEntity();
			
			/*if($this->validaData($data['datanascimento'])){
				$data['datanascimento'] = $this->formatDataToDatabase($data['datanascimento']);
			}else{
				$data['datanascimento'] = null;
			}*/
			$pessoa = $pessoaTable->patchEntity($pessoa, $data);
			$pessoa->pessoaidcadastro = $this->pessoaid();
			$pessoa->empresaid = $empresaid;
			if(!$pessoaTable->save($pessoa)){
				echo "Pessoa não pode ser salva<br>";$this->d($pessoa);
			}
			
			$pessoaid = $pessoa->pessoaid;
			
			//cliente
			$clienteTable = TableRegistry::get('Cliente');
			$cliente = $clienteTable->newEntity();
			
			/*if($this->validaData($data['data_cliente'])){
				$data['data_cliente'] = $this->formatDataToDatabase($data['data_cliente']).' 00:00:00';
			}else{
				$data['data_cliente'] = null;
			}*/
			
			$cliente = $clienteTable->patchEntity($cliente, $data);
			$cliente->pessoaid = $pessoaid;
			$cliente->pessoaidcadastro = $this->pessoaid();
			$cliente->empresaid  = $empresaid;
			$cliente->vendedorid = $vendedorid;
			$cliente->observacao = $data['observacoes3'];
			
			if(!$clienteTable->save($cliente)){
				$this->remove('pessoa',[
					'pessoaid'=>$pessoaid
				]);
				echo "Cliente não pode ser salvo<br>";$this->d($cliente);
			}
			
			$clienteid = $cliente->clienteid;
			
			
			if(isset($data['produtoid'])){
				$contatoTable = TableRegistry::get('contato');
				$contato = $contatoTable->newEntity();
				$contato->pessoaidcadastro = $this->pessoaid();
				$contato->empresaid = $this->empresaid();
				$contato->clienteid = $clienteid;
				if(!$contatoTable->save($contato)){
					$this->remove('pessoa',[
						'pessoaid'=>$pessoaid
					]);
					$this->remove('cliente',[
						'pessoaid'=>$pessoaid
					]);
					echo "Contato não pode ser salvo<br>";$this->d($contato);
				}
				
				foreach($data['produtoid'] as $item){
					$this->insert('produtointeresse',[
						'contatoid'      =>$contato->contatoid
						,'clienteid'  	 =>$clienteid
						,'produtoid'     =>$item
						,'empresaid'	 =>$empresaid
						,'pessoaidcadastro'=>$this->pessoaid()
					]);
				}
			}
			
			
			if(isset($data['telnumero1']) && strlen($data['telnumero1']) > 0){
				$this->insert('telefone',[
					'pessoaid'	     	=>$pessoaid
					,'codigopais'	 	=>$data['codigopais1']
					,'ddd'				=>$data['ddd1']
					,'numero'			=>$data['telnumero1']
					,'tipotelefone'	    =>$data['tipotelefone1']
					,'empresaid'	 	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(isset($data['telnumero2']) && strlen($data['telnumero2']) > 0){
				$this->insert('telefone',[
					'pessoaid'	     	=>$pessoaid
					,'codigopais'	 	=>$data['codigopais2']
					,'ddd'				=>$data['ddd2']
					,'numero'			=>$data['telnumero2']
					,'tipotelefone'  	=>$data['tipotelefone2']
					,'empresaid'	 	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(isset($data['telnumero3']) && strlen($data['telnumero3']) > 0){
				$this->insert('telefone',[
					'pessoaid'	     	=>$pessoaid
					,'codigopais'	 	=>$data['codigopais3']
					,'ddd'				=>$data['ddd3']
					,'numero'			=>$data['telnumero3']
					,'tipotelefone'  	=>$data['tipotelefone3']
					,'empresaid'	 	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(strlen($data['cep1']) >0 
			|| strlen($data['logradouro1'])>0 
			|| strlen($data['bairro1']    )>0
			|| strlen($data['cidade1']    )>0
			|| strlen($data['estado1']    )>0){
				$this->insert('endereco',[
					'pessoaid'	    =>$pessoaid
					,'logradouro'   =>$data['logradouro1'  ]
					,'cidade' 	    =>$data['cidade1' 	   ]
					,'estado' 	    =>$data['estado1' 	   ]
					,'pais' 	    =>$data['pais1' 	   ]
					,'bairro' 	    =>$data['bairro1' 	   ]
					,'numero' 	    =>$data['numero1' 	   ]
					,'complemento'  =>$data['complemento1' ]	
					,'tipoendereco' =>$data['tipoendereco1']
					,'cep' 	        =>$data['cep1' 	       ]
					,'observacoes ' =>$data['observacoes1' ]	
					,'latlong'      =>$data['latlong1'     ]
					,'empresaid'	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(strlen($data['cep2']) >0 
			|| strlen($data['logradouro2'])>0 
			|| strlen($data['bairro2']    )>0
			|| strlen($data['cidade2']    )>0
			|| strlen($data['estado2']    )>0){
				$this->insert('endereco',[
					'pessoaid'	    =>$pessoaid
					,'logradouro'   =>$data['logradouro2'  ]
					,'cidade' 	    =>$data['cidade2' 	   ]
					,'estado' 	    =>$data['estado2' 	   ]
					,'pais' 	    =>$data['pais2' 	   ]
					,'bairro' 	    =>$data['bairro2' 	   ]
					,'numero' 	    =>$data['numero2' 	   ]
					,'complemento'  =>$data['complemento2' ]	
					,'tipoendereco' =>$data['tipoendereco2' 	   ]
					,'cep' 	        =>$data['cep2' 	       ]
					,'observacoes ' =>$data['observacoes2' ]	
					,'latlong'      =>$data['latlong2'     ]
					,'empresaid'	=>$empresaid
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			

            $this->Flash->success(__('Cliente cadastrado com sucesso'));
            return $this->redirect(['controller'=>'painel']);
        }
        $this->set(compact('cliente'));
		$this->set([
			'perfilid'=>$perfilid
			,'empresaid'=>$empresaid 
			,'segmento'=>$segmento
		]);
    }

    /**
     * Edit method
     *
     * @param string|null $id Cliente id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $cliente = $this->Cliente->get($id, [
            'contain' => []
        ]);
		$pessoa = $this->get('pessoa','pessoaid',$cliente->pessoaid);
		$perfilid = $this->perfilid();
        if ($this->request->is(['patch', 'post', 'put'])) {
			$vendedorid = $cliente->vendedorid;
			
			$data = $this->request->getData();
			$empresaid = $cliente->empresaid;
			
			//administrador de sistema e secretaria de sistema
			if(in_array($perfilid,[1,7])){
				$empresaid = $data['empresaid'];
			}
		$usuarioid = $this->usuarioid();
		$usuariocrm = $this->getAll('usuario_crm','usuarioid',$usuarioid)->first();
			//administrador de sistema e secretaria de sistema
			if(!in_array($perfilid,[5]) && $vendedorid != $data['vendedorid']){
				$vendedorid = $data['vendedorid'];
				
				$vendedor = $this->get('vendedor','idvendedor',$vendedorid);
				$pessoaorigem = $this->getAll('pessoa','pessoaid',$usuariocrm->pessoaid)->first();
				$this->insert('notificacao',[
					'pessoaidorigem'=>$pessoaorigem->pessoaid
					,'pessoaiddestino'=>$vendedor->pessoaid
					,'tipo'=>'Mudança de vendedor'
					,'mensagem'=>$pessoaorigem->nome.' atribuiu '.$pessoa->nome.' à você.'
					,'data_lembrete'=>date('Y-m-d')
					,'link'=>'/flystart/cliente/view/'.$cliente->clienteid
					,'visto'=>0
				]);
			}
			
			
			$pessoaTable = TableRegistry::get('Pessoa');
			$pessoa = $pessoaTable->patchEntity($pessoa, $data);
			$pessoa->pessoaidcadastro = $this->pessoaid();
			$pessoa->empresaid = $empresaid;

			if(!$pessoaTable->save($pessoa)){
				echo "Pessoa não pode ser salva<br>";$this->d($pessoa);
			}
			
			//cliente
			if($this->validaData($data['data_cliente'])){
				$data['data_cliente'] = $this->formatDataToDatabase($data['data_cliente']);
				$data['data_cliente'] = DateTime::createFromFormat('Y-m-d', $data['data_cliente']);
			} else {
				$data['data_cliente'] = null;
			}
			$clienteTable = TableRegistry::get('Cliente');
			$cliente = $this->get('cliente','pessoaid',$pessoa->pessoaid);
			$cliente = $clienteTable->patchEntity($cliente, $data);
			$cliente->empresaid = $empresaid;
			$cliente->vendedorid = $vendedorid;
			$cliente->observacao = $data['observacoes3'];
			if(!$clienteTable->save($cliente)){
				echo "Cliente não pode ser salvo<br>";$this->d($cliente);
			}

			return $this->redirect($this->referer());
        }

        $isAjax = false;
		if(isset($_GET['isAjax']) && $_GET['isAjax'] == 1){
			$isAjax = true;
		}
		
		
		$telefones = $this->getAllTableWhere('telefone',['pessoaid'=>$pessoa->pessoaid],['tipotelefone'=>'asc'])->toArray();
		$enderecos = $this->getAllTableWhere('endereco',['pessoaid'=>$pessoa->pessoaid],['tipoendereco'=>'asc'])->toArray();
		
        $this->set([
			'perfilid'=>$perfilid
			,'pessoa'=>$pessoa
			,'telefones'=>$telefones
			,'enderecos'=>$enderecos
			,'isAjax'=>$isAjax
		]);
        $this->set(compact('cliente'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Cliente id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $cliente = $this->Cliente->get($id);
		$pessoa = $this->get('pessoa','pessoaid',$cliente->pessoaid);
		$this->remove('pessoa',['pessoaid'=>$pessoa->pessoaid]);
		$this->remove('telefone',['pessoaid'=>$pessoa->pessoaid]);
		$this->remove('endereco',['pessoaid'=>$pessoa->pessoaid]);
		$this->remove('produtointeresse',['clienteid'=>$cliente->clienteid]);
		$this->remove('contato',['clienteid'=>$cliente->clienteid]);
        if ($this->Cliente->delete($cliente)) {
            $this->Flash->success(__('Cliente foi deletado.'));
        } else {
            $this->Flash->error(__('The cliente could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action'=>'index']);
    }
}
