<?php
namespace App\Controller\Flystart;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
use \DateTime;

use App\Controller\AppController;

/**
 * Compra Controller
 *
 * @property \App\Model\Table\CompraTable $Compra
 *
 * @method \App\Model\Entity\Compra[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class CompraController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $compra = $this->paginate($this->Compra);
        $clientes = $this->getAllTableWhere('cliente',[],[]);
        $produtos = $this->getAllTableWhere('produto_crm',[],[]);
        $formapag = $this->getAllTableWhere('formapag',[],[]);

        $this->set(compact('compra','clientes','produtos','formapag'));
    }

    public function confirmaorcamento($id){
        $compra = $this->Compra->get($id, [
            'contain' => []
        ]);

        $pagamentos = $this->query("SELECT fc.idformapagcondpag, p.nome as descricao, c.descricao as condicao, cp.qtdparcelas, cp.valor, cp.idcompra, cp.data_vencimento FROM formapag p
        INNER JOIN formapag_condpag fc on p.formapagid = fc.idformapag
        INNER JOIN condpag c on c.idcondpag = fc.idcondpag
        INNER JOIN compra_pag cp on cp.idformapagcondpag = fc.idformapagcondpag
        WHERE cp.idcompra = $id");

        $sql = "SELECT fc.idformapagcondpag, p.nome as descricao, c.descricao as condicao, c.qtdparcelas FROM formapag p
        INNER JOIN formapag_condpag fc on p.formapagid = fc.idformapag
        INNER JOIN condpag c on c.idcondpag = fc.idcondpag";

        $formapag =$this->query($sql);

        if ($this->request->is(['patch', 'post', 'put'])) {
            $data= $this->request->getData();
            //$this->d($data);
            $comprapagTable = TableRegistry::Get('compra_pag');
            $comprapag = $this->getAllTableWhere('compra_pag',['idcompra'=>$id],[])->all();
            if($comprapagTable->deleteAll(['idcompra'=>$id])){
                $comprapag = $comprapagTable->newEntity();
                $comprapagsave = [];
                for ($i=0; $i < count($data['idformapag']); $i++) { 
                    $valorpago = str_replace(',','.',str_replace('.','',$data['valorpago'][$i]));
                    $aux=['idformapagcondpag'=>$data['idformapag'][$i],'idcompra'=>$id,'qtdparcelas'=>$data['qtdparcelas'][$i],'valor'=>$valorpago];
                    array_push($comprapagsave,$aux);
                }
                $comprapag = $comprapagTable->patchEntities($comprapag,$comprapagsave);
                if($comprapagTable->saveMany($comprapag)){
                    $this->gerarfinanceiro($compra,$comprapag,$data);
                }else{
                    $this->Flash->error(__('Ocorreu um erro ao tentar aprovar orçamento, por favor tente novamente.'));
                    return $this->redirect(['action' => 'orcamentoview',$compra->id]);

                }
            }else{
                $this->Flash->error(__('Ocorreu um erro ao tentar aprovar orçamento, por favor tente novamente.'));
                return $this->redirect(['action' => 'orcamentoview',$compra->id]);
            }
        }

        $formapagjson = json_encode($formapag);
        $this->set(compact(
            'compra'
            ,'formapag'
            ,'formapagjson'
            ,'pagamentos'
        ));
    }

    public function gerarfinanceiro($compra,$comprapag,$data){
        $compraproduto = $this->get('compra_produto','idcompra',$compra->id);
        $produto = $this->get('produto_crm','produtoid',$compraproduto->idproduto);
        $contaTable = TableRegistry::Get('conta');
        for($j=0; $j<count($comprapag); $j++){
            $cpg = $comprapag[$j];
            $formapagcondpag = $this->get('formapag_condpag','idformapagcondpag',$cpg->idformapagcondpag);
            if($cpg->qtdparcelas > 1){
                for ($i=0; $i < $cpg->qtdparcelas ; $i++) {
                    if(array_key_exists('datavencparcela'.$j,$data)){
                            $dataparcela = $data['datavencparcela'.$j][$i];
                            $valorparcela = str_replace(',','.',str_replace('.','',$data['valorparcela'.$j][$i]));   
                    }else{
                        if($i==0){
                            $dataparcela = $data['datavencimento'][$j];                              
                        }else{						
                            $dataparcela = date('Y/m/d', strtotime('+ 30 days', strtotime($dataparcela)));  
                        }
                        $valorparcela = $cpg->valor/$cpg->qtdparcelas;
                        $erro = ($valorparcela * $cpg->qtdparcelas) - $cpg->valor;
                        if($erro > 0 && $i==0){
                            $valorparcela = $valorparcela - $erro;
                        }
                    }

                    $aux=['idcompra'=>$compra->id,'descricao'=>strtoupper($produto->nome),'pessoaid'=>$compra->idpessoa,'totalbruto'=>$compra->totalbruto,'totalliquido'=>$compra->totalliquido,
                    'valorparcela' => $valorparcela, 'parcela'=>1, 'status'=>"PENDENTE PAGAMENTO",'valordesc'=>$compra->descontototalvalor,'percdesc'=>$compra->descontototalperc,
                    'empresaid' => $this->empresaid(),'tipocontaid'=>1,'subtipocontaid'=>'2','formapagid'=>$formapagcondpag->idformapag,'condpagid'=>$formapagcondpag->idcondpag ,
                    'data_vencimento'=>$dataparcela,'valorcompra'=>$cpg->valor];
                    if($i==0){
                        $conta = $contaTable->newEntity();
                        $conta = $contaTable->patchEntity($conta,$aux);
                        $conta = $contaTable->save($conta);
                        $codmov = $conta->contaid;
                        $arr = ['contaid'=>$conta->contaid,'codmov'=>$codmov];
                        $contaupdate = $contaTable->patchEntity($conta,$arr);
                        if(!$contaTable->save($contaupdate)){
                            //$this->Flash->error(__('Ocorreu um erro ao gerar financeiro, por favor tente novamente.'));
                            return $this->redirect(['action' => 'orcamentoview',$compra->id]);
                        }
                    }else{
                        $aux=['idcompra'=>$compra->id,'codmov'=>$codmov,'descricao'=>strtoupper($produto->nome),'pessoaid'=>$compra->idpessoa,'totalbruto'=>$compra->totalbruto,'totalliquido'=>$compra->totalliquido,
                        'valorparcela' => $valorparcela, 'parcela'=>1, 'status'=>"PENDENTE PAGAMENTO",'valordesc'=>$compra->descontototalvalor,'percdesc'=>$compra->descontototalperc,
                        'empresaid' => $this->empresaid(),'tipocontaid'=>1,'subtipocontaid'=>'2','formapagid'=>$formapagcondpag->idformapag,'condpagid'=>$formapagcondpag->idcondpag,
                        'data_vencimento'=>$dataparcela,'valorcompra'=>$cpg->valor];
                        
                        $conta = $contaTable->newEntity();
                        $conta = $contaTable->patchEntity($conta,$aux);
                        $conta = $contaTable->save($conta);
                    }
                    
                }
                
            }else{

                $aux=['idcompra'=>$compra->id,'descricao'=>strtoupper($produto->nome),'pessoaid'=>$compra->idpessoa,'totalbruto'=>$compra->totalbruto,'totalliquido'=>$compra->totalliquido,
                    'status'=>"PENDENTE PAGAMENTO",'valordesc'=>$compra->descontototalvalor,'percdesc'=>$compra->descontototalperc,'data_vencimento'=>$data['datavencimento'][$j],
                    'empresaid' => $this->empresaid(),'tipocontaid'=>1,'subtipocontaid'=>'2','parcela'=>0,'formapagid'=>$formapagcondpag->idformapag,'condpagid'=>$formapagcondpag->idcondpag,
                    'valorcompra'=>$cpg->valor];
                    
                $conta = $contaTable->newEntity();
                $conta = $contaTable->patchEntity($conta,$aux);
                if(!$contaTable->save($conta)){
                    $this->Flash->error(__('Ocorreu um erro ao gerar financeiro, por favor tente novamente.'));
                }
            }
            
        }
        $this->aprovarorcamento($compra->id);

    }

    public function orcamentoscontato($id = null)
    {
        $compra = $this->getAllTableWhere('compra',['idcontato'=> $id],[]);
        $clientes = $this->getAllTableWhere('cliente',[],[]);
        $produtos = $this->getAllTableWhere('produto_crm',[],[]);
        $formapag = $this->getAllTableWhere('formapag',[],[]);

        $this->set(compact('compra','clientes','produtos','formapag'));
    }

    public function orcamentoview($id = null)
    {
        $compra = $this->Compra->get($id, [
            'contain' => []
        ]);

        $compra_produto = $this->getAllTableWhere('compra_produto',['idcompra'=>$id],[]);
        $pessoa = $this->query("SELECT * FROM pessoa as p LEFT JOIN telefone as t on t.pessoaid = p.pessoaid 
        WHERE p.pessoaid = $compra->idpessoa LIMIT 1")[0];
        $empresa = $this->query("SELECT * FROM empresa_crm WHERE empresaid = $compra->idempresa")[0];
        $endereco = $this->query("SELECT * FROM endereco WHERE pessoaid = $compra->idpessoa");
            
        

        $sql = "SELECT fp.nome, cp.descricao,c.valor, c.qtdparcelas FROM compra_pag c
                INNER JOIN formapag_condpag f on f.idformapagcondpag = c.idformapagcondpag
                INNER JOIN condpag cp on cp.idcondpag = f.idcondpag
                INNER JOIN formapag fp on fp.formapagid = f.idformapag
                WHERE c.idcompra = $compra->id";
        $formapag = $this->query($sql);

       // $this->d($endereco[0]->numero);

        //Totalizadores=========================================================================
		$totalProdutos 	     = 0;
		$descontoProdutos 	 = 0;
		$subtotal 	         = 0;

		foreach($compra_produto as $item){
			$totalProdutos = $totalProdutos + $item->valorprodbruto;
			$descontoProdutos = $descontoProdutos + $item->descontoprodvalor;
			$subtotal = $subtotal + $item->valorprodliquido;
		}

		//fim totalizadores=====================================================================

        //$this->d($empresa);
        $this->set(compact(
            'compra'
            ,'compra_produto'
            ,'pessoa'
            ,'empresa'
            ,'endereco'
            ,'totalProdutos'
            ,'descontoProdutos'
            ,'subtotal'
            ,'formapag'
        ));
    }

    /**
     * View method
     *
     * @param string|null $id Compra id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $compra = $this->Compra->get($id, [
            'contain' => []
        ]);
        $compra_produto = $this->getAllTableWhere('compra_produto',['idcompra'=>$id],[]);

        $this->set(compact('compra','compra_produto'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $clientes = $this->getAllTableWhere('cliente',[],[]);
        $produtos = $this->getAllTableWhere('produto_crm',[],[]);
        $produtosarray = [];
        foreach ($produtos as $item) {
            array_push($produtosarray,$item->produtoid." - ".$item->nome);
        }

        $sql = "SELECT produtoid, valor from produto_crm";
        $produtopreco = $this->query($sql);
        $produtoprecojson = json_encode($produtopreco);
        $sql = "SELECT fc.idformapagcondpag, p.nome as descricao, c.descricao as condicao, c.qtdparcelas FROM formapag p
        INNER JOIN formapag_condpag fc on p.formapagid = fc.idformapag
        INNER JOIN condpag c on c.idcondpag = fc.idcondpag";

        $formapag =$this->query($sql);

        $formapagjson = json_encode($formapag);
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $compra = $this->Compra->newEntity();

            $totalliquido = str_replace(',','.',str_replace('.','',$data['totalliquido']));
            $totalbruto = str_replace(',','.',str_replace('.','',$data['totalbruto']));

            $compra->totalliquido = $totalliquido;
            $compra->totalbruto = $totalbruto;
            $compra->idpessoa = $data['idpessoa'];
            $compra->idcontato = $data['idcontato'];
            $compra->descontototalvalor = $totalbruto - $totalliquido;
            $compra->descontototalperc = (($totalbruto - $totalliquido) / $totalbruto) * 100;
            $compra->datavalidade = $data['datavalidade'];
            $compra->idpessoacadastro = $this->pessoaid();
            $compra->idempresa = $this->empresaid();
            $compra->obscliente = $data['obscliente'];
            $compra->obsempresa = $data['obsempresa'];
            $compra->totaldesconto = str_replace(',','.',str_replace('.','',$data['totaldesconto']));
            //$this->d($data);
            //$this->d($compra);
            if ($this->Compra->save($compra)) {
                $this->Flash->success(__('Orçamento realizado com sucesso.'));


                if(array_key_exists('idproduto', $data)){
                    for($i=0; $i<count($data['idproduto']);$i++){
                        if($data['idproduto'][$i] != '' && $data['qtd'][$i] != '' && $data['valorprodunitario'][$i] != ''){
                            $this->insert('compra_produto',[
                            'idcompra'=>$compra->id,
                            'idproduto'=>explode(' ',$data['idproduto'][$i])[0],
                            'qtd'=>$data['qtd'][$i],
                            'valorprodunitario'=>str_replace(',','.',str_replace('.','',$data['valorprodunitario'][$i])),
                            'valorprodbruto'=>str_replace(',','.',str_replace('.','',$data['valorprodbruto'][$i])),
                            'descontoprodvalor'=>str_replace(',','.',str_replace('.','',floatval($data['descontoprodvalor'][$i]))),
                            'descontoprodperc'=>str_replace(',','.',str_replace('.','',floatval($data['descontoprodperc'][$i]))),//convertendo para float
                            'valorprodliquido'=>str_replace(',','.',str_replace('.','',$data['valorprodliquido'][$i]))
                            ]);

                        }
                    }

                }

                if(array_key_exists('idformapag', $data)){
                    for($j=0; $j<count($data['idformapag']);$j++){
                        if($data['idformapag'][$j] != 0){
                            $this->insert('compra_pag',[
                                'idcompra'=>$compra->id,
                                'idformapagcondpag'=>$data['idformapag'][$j],
                                'qtdparcelas'=>$data['qtdparcelas'][$j],
                                'valor'=>str_replace(',','.',str_replace('.','',$data['valorpago'][$j]))
                                ]);
                        }
                    }
                }

                return $this->redirect(['action' => 'orcamentoview',$compra->id]);
            }
            $this->Flash->error(__('Não foi possível criar o orçamento, tente novamente.'));
        }
        $this->set(compact('compra','clientes','produtos','produtosarray','produtoprecojson','formapag','formapagjson'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Compra id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $compra = $this->Compra->get($id, [
            'contain' => []
        ]);

        $compra_produto = $this->query("SELECT c.*, p.nome FROM compra_produto c
                                        INNER JOIN produto_crm p ON p.produtoid = c.idproduto
                                         WHERE c.idcompra = $id");

        $pagamentos = $this->query("SELECT fc.idformapagcondpag, p.nome as descricao, c.descricao as condicao, cp.qtdparcelas, cp.valor, cp.idcompra FROM formapag p
        INNER JOIN formapag_condpag fc on p.formapagid = fc.idformapag
        INNER JOIN condpag c on c.idcondpag = fc.idcondpag
        INNER JOIN compra_pag cp on cp.idformapagcondpag = fc.idformapagcondpag
        WHERE cp.idcompra = $id");

        $pessoa = $this->query("SELECT * FROM pessoa WHERE pessoaid = $compra->idpessoa")[0];
        $empresa = $this->query("SELECT * FROM empresa_crm WHERE empresaid = $compra->idempresa")[0];
        $endereco = $this->query("SELECT * FROM endereco WHERE pessoaid = $compra->idpessoa");

        $clientes = $this->getAllTableWhere('cliente',[],[]);
        $produtos = $this->getAllTableWhere('produto_crm',[],[]);
        $produtosedit = $this->getAllTableWhere('produto_crm',[],[]);
        $produtosarray = [];
        foreach ($produtos as $item) {
            array_push($produtosarray,$item->produtoid." - ".$item->nome);
        }

        $sql = "SELECT produtoid, valor from produto_crm";
        $produtopreco = $this->query($sql);
        $produtoprecojson = json_encode($produtopreco);

        $sql = "SELECT fc.idformapagcondpag, p.nome as descricao, c.descricao as condicao, c.qtdparcelas FROM formapag p
        INNER JOIN formapag_condpag fc on p.formapagid = fc.idformapag
        INNER JOIN condpag c on c.idcondpag = fc.idcondpag";

        $formapag =$this->query($sql);

        $formapagjson = json_encode($formapag);

        if ($this->request->is(['patch', 'post', 'put'])) {
            $data = $this->request->getData();
            // $compra = $this->Compra->newEntity();
            $compraTable = TableRegistry::get('Compra');
			$compra = $compraTable->patchEntity($compra, $data);

            $totalliquido = str_replace(',','.',str_replace('.','',$data['totalliquido']));
            $totalbruto = str_replace(',','.',str_replace('.','',$data['totalbruto']));

            $compra->totalliquido = $totalliquido;
            $compra->totalbruto = $totalbruto;
            // $compra->idpessoa = $data['idpessoa'];
            // $compra->idcontato = $data['idcontato'];
            $compra->descontototalvalor = $totalbruto - $totalliquido;
            $compra->descontototalperc = (($totalbruto - $totalliquido) / $totalbruto) * 100;
            $compra->datavalidade = $data['datavalidade'];
            $compra->idpessoamodificacao = $this->pessoaid();
            $compra->idempresa = $this->empresaid();
            $compra->datamodificacao = date('Y-m-d H:i:s');

            //$this->d($data);
            //$this->d($compra);
             if ($this->Compra->save($compra)) {
                 $this->Flash->success(__('Orçamento Editado com sucesso.'));

                 foreach($compra_produto as $item){
                    $this->remove('compra_produto',[
                        'idcompra'=>$item->idcompra
                    ]);
                }

                foreach($pagamentos as $item){
                    $this->remove('compra_pag',[
                        'idcompra'=>$item->idcompra
                    ]);
                }

                if(array_key_exists('idproduto', $data)){
                    for($i=0; $i<count($data['idproduto']);$i++){
                        if($data['idproduto'][$i] != '' && $data['qtd'][$i] != '' && $data['valorprodunitario'][$i] != ''){
                            $this->insert('compra_produto',[
                            'idcompra'=>$compra->id,
                            'idproduto'=>explode(' ',$data['idproduto'][$i])[0],
                            'qtd'=>$data['qtd'][$i],
                            'valorprodunitario'=>str_replace(',','.',str_replace('.','',$data['valorprodunitario'][$i])),
                            'valorprodbruto'=>str_replace(',','.',str_replace('.','',$data['valorprodbruto'][$i])),
                            'descontoprodvalor'=>str_replace(',','.',str_replace('.','',floatval($data['descontoprodvalor'][$i]))),
                            'descontoprodperc'=>str_replace(',','.',str_replace('.','',floatval($data['descontoprodperc'][$i]))),
                            'valorprodliquido'=>str_replace(',','.',str_replace('.','',$data['valorprodliquido'][$i]))
                            ]);

                        }
                    }

                }

                if(array_key_exists('idformapag', $data)){
                    for($j=0; $j<count($data['idformapag']);$j++){
                        if($data['idformapag'][$j] != 0){
                            $this->insert('compra_pag',[
                                'idcompra'=>$compra->id,
                                'idformapagcondpag'=>$data['idformapag'][$j],
                                'qtdparcelas'=>$data['qtdparcelas'][$j],
                                'valor'=>str_replace(',','.',str_replace('.','',$data['valorpago'][$j]))
                                ]);
                        }
                    }
                }

                return $this->redirect(['action' => 'orcamentoview',$compra->id]);
            }
            $this->Flash->error(__('Não foi possível criar o orçamento, tente novamente.'));
        }
        $this->set(compact(
            'compra'
            ,'clientes'
            ,'produtos'
            ,'produtosarray'
            ,'produtoprecojson'
            ,'formapag'
            ,'formapagjson'
            ,'compra_produto'
            ,'pagamentos'
            ,'pessoa'
        ));
    }

    /**
     * Delete method
     *
     * @param string|null $id Compra id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $compra = $this->Compra->get($id);
        if ($this->Compra->delete($compra)) {
            $this->Flash->success(__('The compra has been deleted.'));
        } else {
            $this->Flash->error(__('The compra could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function aprovarorcamento($id = null){
        $this->update('compra',[
            'status'=>'1',
            'dataaprovacao'=> date("Y-m-d H:i:s")
        ],[
            'id'=>$id
        ]);
        
        $this->Flash->success(__('Orçamento aprovado, contas de financeiro geradas com sucesso'));
        return $this->redirect(['action' => 'orcamentoview',$id]);
    }

    public function cancelarorcamento($id = null){
        $this->update('compra',[
            'status'=>'2',
            'datacancelado'=> date("Y-m-d H:i:s")
        ],[
            'id'=>$id
        ]);

        $contaTable = TableRegistry::Get('conta');
        $contaTable->deleteAll(['idcompra'=>$id]);

        return $this->redirect(['action' => 'orcamentoview',$id]);
    }


}
