<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Form\Form;
use Cake\ORM\TableRegistry;


class ContatoController extends AppController
{

	public function beforeRender(Event $event) {
        
        $perfilid = $this->perfilid();
		$action = $this->request->getParam('action');
		if($this-> $perfilid == 5 && in_array($action,['view','edit'])){
			$id = $this->request->getParam('pass');

			$contato = $this->Contato->get($id, [
				'contain' => []
			]);

			$contatoidpai = $contato->contatoidpai;

			 $sql = "select * from contato where contatoidpai = $contatoidpai order by data_criacao desc";


			 $contatofilho = $this->query($sql)[0];

			//$this->d($contatofilho->vendedorid);

			$pessoaid = $this->sessionread('login.usuario')->pessoaid;

			$vendedorid = $this->vendedorid();
			//$this->d($vendedorid);

			if(($pessoaid != $contato->pessoaidcadastro) && ($vendedorid != $contatofilho->vendedorid)){
				echo "Negociação não pertence ao vendedor.";
				exit();
			}

			// if($cliente->vendedorid != $this->vendedorid()){
			// 	echo "Cliente não pertence à sua carteira.";
			// 	exit();
			// }
		}
		return parent::beforeRender($event);
	}

	public function fichatap($id = null){
		$this->layout= '';
		$contato = $this->get('contato','contatoid',$id);
		$cliente = $this->get('cliente','clienteid',$contato->clienteid);
		$pessoa = $this->get('pessoa','pessoaid',$cliente->pessoaid);
		$vendedor = $this->get('vendedor','idvendedor',$cliente->vendedorid);
		$pessoavendedor = ($vendedor)?$this->get('pessoa','pessoaid',$vendedor->pessoaid) : null;
		$endereco = ($pessoa)?$this->get('endereco','pessoaid',$pessoa->pessoaid):null;
		$telefone = ($pessoa)?$this->get('telefone','pessoaid',$pessoa->pessoaid):null;

		//$this->d($campocomplementar);

		$form = [];
		$sql = "select
			*
		from campocomplementar
		where
			referencia = 'contato'
			and referenciaid = ".$contato->contatoid."
			and chave like 'ficha_%'
			";
		$campos = $this->query($sql);
		foreach($campos as $item){
			$form[$item->chave]=$item->valor;
		}
		$form = (object) $form;

		$sql = "select
					case when pi.contatoid is not null then 1 else 0 end as ordem
					,p.produtoid
					,p.nome
					,p.valor
					,p.descricao
					,COALESCE(pi.quantidade,0) as quantidade
				from produto p
				left join produtointeresse pi on pi.produtoid = p.produtoid and pi.contatoid = ".$contato->contatoid."
				where
					p.ativo = 1
				order by 1 desc,p.nome asc";
				//echo $sql;exit;
		$produtosinteresse = $this->query($sql);
		$this->set([
			'contato'=>$contato
			,'cliente'=>$cliente
			,'pessoa'=>$pessoa
			,'vendedor'=>$vendedor
			,'pessoavendedor'=>$pessoavendedor
			,'endereco'=>$endereco
			,'telefone'=>$telefone
			,'form'=>$form
			,'produtosinteresse' => $produtosinteresse
		]);
}
public function fichapdf($id = null){
	$this->layout= '';
	$contato = $this->get('contato','contatoid',$id);
	$cliente = $this->get('cliente','clienteid',$contato->clienteid);
	$pessoa = $this->get('pessoa','pessoaid',$cliente->pessoaid);
	$vendedor = $this->get('vendedor','idvendedor',$cliente->vendedorid);
	$pessoavendedor = ($vendedor)?$this->get('pessoa','pessoaid',$vendedor->pessoaid) : null;
	$endereco = ($pessoa)?$this->get('endereco','pessoaid',$pessoa->pessoaid):null;
	$telefone = ($pessoa)?$this->get('telefone','pessoaid',$pessoa->pessoaid):null;

	//$this->d($campocomplementar);

	$form = [];
	$sql = "select
		*
	from campocomplementar
	where
		referencia = 'contato'
		and referenciaid = ".$contato->contatoid."
		and chave like 'ficha_%'
		";
	$campos = $this->query($sql);
	foreach($campos as $item){
		$form[$item->chave]=$item->valor;
	}
	$form = (object) $form;
	$this->set([
		'contato'=>$contato
		,'cliente'=>$cliente
		,'pessoa'=>$pessoa
		,'vendedor'=>$vendedor
		,'pessoavendedor'=>$pessoavendedor
		,'endereco'=>$endereco
		,'telefone'=>$telefone
		,'form'=>$form
	]);
}
	public function ficha($id=null){
		$contato = $this->get('contato','contatoid',$id);
		$cliente = $this->get('cliente','clienteid',$contato->clienteid);
		$pessoa = $this->get('pessoa','pessoaid',$cliente->pessoaid);
		$vendedor = $this->get('vendedor','idvendedor',$cliente->vendedorid);
		$pessoavendedor = ($vendedor)?$this->get('pessoa','pessoaid',$vendedor->pessoaid) : null;
		$endereco = ($pessoa)?$this->get('endereco','pessoaid',$pessoa->pessoaid):null;
		$telefone = ($pessoa)?$this->get('telefone','pessoaid',$pessoa->pessoaid):null;

		$form = [];
		if ($this->request->is('post')) {
			$data = $this->request->getData();
			foreach($data as $key=>$value){
				$campo = $this->getAllTableWhere('campocomplementar',[
					'referencia'=>'contato'
					,'referenciaid'=>$contato->contatoid
					,'chave'=>$key
				],[]);

				if($campo->count() ==0){
					$this->insert('campocomplementar',[
						'referencia'=>'contato'
						,'referenciaid'=>$contato->contatoid
						,'chave'=>$key
						,'valor'=>$value
					]);
				}else{
					$this->update('campocomplementar',[
						'referencia'=>'contato'
						,'referenciaid'=>$contato->contatoid
						,'chave'=>$key
						,'valor'=>$value
					],[
						'referencia'=>'contato'
						,'referenciaid'=>$contato->contatoid
						,'chave'=>$key
					]);
				}
				$form[$key]=$value;
			}
		}else{
			$sql = "select
				*
			from campocomplementar
			where
				referencia = 'contato'
				and referenciaid = ".$contato->contatoid."
				and chave like 'ficha_%'
				";
			$campos = $this->query($sql);
			foreach($campos as $item){
				$form[$item->chave]=$item->valor;
			}

		}

		$form = (object) $form;
		$idpage = $id;
		$this->set([
			'contato'=>$contato
			,'cliente'=>$cliente
			,'pessoa'=>$pessoa
			,'vendedor'=>$vendedor
			,'pessoavendedor'=>$pessoavendedor
			,'endereco'=>$endereco
			,'telefone'=>$telefone
			,'form'=>$form
			,'idpage'=>$idpage
		]);
	}

	public function cliente($id=null)
    {
		$perfilid =$this->perfilid();
		$pessoaid =$this->pessoaid();
        $contato = $this->paginate($this->Contato
			->find('all')
			->innerJoin('cliente','cliente.clienteid = Contato.clienteid')
			->where(['cliente.clienteid'=>$id])
			->andWhere('contatoid = contatoidpai')
			->order(['Contato.contatoid'=>'desc'])
		);

		$vendedorid = $this->vendedorid();

		$cliente = $this->get('cliente','clienteid',$id);
		$pessoa = $this->get('pessoa','pessoaid',$cliente->pessoaid);


        $this->set(compact('contato'));
		$this->set([
			'cliente'=>$cliente
			,'pessoa'=>$pessoa
			,'perfilid'=>$perfilid
			,'pessoaid'=>$pessoaid
			,'vendedorid'=>$vendedorid
		]);
    }

    public function buscar(){
		$busca = "";
		if(isset($_GET['busca'])){
			$busca = $_GET['busca'];
		}


		$clienteTable = TableRegistry::get('contato');
		$query = $clienteTable->find('all')
						->innerJoin('cliente','cliente.clienteid = contato.clienteid')
						->innerJoin('pessoa','pessoa.pessoaid = cliente.pessoaid')
						->where([
							'pessoa.nome like'=>"%$busca%"
						])->orWhere([
							'pessoa.razaosocial like'=>"%$busca%"
						])->orWhere([
							'cliente.clienteid'=>$busca
						])->andWhere([
							'cliente.vendedorid'=>$this->vendedorid()
						])->andWhere([
							'contato.contatoidpai '=>'IS NULL'
						])
						->order(['pessoa.nome'=>'ASC'
								,'pessoa.razaosocial' =>'ASC'
								]);

		$resultadoarr = $this->paginate($query,['limit'=>20]);

		$this->set('_serialize', ['resultadoarr']);
		$this->set([
			'resultadoarr'=>$resultadoarr
			,'busca'=>$busca
		]);
	}


    public function index()
    {
       
		$perfilid = $this->perfilid();		
        $clientewherearr = '1 = 1';
		$vendedorid =  $this->vendedorid();
        
		//vendedor
		if(in_array($perfilid,[5])){
			$clientewherearr = "(cli.vendedorid = $vendedorid)";
		}

		//adm empresa, gerente, secretaria
		if(in_array($perfilid,[3,4,6])){
			$clientewherearr = 'cli.empresaid = '.$this->empresaid();
		}

		$contato = $this->query("SELECT c.contatoidpai, pcli.nome AS cliente, cli.origemlead,
			cli.tipocliente, c.grauinteresse, c.data_contato, c.statuscontato, f.descricao AS funil
			FROM contato c INNER JOIN cliente cli ON (cli.clienteid = c.clienteid)
			INNER JOIN pessoa pcli ON pcli.pessoaid = cli.pessoaid
			INNER JOIN funil f ON f.idfunil = c.idfunil
			WHERE $clientewherearr AND c.contatoid IN (SELECT MAX(contatoid) AS contatoid FROM contato GROUP BY contatoidpai)");

		$this->set(compact(['contato', 'perfilid','vendedorid']));
    }

    /**
     * View method
     *
     * @param string|null $id Contato id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null,$here = null)
    {		
        $perfilid = $this->perfilid();
		$empresaid = $this->empresaid();
		$idusuario = $this->usuarioid();
        $contato = $this->Contato->get($id, [
            'contain' => []
		]);
		$idfunil = $contato->idfunil;
		if (isset($_GET['funil'])) {
			$idfunil = $_GET['funil'];
		}
		$cliente = $this->get('Cliente','clienteid',$contato->clienteid);
        $pessoa = $this->get('Pessoa','pessoaid',$cliente->pessoaid);
       

		$sql = "SELECT col.colaboradorid, p.nome
				FROM colaborador col
				INNER JOIN cliente cli ON cli.clienteid = col.clienteidreferenciado
				INNER JOIN pessoa p ON p.pessoaid = cli.pessoaid
				WHERE
					col.clienteidreferenciado = ".$cliente->clienteid
				." ORDER BY p.nome";
        $colaboradores = $this->query($sql);
        
		$sql = "select v.idvendedor, p.nome
				from vendedor v
				inner join pessoa p on p.pessoaid = v.pessoaid
				where
					v.idempresa_crm = ".$empresaid 
				." order by p.nome";
		$vendedores = $this->query($sql);
		
		$sql = "SELECT DISTINCT numeroorcamento FROM contato WHERE contatoidpai = $contato->contatoidpai";
		$orcamentos = $this->query($sql);
		$orcamentostring = '(';
		$contador = 0;
		foreach ($orcamentos as $orcamento){
			if(null !== $orcamento->numeroorcamento && '' !== $orcamento->numeroorcamento){
				$contador ++;
				if ($contador == 1) {
					$orcamentostring = $orcamentostring.$orcamento->numeroorcamento;
				} else {
				$orcamentostring = $orcamentostring.','.$orcamento->numeroorcamento;
				}
			}
		}
		$idpage = $id;
		$usuariofunil  = TableRegistry::get('funil');
		$usuariofunil = $usuariofunil->find('all')
        ->innerJoin('usuariofunil',['usuariofunil.idfunil = funil.idfunil'])
		->where(['usuariofunil.idusuario' =>$idusuario, 'funil.ativo' => 1] );
		$funil = $this->getTableWhere('funil',['idfunil'=>$idfunil]);
		$ultimocontato = $this->query("SELECT * FROM contato WHERE idfunil = $idfunil AND contatoidpai = $id ORDER BY contatoid DESC LIMIT 1")[0];
        $this->set('contato', $contato);
		$this->set([
			'cliente'=>$cliente
			,'pessoa'=>$pessoa
			,'empresaid'=>$empresaid
			,'perfilid'=>$perfilid
			,'colaboradores'=>$colaboradores
			,'vendedores'=>$vendedores
			,'contatoidpai'=>$id
			,'idpage'=>$idpage
			,'solititou'=>$here
			,'usuariofunil'=>$usuariofunil
			,'funil'=>$funil
			,'idfunil'=>$idfunil
			,'ultimocontato'=>$ultimocontato
		]);
			
    }

	public function fechar($id = null)
    {
        $contato = $this->Contato->get($id, [
            'contain' => []
        ]);

		$this->update('cliente',[
			'tipocliente'=>'Cliente'
		],[
			'clienteid'=>$contato->clienteid
		]);

		$this->update('contato',[
			'data_fechamento'=>date('Y-m-d H:s:i')
		],[
			'contatoid'=>$contato->contatoid
		]);
		
		return $this->redirect($this->referer());
    }

	public function addlaudo($id = null){
		if ($this->request->is('post')) {
			$data = $this->request->getData();

			$contato = $this->get('contato','contatoid',$_POST['contatoid']);
			$contato = $this->Contato->patchEntity($contato, $this->request->getData());
			$contato->pessoaidlaudo = $this->pessoaid();
			$contato->data_laudo = date("Y-m-d H:i:s");
			//notificacao

			$cliente = $this->get('cliente', 'clienteid', $contato->clienteid);
			if (null !== $cliente && !empty($cliente)){
				$vendedor = $this->get('vendedor','vendedorid',$cliente->vendedorid);
			}

			$vendedorpessoaid = (null !== $vendedor && !empty($vendedor)) ? $vendedor->pessoaid : $this->pessoaid();

			$this->insert('notificacao',[
				'pessoaidorigem'=>$this->pessoaid()
				,'pessoaiddestino'=>$vendedorpessoaid
				,'tipo'=>'Laudo Cadastrado'
				,'mensagem'=>$data['laudo']
				,'data_lembrete'=>date('Y-m-d')
				,'link'=>'/adm/contato/view/'.$contato->contatoid
				,'visto'=>0
			]);
			if ($this->Contato->save($contato)) {
				echo 'true';
			}else{
				echo 'false';
			}
			exit();
		}
	}

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($id = null,$here = null)
    {
        $perfilid =$this->perfilid();
		$empresaid = $this->empresaid();
		$vendedorid =  $this->vendedorid();

        $contato = $this->Contato->newEntity();
		$cliente = $this->get('cliente','clienteid',$id);
		$pessoa = $this->get('pessoa','pessoaid',$cliente->pessoaid);
		


		$sql = "select col.colaboradorid, p.nome
				from colaborador col
				inner join cliente cli on cli.clienteid = col.clienteidreferenciado
				inner join pessoa p on p.pessoaid = cli.pessoaid
				where
					col.clienteidreferenciado = ".$cliente->clienteid
				." order by p.nome";
		$colaboradores = $this->query($sql);

		$sql = "select v.idvendedor, p.nome
				from vendedor v
				inner join pessoa p on p.pessoaid = v.pessoaid
				where
					v.idempresa_crm = ".$empresaid
				." order by p.nome";
		$vendedores = $this->query($sql);

		$idpage = $id;

		$this->set(compact('contato'));
		$this->set([
			'cliente'=>$cliente
			,'pessoa'=>$pessoa
			,'perfilid'=>$perfilid
			,'empresaid'=>$empresaid
			,'colaboradores'=>$colaboradores
			,'vendedores'=>$vendedores
			// ,'produtosinteresse'=>$produtosinteresse
			// ,'totalprodutosinteresse'=>$totalprodutosinteresse
			,'idpage'=>$idpage
		]);


        if ($this->request->is('post')) {
			$data = $this->request->getData();	
			
			$contato = $this->Contato->patchEntity($contato, $data);
			$contato->empresaid = $this->empresaid();
			$contato->pessoaidcadastro = $this->pessoaid();
			$contato->clienteid = $cliente->clienteid;
			$vendedoridcli = $vendedorid;
			if (array_key_exists('idvendedor', $data)) {
				$vendedoridcli = $data['idvendedor'];
			}

			if($cliente->vendedorid != null){
				$contato->vendedorid = $cliente->vendedorid;
			}else{
				$vendedorid = $this->vendedorid();
				$contato->vendedorid = $vendedorid;
			}
			
			if(isset($_POST['vendedorid'])){
            	$contato->vendedorid = $data['vendedorid'];
            	$vendedorid = $data['vendedorid'];
            }

			if (array_key_exists('idvendedor',$data)) {
				$contato->vendedorid = $data['idvendedor'];
			}
			
			//data contato
			$newdate = $data['data_contato'];
			$newdate = str_replace('/', '-', $newdate );
			$newdate = date("Y-m-d", strtotime($newdate));
			if($contato->data_contato != null && trim($contato->data_contato) != "" && !$this->isValidDate($data['data_contato'],'d/m/Y')){
				$this->Flash->error(__('Data do contato inválida.'));
				return $this->redirect($this->referer());
			}
			
			$contato->data_contato = $newdate;
			//data lembrete
			if(isset($data['data_lembrete']) && trim($data['data_lembrete']) != "" && !$this->isValidDate($data['data_lembrete'],'d/m/Y')){
				
				$this->Flash->error(__('Data de lembrete inválida.'));
				return $this->redirect($this->referer());
			}
			if(!empty( $data['data_lembrete'])){
				$contato->data_lembrete = $this->formatDataToDatabase($data['data_lembrete']);
			}
			//data previsao fechamento
			if(isset($data['data_previsaofechamento']) && trim($data['data_previsaofechamento']) != "" && !$this->isValidDate($data['data_previsaofechamento'],'d/m/Y')){
				$this->Flash->error(__('Data de previsão de fechamento inválida.'));
				return $this->redirect($this->referer());
			}
			if(!empty($data['data_previsaofechamento'])){
				$contato->data_previsaofechamento = $this->formatDataToDatabase($data['data_previsaofechamento']);
			}

			if(array_key_exists('produto', $data)){
				$pessoaid = $this->pessoaid();
				//$this->d($pessoaid);
				$demandareprimidaTable  = TableRegistry::get('demandareprimida');
				$demandareprimida = $demandareprimidaTable->newEntity();
				$demandasave = [];
				for($i=0; $i < count($data['produto']); $i++){
					if($data['codproduto'][$i] != null){
						$demandareprimidasave = ['codproduto' => $data['codproduto'][$i], 'produto' => $data['produto'][$i] , 'fabricante' => $data['fabricante'][$i],
						'grupo' => $data['grupo'][$i],'valor' => str_replace(',','.',str_replace('.','',$data['valor'][$i])),'quantidade' => $data['quantidade'][$i],'observacaodemanda' => $data['observacaodemanda'][$i],
						'cliente' => $pessoa->nome,'clienteid'=>$cliente->clienteid, 'vendedorid'=>$vendedorid, 'idpessoacadastro'=>$pessoaid, 'contatoid'=> $contato->contatoidpai,
						'contatoid'=> $contato->contatoidpai, 'quantidade'=>$data['quantidade'][$i] ];
						array_push($demandasave,$demandareprimidasave);
					}
				}

				$demandareprimida = $demandareprimidaTable->patchEntities($demandareprimida, $demandasave);
				if(count($demandareprimida) > 0 ){
					if (!$demandareprimidaTable->saveMany($demandareprimida)) {
						$this->Flash->error(__('Erro ao salvar Demanda Reprimida'));
						return $this->redirect($this->referer());
					}
				}
				

			}


			 //$this->d($data['observacaodemanda']);

			if ($this->Contato->save($contato)) {
                $this->Flash->success(__('Contato cadastrado com sucesso'));

				$contatoid = $contato->contatoid;
				if($contato->contatoidpai == null){
					$contato->contatoidpai = $contato->contatoid;
					$this->Contato->save($contato);
				}else{
					$contatoid = $contato->contatoidpai;
				}
				//notificacao
				if(strlen($contato->data_lembrete)>0){
					$this->insert('notificacao',[
						'pessoaidorigem'=>$this->pessoaid()
						,'pessoaiddestino'=>$this->pessoaid()
						,'tipo'=>'Lembrete para '.$this->formatData($contato->data_lembrete)
						,'mensagem'=>$contato->observacao
						,'data_lembrete'=>$contato->data_lembrete
						,'link'=>'/adm/contato/view/'.$contatoid
						,'visto'=>0
					]);
				}
				$this->update('contato',[
					'statuscontato' =>$contato->statuscontato
					,'grauinteresse'=>$contato->grauinteresse
					,'idfunil'        =>$contato->idfunil
					//,'observacao'   =>$contato->observacao
					,'valorvenda'   =>$contato->valorvenda
				],[
					'contatoid'=>$contato->contatoid
				]);
				$this->contatoanexoupload($contato);

				$this->update('cliente',[
					'vendedorid' =>$vendedoridcli
				],[
					'clienteid'=>$id
				]);

				if($here == 2){
				return $this->redirect(['controller'=>'painel','action' => 'index']);
				}
                return $this->redirect(['action' => 'view',$contatoid]);
            }else{
				$this->Flash->error(__('The contato could not be saved. Please, try again.'));
			}
        }
    }

	public function getUploadDir(){
		$uploaddir = ROOT."/webroot/arquivos/crm/";
		if($this->isLocalhost()){
				$uploaddir = ROOT."\webroot\arquivos\\crm\\";
		}

		return $uploaddir;
	}

	public function extensoesPermitidas(){
		return ['jpg','jpeg','png','pdf','doc','docx','xls','xlsx','txt','zip','rar','csv'];
	}

    public function contatoanexoupload($contato){
		if(!isset($_FILES['File']) || count($_FILES['File']['tmp_name'])==0){
			return;
		}

		for($i=0;$i < count($_FILES['File']['tmp_name']);$i++){
			if(strlen($_FILES['File']['tmp_name'][$i])==0){ return; }

			$extensao = pathinfo($_FILES['File']['name'][$i], PATHINFO_EXTENSION);
			if(!in_array(strtolower($extensao),$this->extensoesPermitidas()) ) {
				$this->Flash->error(__('Arquivo não enviado, formato de arquivo inválido! os formatos suportados são: jpg, jpeg, png, pdf, doc, docx, xls, xlsx, txt, zip, rar e csv.'));
				return $this->redirect(['action' => 'view',$contato->contatoid]);
			}

			$uploadfile = $this->getUploadDir()
				.basename($contato->empresaid.'_'.$contato->pessoaidcadastro."_".$contato->contatoid."_".date('Ymd').$i)
				.".".$extensao;

			if(move_uploaded_file($_FILES['File']['tmp_name'][$i], $uploadfile)){
				$this->insert('contatoanexo',[
					'contatoid'=>$contato->contatoid
					,'nome'=>$_FILES['File']['name'][$i]
					,'caminho'=>$uploadfile
				]);
			}
		}


		return;
	}


    public function edit($id = null)
    {
        $contato = $this->Contato->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $contato = $this->Contato->patchEntity($contato, $this->request->getData());
            if ($this->Contato->save($contato)) {
                $this->Flash->success(__('The contato has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The contato could not be saved. Please, try again.'));
        }
        $this->set(compact('contato'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Contato id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
		$contato = $this->Contato->get($id);
        if ($this->Contato->deleteAll(['contatoidpai' => $contato->contatoid])) {
            $this->Flash->success(__('Contato deletado com sucesso.'));
        } else {
            $this->Flash->error(__('O Contato não pôde ser deletado. Por favor, tente novamente.'));
        }

        return $this->redirect(['action' => 'index']);
	}
	
	public function duplicate($contatoid, $idfunil, $empresaid) {
		$session = $this->request->getSession();
		$idusuario = $session->read('login.usuario')->idusuario;
		$vendedores = $this->query("SELECT p.nome, v.* FROM vendedor v INNER JOIN pessoa p ON (p.pessoaid = v.pessoaid) WHERE v.idempresa_crm = $empresaid");
		$funis = $this->query("SELECT * FROM funil f INNER JOIN usuariofunil uf ON (f.idfunil = uf.idfunil) WHERE uf.idusuario = $idusuario");
		$contatopai = $this->get('Contato','contatoid',$contatoid);
		if ($this->request->is('post')) {
			$data = $this->request->getData();
			$funilstatus = $this->getAllTableWhere('Statuscontato',['funilid'=>$data['idfunil']], ['ordem ASC'])->first()->nome;
			$contato = $this->Contato->newEntity();
			$contato->contatoidpai = $contatoid;
			$contato->observacao = $data['observacao'];
			$contato->vendedorid = $data['vendedorid'];
			$contato->idfunil = $data['idfunil'];
			$contato->empresaid = $empresaid;
			$contato->statuscontato = $funilstatus;
			$contato->pessoaidcadastro = $this->pessoaid();
			$contato->clienteid = $contatopai->clienteid;
			$contato->data_contato = Date('Y-m-d');
			$this->Contato->save($contato);
			$this->redirect(['action'=>'index', 'controller'=>'painel']);
		}

		$this->set(compact(
			'vendedores',
			'funis'
		));
	}

}
