<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Perfil Controller
 *
 * @property \App\Model\Table\PerfilTable $Perfil
 */
class ContextoController extends AppController
{	
	public function login($id = null){
		$usuario = $this->get('usuario','usuarioid',$id);
		$empresa = $this->get('empresa','empresaid',$usuario->empresaid);
		$pessoa = $this->get('pessoa','pessoaid',$usuario->pessoaid);
		
		$modulousuario = $this->getAllTableWhere('Modulousuario',[
															'usuarioid'=>$usuario->usuarioid
															,'ativo'=>1
															],[]);
															
		
		$modulosid = [];
		foreach($modulousuario as $item){
			array_push($modulosid, $item->moduloid);
		}
		
		if(count($modulosid) == 0){
			echo "Usuário não possui módulos de acesso. Contate o administrador do sistema.";exit();
		}
		
		$modulos = $this->getAllTableWhere('Modulo',[
													'moduloid IN'=>$modulosid
													,'ativo'=>1
													],['ordem'=>'asc']);
		//$this->d($modulos->toArray());
		$this->sessionwrite('login.usuario',$usuario);
		$this->sessionwrite('login.empresa',$empresa);
		$this->sessionwrite('login.pessoa',$pessoa);
		$this->sessionwrite('login.modulos',$modulos->toArray());
		
		$perfilusuario = $this->getAllTableWhere('perfilusuario',[
			'usuarioid'=>$usuario->usuarioid
			,'empresaid'=>$empresa->empresaid
		],[]);
		
		
		if($perfilusuario->count() == 0){
			echo "Usuário está sem perfil atribuído. Contate o administrador.";exit();
		}else if($perfilusuario->count() == 1){
			$perfil = $this->get('perfil','perfilid',$perfilusuario->first()->perfilid);
			$this->sessionwrite('login.perfil',$perfil);
			$this->redirect($perfil->pagina_inicial);
			return;
		}else if($perfilusuario->count() > 1){
			$perfisid = [];
			foreach($perfilusuario as $item){
				array_push($perfisid, $item->perfilid);
			}
			
			$perfis = $this->getAllTableWhere('Perfil',[
													'perfilid IN'=>$perfisid
													,'ativo'=>1
													],['ordem'=>'asc']);
			
			$this->sessionwrite('login.perfis',$perfis->toArray());
			$this->redirect('/adm/contexto/perfil');
		}
	}
	
	public function loginperfil($id = null){
		$perfil = $this->get('perfil','perfilid',$id);
		$this->sessionwrite('login.perfil',$perfil);
		$this->redirect($perfil->pagina_inicial);
	}

	public function empresa(){
		$this->set([
			'usuarios'=>$this->sessionread('login.usuarios')
		]);
	}
	
	public function perfil(){
		$session = $this->request->session();
		$perfis = $session->read('login.perfis_crm');
		$usuario = $session->read('login.usuario');
		$this->set([
			'perfis'=>$perfis
			,'usuario'=>$usuario
		]);
	}
}
