<?php

namespace App\Controller\Flystart;

use App\Controller\AppController;

/**
 * Perfil Controller
 *
 * @property \App\Model\Table\PerfilTable $Perfil
 */
class CustomizationsController extends AppController
{
    public function index()
    {

    }
    
    public function modal_contas(){
        $empresaid = $this->empresaid();
        if ($empresaid == 1) {
            $idempresas = "1, 5, 7, 8";
        } else {
            $idempresas = $empresaid;        
        }
        $empresas = $this->query("SELECT * FROM empresa_crm WHERE empresaid IN ($idempresas)");
        $contasbancarias = $this->query("SELECT * FROM contabanco WHERE empresaid IN ($idempresas)");

        $tipo = $_GET['tipo'];
        $filtro = $_GET['filtro'];
        $empresaid = $this->empresaid();
        $mesAtual = Date('m');
        $anoAtual = Date('Y');
        $hoje = Date('Y-m-d');
        switch ($filtro) {
            case 'smile':
                $query = $this->query(
                    "SELECT e.razaosocial, c.contaid, p.nome, c.descricao, c.totalliquido, cb.soma_baixas AS baixa, c.status, c.data_vencimento
                    FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido FROM conta) c
                    LEFT JOIN (SELECT contaid, SUM(valorpago) AS soma_baixas FROM contabaixa GROUP BY contaid) cb ON (cb.contaid = c.contaid)
                    INNER JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                    INNER JOIN empresa_crm e ON (e.empresaid = c.empresaid)
                    WHERE MONTH(c.data_vencimento) = $mesAtual AND YEAR(c.data_vencimento) = $anoAtual AND cb.soma_baixas IS NOT NULL
                    AND c.status IN ('PENDENTE PAGAMENTO', 'PAGO', 'PAGO PARCIALMENTE') AND c.tipocontaid = $tipo AND c.empresaid IN ($idempresas)"
                );
                $position = 0;
                $textofinal = " em ".$this->toMes(Date('m'));
                break;
            
            case 'serious':
                $query = $this->query(
                    "SELECT e.razaosocial, c.contaid, p.nome, c.descricao, c.totalliquido, cb.soma_baixas AS baixa, c.status, c.data_vencimento
                    FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido FROM conta) c
                    LEFT JOIN (SELECT contaid, SUM(valorpago) AS soma_baixas FROM contabaixa GROUP BY contaid) cb ON (cb.contaid = c.contaid)
                    INNER JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                    INNER JOIN empresa_crm e ON (e.empresaid = c.empresaid)
                    WHERE MONTH(c.data_vencimento) = $mesAtual AND YEAR(c.data_vencimento) = $anoAtual AND c.data_vencimento >= '$hoje'
                    AND c.status IN ('PENDENTE PAGAMENTO') AND c.tipocontaid = $tipo AND c.empresaid IN ($idempresas)"
                );
                $position = 1;
                $textofinal = " em ".$this->toMes(Date('m'));
                break;
            
            case 'sad':
                $query = $this->query(
                    "SELECT e.razaosocial, c.contaid, p.nome, c.descricao, c.totalliquido, cb.soma_baixas AS baixa, c.status, c.data_vencimento
                    FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido FROM conta) c
                    LEFT JOIN (SELECT contaid, SUM(valorpago) AS soma_baixas FROM contabaixa GROUP BY contaid) cb ON (cb.contaid = c.contaid)
                    INNER JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                    INNER JOIN empresa_crm e ON (e.empresaid = c.empresaid)
                    WHERE MONTH(c.data_vencimento) = $mesAtual AND YEAR(c.data_vencimento) = $anoAtual AND c.data_vencimento < '$hoje'
                    AND c.status IN ('PENDENTE PAGAMENTO') AND c.tipocontaid = $tipo AND c.empresaid IN ($idempresas)"
                );
                $position = 2;
                $textofinal = " em ".$this->toMes(Date('m'));
                break;
            
            case 'nothing':
                $query = $this->query(
                    "SELECT e.razaosocial, c.contaid, p.nome, c.descricao, c.totalliquido, cb.soma_baixas AS baixa, c.status, c.data_vencimento
                    FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido FROM conta) c
                    LEFT JOIN (SELECT contaid, SUM(valorpago) AS soma_baixas FROM contabaixa GROUP BY contaid) cb ON (cb.contaid = c.contaid)
                    INNER JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                    INNER JOIN empresa_crm e ON (e.empresaid = c.empresaid)
                    WHERE c.data_vencimento < '$hoje'
                    AND c.status IN ('PENDENTE PAGAMENTO') AND c.tipocontaid = $tipo AND c.empresaid IN ($idempresas)"
                );
                $position = 3;
                $textofinal = " Historicamente";
                break;
        }
        if ($tipo == 2) {
            $labels = ['Pagas', 'A Pagar', 'Vencidas', 'Em Aberto'];
        } else if ($tipo == 1){
            $labels = ['Recebidas', 'A Receber', 'Vencidas', 'Em Aberto'];            
        } else {
            echo "Erro!";
            exit();
        }
        $this->set(compact([
            'query',
            'tipo',
            'labels',
            'empresas',
            'contasbancarias',
            'position',
            'textofinal'
        ]));
    }

    public function row_resumo_contas() {
        $tipo = $_GET['tipo'];
        $empresaid = $this->empresaid();
        if ($empresaid == 1) {
            $idempresas = "1, 5, 7, 8";
        } else {
            $idempresas = $empresaid;        
        }
        $labels = [];
        if ($tipo == 2) {
            $labels = ['Pago', 'A Pagar', 'Vencido', 'Em Aberto', 'a Pagar'];
        } else if ($tipo == 1){
            $labels = ['Recebido', 'A Receber', 'Vencido', 'Em Aberto', 'a Receber'];            
        } else {
            echo "Erro!";
            exit();
        }
        $mesAtual = Date('m');
        $anoAtual = Date('Y');
        $hoje = Date('Y-m-d');
        $query = $this->query(
            "SELECT SUM(CASE WHEN (MONTH(c.data_vencimento) = $mesAtual AND YEAR(c.data_vencimento) = $anoAtual) THEN cb.valorpago ELSE 0 END) AS total_pago, 
                SUM(CASE WHEN (MONTH(c.data_vencimento) = $mesAtual AND YEAR(c.data_vencimento) = $anoAtual AND c.status IN ('PENDENTE PAGAMENTO', 'PAGAMENTO PARCIAL') AND c.data_vencimento >= '$hoje') THEN (c.totalliquido - COALESCE(cb.valorpago, 0)) ELSE 0 END) AS total_pagar, 
                SUM(CASE WHEN (MONTH(c.data_vencimento) = $mesAtual AND YEAR(c.data_vencimento) = $anoAtual AND (c.data_vencimento < '$hoje' AND c.status IN ('PENDENTE PAGAMENTO', 'PAGAMENTO PARCIAL'))) THEN (c.totalliquido - COALESCE(cb.valorpago, 0)) ELSE 0 END) AS total_pagar_vencido,
                SUM(CASE WHEN c.data_vencimento < '$hoje' THEN (c.totalliquido - COALESCE(cb.valorpago, 0)) ELSE 0 END) AS total_pagar_vencido_historico
            FROM (SELECT contaid, data_vencimento, status, tipocontaid, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido FROM conta) c
            LEFT JOIN (SELECT contaid, SUM(valorpago) AS valorpago FROM contabaixa GROUP BY contaid) cb ON (cb.contaid = c.contaid)
            WHERE c.tipocontaid = $tipo AND c.status IN ('PENDENTE PAGAMENTO', 'PAGO', 'PAGO PARCIALMENTE')
            AND c.empresaid IN ($idempresas)"
        );
        $query = $query[0];
        $this->set(compact([
            'query',
            'labels',
            'mesAtual',
            'anoAtual',
            'tipo'
        ]));
    }
}
