<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Demandareprimida Controller
 *
 * @property \App\Model\Table\DemandareprimidaTable $Demandareprimida
 *
 * @method \App\Model\Entity\Demandareprimida[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class DemandareprimidaController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {   
        $perfilid = $this->perfilid();
        $empresaid = $this->empresaid();
        $vendedorid =  $this->vendedorid();
            
        $ultimodiames = $this->getUltimoDiaMes();
        $periodo = "";
        $datainicio = date("Y-m-01");
        $datafim    = date("Y-m-$ultimodiames");
        if(isset($_GET['periodo'])){
            $periodo = $_GET['periodo'];
            $datainicio = $this->getPeriodo('periodo')[0];
            $datafim    = $this->getPeriodo('periodo')[1];
        }else{
            $periodo = date("01/m/Y")." - ".date("$ultimodiames/m/Y");
        }

        $wherearr = [1=>1];

        if(in_array($perfilid,[5])){
            $wherearr = ["vendedorid = $vendedorid "];
        }

        
        $demandareprimida = $this->Demandareprimida->find('all')
                        ->where(["CAST(data_criacao as date) between '$datainicio' and '$datafim'"])
                        ->andWhere($wherearr)
                        ->order(['data_criacao'=>'desc']);

        $this->set(compact('demandareprimida','perfilid','vendedorid'));
        $this->set([
            'periodo'=>$periodo
        ]);
    }

    /**
     * View method
     *
     * @param string|null $id Demandareprimida id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $perfilid = $this->perfilid();

        $demandareprimida = $this->Demandareprimida->get($id, [
            'contain' => []
        ]);

        $this->set([
            'demandareprimida'=> $demandareprimida
            ,'perfilid'=>$perfilid
        ]);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $demandareprimida = $this->Demandareprimida->newEntity();
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            
            $demandasave = [];
            
            for($i=0; $i < count($data['codproduto']); $i++){
                if($data['codproduto'][$i] != null){
                    $demandareprimidasave = ['codproduto' => $data['codproduto'][$i], 'produto' => $data['produto'][$i] , 'fabricante' => $data['fabricante'][$i],
                    'grupo' => $data['grupo'][$i],'valor' => str_replace(',','.',str_replace('.','',$data['valor'][$i])),'quantidade' => $data['quantidade'][$i],'observacaodemanda' => $data['observacaodemanda'][$i]];
                    array_push($demandasave,$demandareprimidasave);
                }
            }
            
            $demandareprimida = $this->Demandareprimida->patchEntities($demandareprimida, $demandasave);
        
            //$demandareprimida->observacao = $data['observacaodemanda'];

            /* if(strlen($demandareprimida->valor)>0){
                $demandareprimida->valor = str_replace('.','',$demandareprimida->valor);
                $demandareprimida->valor = str_replace(',','.',$demandareprimida->valor);
            }else{
                $demandareprimida->valor = null;
            } */
            //$this->d($demandareprimida);
            if(count($demandareprimida) > 0 ){
                if ($this->Demandareprimida->saveMany($demandareprimida)) {
                    $this->Flash->success(__('The demandareprimida has been saved.'));

                    return $this->redirect(['action' => 'index']);
                }
                $this->Flash->error(__('The demandareprimida could not be saved. Please, try again.'));
            }
            return $this->redirect(['action' => 'add']);
        }

        $isAjax = false;
        if(isset($_GET['isAjax']) && $_GET['isAjax'] == 1){
            $isAjax = true;
        }

        $this->set(compact('demandareprimida','isAjax'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Demandareprimida id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $perfilid = $this->perfilid();

        $demandareprimida = $this->Demandareprimida->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $demandareprimida = $this->Demandareprimida->patchEntity($demandareprimida, $this->request->getData());
            if ($this->Demandareprimida->save($demandareprimida)) {
                $this->Flash->success(__('The demandareprimida has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The demandareprimida could not be saved. Please, try again.'));
        }
        $this->set([
            'demandareprimida'=> $demandareprimida
            ,'perfilid'=>$perfilid 
        ]);
    }

    /**
     * Delete method
     *
     * @param string|null $id Demandareprimida id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $demandareprimida = $this->Demandareprimida->get($id);
        if ($this->Demandareprimida->delete($demandareprimida)) {
            $this->Flash->success(__('The demandareprimida has been deleted.'));
        } else {
            $this->Flash->error(__('The demandareprimida could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function buscar(){
        $idfilialcontexto  = 1;
        $idempresacontexto = 1;

        $busca = "";
        //$resultadoarr = [];
        if(isset($_GET['busca'])){
            $busca = $_GET['busca'];
            
            /* $resultadoarr = $this->queryjson("adm.estoque.buscaproduto",[
                'idempresacontexto'=>$idempresacontexto
                ,'idfilialcontexto'=>$idfilialcontexto
                ,'busca'=>$busca
            ]); */

            $sql = "SELECT p.produtoid as idproduto,p.nome as produto ,p.valor as precovenda,g.nome as grupo, p.fabricante,p.unidade,sum(p.sdofisico) as quantidade 
                    FROM produto_crm p
                    LEFT JOIN grupoproduto g on g.grupoprodutoid = p.grupoid 
                    WHERE UPPER(p.nome) LIKE '" .$busca.  "%' OR p.produtoid = '" .$busca. "' 
                    GROUP BY p.produtoid, p.nome, g.nome, p.fabricante, p.unidade, p.valor
                    ORDER BY p.nome";
                    
            //$produtoTable = TableRegistry::get('produto_crm');
            $resultadoarr = $this->query($sql);
            
        }

        $this->set([
            'resultadoarr'=>$resultadoarr
            ,'busca'=>$busca
        ]);
    }

    public function cliente($id = null){
        
        $demandareprimida = $this->Demandareprimida->find('all')
                        ->where(["clienteid = $id"])
                        ->order(['data_criacao'=>'desc']);

        $this->set(compact('demandareprimida'));

    }
}
