<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;

/**
 * Endereco Controller
 *
 * @property \App\Model\Table\EnderecoTable $Endereco
 *
 * @method \App\Model\Entity\Endereco[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class EnderecoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $endereco = $this->paginate($this->Endereco);

        $this->set(compact('endereco'));
    }

    /**
     * View method
     *
     * @param string|null $id Endereco id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $endereco = $this->Endereco->get($id, [
            'contain' => []
        ]);

        $this->set('endereco', $endereco);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($id = null)
    {
        $endereco = $this->Endereco->newEntity();
		$pessoa  = $this->get('pessoa','pessoaid',$id);
		$cliente = $this->get('cliente','pessoaid',$id);
		$usuario = $this->get('usuario_crm','pessoaid',$id);
		
        if ($this->request->is('post')) {
            $data = $this->request->getData();
			
			$this->insert('endereco',[
				'pessoaid'	    =>$pessoa->pessoaid
				,'logradouro'   =>$data['logradouro1'  ]
				,'cidade' 	    =>$data['cidade1' 	   ]
				,'estado' 	    =>$data['estado1' 	   ]
				,'pais' 	    =>$data['pais1' 	   ]
				,'bairro' 	    =>$data['bairro1' 	   ]
				,'numero' 	    =>$data['numero1' 	   ]
				,'complemento'  =>$data['complemento1' ]	
				,'tipoendereco' =>$data['tipoendereco1']
				,'cep' 	        =>$data['cep1' 	       ]
				,'observacoes ' =>$data['observacoes1' ]	
				,'latlong'      =>$data['latlong1'     ]
				,'empresaid'	=>$this->empresaid()
				,'pessoaidcadastro'	=>$this->pessoaid()
			]);
			
			if($data['cep2'] || $data['logradouro2'] || $data['bairro2'] || $data['cidade2'] || $data['estado2'] || $data['pais2']){
				$this->insert('endereco',[
					'pessoaid'	    =>$pessoa->pessoaid
					,'logradouro'   =>$data['logradouro2'  ]
					,'cidade' 	    =>$data['cidade2' 	   ]
					,'estado' 	    =>$data['estado2' 	   ]
					,'pais' 	    =>$data['pais2' 	   ]
					,'bairro' 	    =>$data['bairro2' 	   ]
					,'numero' 	    =>$data['numero2' 	   ]
					,'complemento'  =>$data['complemento2' ]	
					,'tipoendereco' =>$data['tipoendereco2' 	   ]
					,'cep' 	        =>$data['cep2' 	       ]
					,'observacoes ' =>$data['observacoes2' ]	
					,'latlong'      =>$data['latlong2'     ]
					,'empresaid'	=>$this->empresaid()
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			$redirect = ['controller'=>'cliente','action' => 'edit',$cliente->clienteid];
			
			$this->Flash->success(__('Endereço salvo com sucesso.'));
			return $this->redirect($redirect);
        }
        $this->set(compact('endereco'));
		$this->set([
			'pessoa'=>$pessoa
			,'cliente'=>$cliente
			,'usuario'=>$usuario
		]);
    }

    /**
     * Edit method
     *
     * @param string|null $id Endereco id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $endereco = $this->Endereco->get($id, [
            'contain' => []
        ]);
		$pessoa  = $this->get('pessoa','pessoaid',$endereco->pessoaid);
		$cliente = $this->get('cliente','pessoaid',$pessoa->pessoaid);
		$usuario = $this->get('usuario_crm','pessoaid',$pessoa->pessoaid);
		
        if ($this->request->is(['patch', 'post', 'put'])) {
            $data = $this->request->getData();
			
			$this->update('endereco',[
				'logradouro'   =>$data['logradouro'  ]
				,'cidade' 	    =>$data['cidade' 	   ]
				,'estado' 	    =>$data['estado' 	   ]
				,'pais' 	    =>$data['pais' 	   ]
				,'bairro' 	    =>$data['bairro' 	   ]
				,'numero' 	    =>$data['numero' 	   ]
				,'complemento'  =>$data['complemento' ]	
				,'tipoendereco' =>$data['tipoendereco']
				,'cep' 	        =>$data['cep' 	       ]
				,'observacoes ' =>$data['observacoes' ]	
				,'latlong'      =>$data['latlong'     ]
			],['pessoaid'=>$pessoa->pessoaid, 'enderecoid'=>$id]);

			$redirect = ['controller'=>'cliente','action' => 'edit',$cliente->clienteid];
			
			$this->Flash->success(__('Endereço salvo com sucesso.'));
			return $this->redirect($redirect);
        }
        $this->set(compact('endereco'));
		$this->set([
			'pessoa'=>$pessoa
			,'cliente'=>$cliente
			,'usuario'=>$usuario
		]);
    }

    /**
     * Delete method
     *
     * @param string|null $id Endereco id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $endereco = $this->Endereco->get($id);
        if ($this->Endereco->delete($endereco)) {
            $this->Flash->success(__('Endereço foi excluído.'));
        } else {
            $this->Flash->error(__('The endereco could not be deleted. Please, try again.'));
        }

        return $this->redirect($this->referer());
    }
}
