<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
use \DateTime;

class FinanceiroController extends AppController
{
	public function testetabela() {
		$data = $this->getAllTableWhere('Contas_pagar_dummy',[],[]);
		$nomeRelatorio = "Relatorio testes";
		$usuario = "User 123";
		$sistema = "FlyStart";
		$totalRegistros = count($data->all());
		$posicoes_soma = [1];
		$id = "datatable"; 
		$headers = ['Conta','Valor (R$)','Vencimento'];
		$columns = ['id','valor','vencimento'];
		$format = ['toNumber','toFloat','formatData'];
		$align = ['','text-right',''];
		$pdf_rightalign = [1];
		$pageLength = 10;
		$table_title = "Título";
		$export = true;

		$this->set(compact([
			'data',
			'nomeRelatorio',
			'usuario',
			'sistema',
			'totalRegistros',
			'posicoes_soma',
			'datatable',
			'headers',
			'id',
			'columns',
			'pageLength',
			'format',
			'align',
			'table_title',
			'export',
			'pdf_rightalign'
		]));
	} 

	public function beforeRender(Event $event) {

		$sessao = $this->request->session();
		$acesso = false;
		$idusuario = $sessao->read('login.usuario')->idusuario;
		$modulos = $this->getInnerJoin('modulo','modulousuario',['modulousuario.idmodulo = modulo.idmodulo'],['modulo.ativo'=> 1 ,'modulousuario.idusuario'=>$idusuario],['ordem'=>'asc']);
		foreach ($modulos as $modulo) {
			if (mb_strtoupper($modulo->nome) == 'FINANCEIRO') {
				$acesso = true;
				break;
			}
		}
		if ($acesso) {
			return true;
		} else {
			return $this->redirect($this->redirect('/'));
		}
	}

    public function index(){
		$tipoconta = $this->getAllTableWhere('tipoconta',[],[]);
		$subtipoconta = $this->getAllTableWhere('subtipoconta',[],[]);
		$this->set(compact('tipoconta','subtipoconta'));
	}
	
    public function importacaocontas() {
        $contas_pagar = $this->getAllTableWhere('Contas_pagar_dummy',[],[]);
        foreach ($contas_pagar as $item) {
            $pessoa = $this->get('Pessoa','nome',$item->credor);
            if ($pessoa === null) {
                $pessoaTable = TableRegistry::Get('Pessoa');
                $pessoa = $pessoaTable->newEntity();
                $pessoa->nome = $item->credor;
                $pessoa = $pessoaTable->save($pessoa);
            }
            $centrocusto = $this->get('Centrocusto','nome',$item->centro_custo);
            if ($centrocusto === null) {
                $centrocustoTable = TableRegistry::Get('centrocusto');
                $centrocusto = $centrocustoTable->newEntity();
                $centrocusto->nome = $item->centro_custo;
                $centrocusto = $centrocustoTable->save($centrocusto);
            }
            // update usado => UPDATE contas_receber_dummy SET vencimento = DATE(STR_TO_DATE(vencimento, '%d/%m/%Y'))
            $contaTable = TableRegistry::get('Conta');
            $conta = $contaTable->newEntity();
            $conta->pessoaid = $pessoa->pessoaid;
            $conta->centrocustoid = $centrocusto->centrocustoid;
            $conta->data_vencimento = $item->vencimento;
            $conta->data_competencia = $item->vencimento;
            $conta->totalbruto = $item->valor;
            $conta->totalliquido = $item->valor;
            $conta->descricao = $item->observacao;
            $conta->status = "PENDENTE PAGAMENTO";
            $conta->tipocontaid = 2;
            $conta->subtipocontaid = 2;
            $conta->empresaid = 1;
            $contaTable->save($conta);
        }
        $contas_receber = $this->getAllTableWhere('Contas_receber_dummy',[],[]);
        foreach ($contas_receber as $item) {
            $pessoa = $this->get('Pessoa','nome',$item->credor);
            if ($pessoa === null) {
                $pessoaTable = TableRegistry::Get('Pessoa');
                $pessoa = $pessoaTable->newEntity();
                $pessoa->nome = $item->credor;
                $pessoa = $pessoaTable->save($pessoa);
            }
            $centrocusto = $this->get('Centrocusto','nome',$item->centro_custo);
            if ($centrocusto === null) {
                $centrocustoTable = TableRegistry::Get('centrocusto');
                $centrocusto = $centrocustoTable->newEntity();
                $centrocusto->nome = $item->centro_custo;
                $centrocusto = $centrocustoTable->save($centrocusto);
            }
            // update usado => UPDATE contas_receber_dummy SET vencimento = DATE(STR_TO_DATE(vencimento, '%d/%m/%Y'))
            $contaTable = TableRegistry::get('Conta');
            $conta = $contaTable->newEntity();
            $conta->pessoaid = $pessoa->pessoaid;
            $conta->centrocustoid = $centrocusto->centrocustoid;
            $conta->data_vencimento = $item->vencimento;
            $conta->data_competencia = $item->vencimento;
            $conta->totalbruto = $item->valor;
            $conta->totalliquido = $item->valor;
            $conta->descricao = $item->observacao;
            $conta->status = "PENDENTE PAGAMENTO";
            $conta->tipocontaid = 1;
            $conta->subtipocontaid = 2;
            $conta->empresaid = 1;
            $contaTable->save($conta);
		}
		echo("e ai??");
		exit();
    }

    public function tabelacontas(){
		$tipo = $_GET['tipo'];
		$tipo = $tipo=='todos' ? $tipo = "LIKE '%'" : $tipo = " = " .$tipo;

		$subtipo = $_GET['subtipo'];
		$subtipo=='todos' ? $subtipo = "LIKE '%'" : $subtipo = " = " .$subtipo;
		$periodo = $this->getPeriodo('periodo');
		$sqlconta = 'SELECT * FROM conta WHERE tipocontaid ' .$tipo .' AND subtipocontaid ' .$subtipo .' AND CAST(data_vencimento AS DATE) BETWEEN \''.$periodo[0] .'\' AND \'' .$periodo[1] .'\'';
		$contas = $this->query($sqlconta);
		
		foreach($contas as $conta){
			$sql='SELECT * FROM pessoa p WHERE p.pessoaid =' .$conta->pessoaid;
			$pessoa = $this->query($sql);
			$conta->cliente = $pessoa[0]->nome;
			$baixa = $this->getAll('contabaixa','contaid',$conta->contaid);
			$totalpago = 0;
			foreach($baixa as $bx){
				$totalpago += $bx->valorpago;
			}
			$conta->totalpago = $totalpago;
			$conta->parcela==1 ? $conta->saldo = $conta->valorparcela - $totalpago : $conta->saldo = $conta->totalliquido - $totalpago;
		}
		$this->set(compact('contas'));
	}
	public function relatorios(){
		$session = $this->request->session();
		$usuario = $session->read('login.usuario');
		$hoje = Date('Y-m-d');
		$contaspagar = $this->query("SELECT c.contaid, c.descricao, p.nome, c.totalliquido, s.nome AS subtipo FROM conta c LEFT JOIN pessoa p ON p.pessoaid = c.pessoaid LEFT JOIN subtipoconta s ON s.subtipocontaid = c.subtipocontaid WHERE data_vencimento = '$hoje' AND c.tipocontaid = 2");
		$contasreceber = $this->query("SELECT c.contaid, c.descricao, p.nome, c.totalliquido, s.nome AS subtipo FROM conta c LEFT JOIN pessoa p ON p.pessoaid = c.pessoaid LEFT JOIN subtipoconta s ON s.subtipocontaid = c.subtipocontaid WHERE data_vencimento = '$hoje' AND c.tipocontaid = 1");
		$this->set(compact('contaspagar','contasreceber','usuario'));
	}
	
	public function configuracoes(){

	}

	public function delete(){
		$contaid = intval($_GET['conta']);
		$codmov = intval($_GET['codmov']);
		$conta = $this->get('conta','contaid',$contaid);
		$contabx = $this->getAllTableWhere('contabaixa',['contaid'=>$contaid],[])->all();
		$tipo = $_GET['tipo'];
		$contaTable = TableRegistry::get('conta');
		$contabxTable = TableRegistry::get('contabaixa');
		$contabancoTable = TableRegistry::get('contabanco');
		if($codmov != 0){
			if($tipo=='unico'){
				if(!$contabx->isEmpty()){
					foreach($contabx as $baixa){
						$contabanco = $this->get('contabanco','contabancoid',$baixa->contabancoid);
						if($conta->tipocontaid==1){ //RECEBER
							$saldoatual = $contabanco->saldoatual + $baixa->valorpago;
							$contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
							$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
							$contabancoTable->save($contabanco);
						}else{ //PAGAR
							$saldoatual = $contabanco->saldoatual - $baixa->valorpago;
							$contabancosave = ['saldoanterior'=>$conta->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
							$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
							$contabancoTable->save($contabanco);
						}
					}
					if($contabxTable->deleteAll(['contaid'=>$conta->contaid]) && $contaTable->delete($conta)){
						$this->Flash->success(__('Conta excluída com sucesso.'));
						return $this->redirect(['action' => 'index']);
					}else{
						$this->Flash->error(__('Ocorreu um erro ao excluir conta.'));
						return $this->redirect(['action' => 'index']);
					}
				}else{
					if($contaTable->delete($conta)){
						$this->Flash->success(__('Conta excluída com sucesso.'));
						return $this->redirect(['action' => 'index']);
					}else{
						$this->Flash->error(__('Ocorreu um erro ao excluir conta.'));
						return $this->redirect(['action' => 'index']);
					}
				}
				
			}
			if($tipo=='todos'){
				$contas = $this->getAllTableWhere('conta',['codmov'=>$codmov],[])->all();
					$contabxdell = [];
					foreach($contas as $item){
						$contabx = $this->getAllTableWhere('contabaixa',['contaid'=>$conta->contaid],[])->all();
						if($contabx->first()){
							$valorbaixas = 0;
							$contabanco = $this->get('contabanco','contabancoid',$baixa->contabancoid);
							foreach($contabx as $cbx){
								$valorbaixas+=$cbxatual->valorpago;
							}
							if($conta->tipocontaid==1){ //RECEBER
								$saldoatual = $contabanco->saldoatual + $valorbaixas;
								$contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
								$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
								$contabancoTable->save($contabanco);
							}else{ //PAGAR
								$saldoatual = $contabanco->saldoatual - $valorbaixas;
								$contabancosave = ['saldoanterior'=>$conta->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
								$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
								$contabancoTable->save($contabanco);
							}

							$arr = ['contaid' => $item->contaid];
							array_push($contabxdell,$arr);
						}	
					}
				if(count($contabxdell)>0){
					if($contabxTable->deleteAll($contabxdell) && $contaTable->deleteAll(['codmov'=>$codmov])){
						$this->Flash->success(__('Conta excluída com sucesso.'));
						return $this->redirect(['action' => 'index']);
					}else{
						$this->Flash->error(__('Ocorreu um erro ao excluir conta.'));
						return $this->redirect(['action' => 'index']);
					}
				}else{
					if($contaTable->deleteAll(['codmov'=>$codmov])){
						$this->Flash->success(__('Contas excluídas com sucesso.'));
						return $this->redirect(['action' => 'index']);
					}else{
						$this->Flash->error(__('Ocorreu um erro ao excluir conta.'));
						return $this->redirect(['action' => 'index']);
					}
				}
			}
			if($tipo=='atualiza'){
				$contas = $this->getAllTableWhere('conta',['codmov'=>$codmov],[]);
				$valornovo = $conta->totalliquido - $conta->valorparcela;
				$atualizaconta = [];
				foreach($contas as $item){
					$arr = ['contaid'=>$item->contaid,'totalliquido'=>$valornovo];
					array_push($atualizaconta,$arr);
				}
				$contas = $contaTable->patchEntities($contas,$atualizaconta);

				$contabx = $this->getAllTableWhere('contabaixa',['contaid'=>$conta->contaid],[])->all();
				$valorbaixas=0;
				$contabxdell = 1;
				if(!$contabx->isEmpty()){
					foreach($contabx as $baixa){
						$contabanco = $this->get('contabanco','contabancoid',$baixa->contabancoid);
						if($conta->tipocontaid==1){ //RECEBER
							$saldoatual = $contabanco->saldoatual + $baixa->valorpago;
							$contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
							$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
							$contabancoTable->save($contabanco);
						}else{ //PAGAR
							$saldoatual = $contabanco->saldoatual - $baixa->valorpago;
							$contabancosave = ['saldoanterior'=>$conta->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
							$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
							$contabancoTable->save($contabanco);
						}
					}

					$contabxdell = $contabxTable->deleteAll(['contaid'=>$conta->contaid]);
				}
				if($contaTable->saveMany($contas) && $contabxdell && $contaTable->delete($conta)){
					$this->Flash->success(__('Conta excluída e valores atualizados com sucesso.'));
					return $this->redirect(['action' => 'index']);
				}else{
					$this->Flash->error(__('Ocorreu um erro ao excluir conta.'));
					return $this->redirect(['action' => 'index']);
				}
			}
		}else{
			if(!$contabx->isEmpty()){
				foreach($contabx as $baixa){
					//$this->d($baixa);
					$contabanco = $this->get('contabanco','contabancoid',$baixa->contabancoid);
					//$this->d($contabanco);
					if($conta->tipocontaid==1){ //RECEBER
						$saldoatual = $contabanco->saldoatual - $baixa->valorpago;
						$contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
						$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
						//$this->d($contabanco);
						$contabancoTable->save($contabanco);
					}else{ //PAGAR
						$saldoatual = $contabanco->saldoatual + $baixa->valorpago;
						$contabancosave = ['saldoanterior'=>$conta->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
						$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
						$contabancoTable->save($contabanco);
					}
				}
				if($contabxTable->deleteAll(['contaid'=>$conta->contaid]) && $contaTable->delete($conta)){
					$this->Flash->success(__('Conta excluída com sucesso.'));
					return $this->redirect(['action' => 'index']);
				}else{
					$this->Flash->error(__('Ocorreu um erro ao excluir conta.'));
					return $this->redirect(['action' => 'index']);
				}
			}else{
				if($contaTable->delete($conta)){
					$this->Flash->success(__('Conta excluída com sucesso.'));
					return $this->redirect(['action' => 'index']);
				}else{
					$this->Flash->error(__('Ocorreu um erro ao excluir conta.'));
					return $this->redirect(['action' => 'index']);
				}
			}
		}
	}
	
    public function add(){
		
		$perfilid = $this->perfilid();
        $pessoas = $this->getAllTableWhere('pessoa',[],[]);
        $categorias = $this->getAllTableWhere('categoria',[],[]);
        $centrocusto = $this->getAllTableWhere('centrocusto',['ativo'=>1],[]);
        $planoconta = $this->getAllTableWhere('planoconta',['ativo'=>1],[]);
		$contabanco = $this->getAllTableWhere('contabanco',[],[]);
		$empresas = $this->getAllTableWhere('empresa_crm',[],[]);
		$formapagcondpag = $this->getAllTablewhere('formapag_condpag',[],[])->all();
		$tipoconta = $this->getAllTableWhere('tipoconta',[],[]);
		$subtipoconta = $this->getAllTableWhere('subtipoconta',[],[]);

		foreach($formapagcondpag as $item){
			$item->formapag = $this->get('formapag','formapagid',$item->idformapag)->nome;
			$item->condpag = $this->get('condpag','idcondpag',$item->idcondpag)->descricao;
		}

        $pessoaarr = [];
        foreach($pessoas as $pessoa){
            array_push($pessoaarr,'('.$pessoa->pessoaid.') '.$pessoa->nome);
		}
        
        $sql = "SELECT fc.idformapagcondpag, p.nome as descricao, c.descricao as condicao, c.qtdparcelas FROM formapag p
        INNER JOIN formapag_condpag fc on p.formapagid = fc.idformapag
        INNER JOIN condpag c on c.idcondpag = fc.idcondpag";

        $formapag =$this->query($sql);

		$formapagjson = json_encode($formapag);
		
		if ($this->request->is('post')) {
			$data = $this->request->getData();
			$contaTable = TableRegistry::get('conta');
			$conta = $contaTable->newEntity();
			
			$valortotal = str_replace(',','.',str_replace('.','',$data['valor']));
			$desconto = str_replace(',','.',str_replace('.','',$data['descontovalor']));
			$percdesc = str_replace(',','.',str_replace('.','',$data['percdesconto']));
			if($desconto != ''){
				$valor = $valortotal - $desconto;
			}else{
				$valor = $valortotal;
			}
			/* $regex = '/\((.*?)\)/';
			preg_match($regex, $data['pessoaid'][0], $pessoaid);
			$pessoaid = $pessoaid[1]; */

			if($data['nparcelas']==''){
				$conta->tipocontaid = $data['tipoconta'];
				$conta->subtipocontaid = $data['subtipoconta'];
				$conta->descricao= strtoupper($data['descricao']);
				$conta->pessoaid = $data['pessoaid'];
				$conta->pessoaidcadastro = $this->pessoaid();

				$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag', $data['formapagconta']);
				$conta->formapagid = $formapagcondpag['idformapag'];
				$conta->condpagid = $formapagcondpag['idcondpag'];

				if($perfilid==3){
					$conta->empresaid = $this->empresaid();
				}elseif($perfilid == 1){
					$conta->empresaid = $data['empresaid'];
				}else{
					$this->Flash->error(__('Perfil usuário não autorizado a realizar essa operação.'));
					return $this->redirect(['action' => 'index']);
				}
				
				$conta->data_competencia = $data['datacompetencia'] == '' ? null : $data['datacompetencia'];
				$conta->categoriaid = $data['categoriaid'];
				$conta->data_vencimento = $data['datavencimento'];			
				$conta->totalbruto = $valortotal;
				$conta->totalliquido = $valor;
				$conta->valordesc = $desconto;
				$conta->percdesc = $percdesc;
				$conta->centrocustoid = $data['centrocustoid'];
				$conta->planocontaid = $data['planocontaid'];
				$conta->observacao = $data['observacao'];
				$conta->parcela = 0;
				$data['trecorrencia'] != null ? $conta->recorrente = 1 : $conta->recorrente = 0;
				$conta->status = strtoupper('Pendente Pagamento');
				$conta = $contaTable->save($conta);
				if($conta){
					$this->Flash->success(__('Conta adicionada com sucesso.'));
					if($data['trecorrencia'] != null){
						$this->addrecorrencia($conta,$data);
					}
					$this->anexoupload($conta);
					if(array_key_exists("checkcontabx", $data)){
						$this->addbaixaconta($conta,$data);
					}				
				}
			}else{ 
				$dataVenc = $data['datavencimento'];

				for($i=0; $i<$data['nparcelas']; $i++){
					$conta = $contaTable->newEntity();
					
					$conta->tipocontaid = $data['tipoconta'];
					$conta->subtipocontaid = $data['subtipoconta'];
					$conta->parcela = 1;
					$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag', $data['formapagconta']);
					$conta->formapagid = $formapagcondpag['idformapag'];
					$conta->condpagid = $formapagcondpag['idcondpag'];

					if($i > 0){
						$conta->codmov = $mov->contaid;
					}else{
						$data['trecorrencia'] != null ? $conta->recorrente = 1 : $conta->recorrente = 0;
					}

					$conta->descricao=strtoupper($data['descricao']);
					$conta->pessoaid = $data['pessoaid'];
					$conta->pessoaidcadastro = $this->pessoaid();
					$conta->data_competencia = $data['datacompetencia'] == '' ? null : $data['datacompetencia'];
					$conta->categoriaid = $data['categoriaid'];

					if($perfilid==3){
						$conta->empresaid = $this->empresaid();
					}elseif($perfilid == 1){
						$conta->empresaid = $data['empresaid'];
					}else{
						$this->Flash->error(__('Perfil usuário não autorizado a realizar essa operação.'));
						return $this->redirect(['action' => 'index']);
					}

					if(array_key_exists("datavencparcela", $data)){
						$conta->data_vencimento = $data['datavencparcela'][$i];
					}else{
						if($i==0){
							$conta->data_vencimento = $data['datavencimento'];
							
						}else if($i==1){	
							$dataVenc = date('Y/m/d', strtotime('+' .$data['vencparcela'] .' days', strtotime($dataVenc)));
							$conta->data_vencimento = $dataVenc;
						}else{
							$dias = $data['vencparcela'];						
							$dataVenc = date('Y/m/d', strtotime('+' .$dias .' days', strtotime($dataVenc)));
							$conta->data_vencimento = $dataVenc;
							
						}
					}
					
					$conta->totalbruto = $valortotal;
					$conta->totalliquido = $valor;

					if(array_key_exists("valorparcela", $data)){
						$conta->valorparcela = str_replace(',','.',str_replace('.','',$data['valorparcela'][$i])); 
					}else{
						$valorparcela = floatval($valor)/$data['nparcelas'];
						$valorparcela = round($valorparcela,4);
						$erro = ($valorparcela * $data['nparcelas']) - $valor;
						if($erro > 0 && $i==0){
							$conta->valorparcela = $valorparcela - $erro;
						}else{
							$conta->valorparcela = $valorparcela;
						}
					}

					$conta->centrocustoid = $data['centrocustoid'];
					$conta->planocontaid = $data['planocontaid'];
					$conta->valordesc = $desconto;
					$conta->percdesc = $percdesc;
					$conta->observacao = $data['observacao'];
					$conta->status = strtoupper('Pendente Pagamento');

					
					if($i==0){
						$mov = $contaTable->save($conta);
						if($data['trecorrencia'] != null){
							$this->addrecorrencia($mov,$data);
						}
						$arr = ['contaid'=>$mov->contaid,'codmov'=>$mov->contaid];
						$parcela1 = $contaTable->patchEntity($mov,$arr);
						$mov = $contaTable->save($parcela1);

						if($mov){
							$dellconta = ['contaid'=>$conta->contaid];
							// $this->Flash->success(__('Conta adicionada com sucesso.'));
							$this->anexoupload($conta);
							if(array_key_exists("checkcontabx", $data)){
								$data['parcelaatual']=$i+1;
								$this->addbaixaconta($conta,$data);
							}	
						}else{
							$this->Flash->error(__('Erro ao adicionar conta, tente novamente.'));
							return $this->redirect(['action' => 'index']);
						}
					}else{
						if($contaTable->save($conta)){
							$dellconta = ['contaid'=>$conta->contaid];
							$this->anexoupload($conta);
							if(array_key_exists("checkcontabx", $data)){
								$data['parcelaatual']=$i+1;
								$this->addbaixaconta($conta,$data);
							}	
						}else{
							$this->dellbaixaconta($dellconta);
							$contaTable->deleteAll($dellconta);
							$this->Flash->error(__('Erro ao adicionar conta, tente novamente.'));
							return $this->redirect(['action' => 'index']);
						}
						

					}
			
				}
				$this->Flash->success(__('Conta adicionada com sucesso.'));
			}
			return $this->redirect(['action' => 'index']);
			
		}

		$this->set(compact('formapagcondpag','pessoaarr','tipoconta', 'subtipoconta', 'perfilid','empresas',
		'categorias','centrocusto','planoconta','contabanco','formapagjson'));
		

	}

	public function addrecorrencia($conta,$data){
		$contassave=[];
		$datavencimento = $data['datavencimento'];
		for ($i=0; $i<$data['nrecorrencia']  ; $i++) {
			if($data['temprecorrencia']=='dias'){
				$datavencimento = date('Y/m/d', strtotime('+' .$data['trecorrencia'] .' days', strtotime($datavencimento)));
			} elseif($data['temprecorrencia']=='meses'){
				$datavencimento = date('Y/m/d', strtotime('+' .$data['trecorrencia'] .' months', strtotime($datavencimento)));
			}else{
				$datavencimento = date('Y/m/d', strtotime('+' .$data['trecorrencia'] .' years', strtotime($datavencimento)));
			}
			$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag', $data['formapagconta']);
			$aux = ['descricao'=>$conta->descricao,'data_vencimento'=>$datavencimento,'data_competencia'=>$conta->data_competencia,
					'tipocontaid'=>$conta->tipocontaid,'subtipocontaid'=>$conta->subtipocontaid,'totalbruto'=>$conta->totalbruto,
					'totalliquido'=>$conta->totalbruto,'parcela'=>false,'pessoaid'=>$conta->pessoaid,'empresaid'=>$conta->empresaid,
					'categoriaid'=>$conta->categoriaid,'status'=>strtoupper('Pendente Pagamento'),'centrocustoid'=>$conta->centrocustoid,
					'planocontaid'=>$conta->planocontaid,'pessoaidcadastro'=>$conta->pessoaidcadastro,'codmovrecorrente'=>$conta->contaid,
					'recorrente'=>1,'formapagid'=>$formapagcondpag['idformapag'],'condpagid'=>$formapagcondpag['idcondpag'],'observacao' => $data['observacao']];
			
			array_push($contassave,$aux);
		}
		$contaTable = TableRegistry::get('conta');
		$conta = $contaTable->newEntity();
		$conta = $contaTable->patchEntities($conta,$contassave);
		$contaTable->saveMany($conta);
	}

	public function addbaixaconta($conta, $data){
		$contaTable = TableRegistry::get('conta');
		$contabxTable = TableRegistry::get('contabaixa');
		$contabancoTable = TableRegistry::get('contabanco');
		$dellcontabx = [];
		$banco = [];
		$totalpago = 0;
		

		if($data['nparcelas']==''){
			for($i=0; $i<count($data['idformapag0']); $i++){
				$contabx = $contabxTable->newEntity();
				$contabx->contaid = $conta->contaid;
				$contabx->pessoaidcadastro = $conta->pessoaidcadastro;

				$valorpago = str_replace(',','.',str_replace('.','',$data['valorpago0'][$i]));
				$descbaixa = str_replace(',','.',str_replace('.','',$data['descbaixa0'][$i]));
				$juros = str_replace(',','.',str_replace('.','',$data['juros0'][$i]));
				$contabx->valorpago = $valorpago;
				$contabx->desconto = $descbaixa;
				$contabx->juros = $juros;

				$contabx->contabancoid = $data['idconta0'][$i];
				array_push($banco,['bancoid'=>$contabx->contabancoid,'valor'=>$contabx->valorpago]);
				
				$contabx->data_baixa = $data['datapagamento0'][$i];
				$contabx->empresaid = $conta->empresaid;

				$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag', $data['idformapag0'][$i]);
				$contabx->formapagid = $formapagcondpag['idformapag'];
				$contabx->condpagid = $formapagcondpag['idcondpag'];

				$contasalva = $contabxTable->save($contabx);
				if($contasalva){
					$dellcontabx = ['contabaixaid'=>$contasalva->contabaixaid];
					$totalpago = $totalpago + $contabx->valorpago;
				}else{
					$contabxTable->deleteAll($dellcontabx);
					return $this->Flash->error(__('Ocorreu um erro ao realizar Baixa da Conta, tente novamente.'));
				}
			}
		}else{
			$index = $data['parcelaatual'];
			for($i=0; $i<count($data['idformapag'.$index]); $i++){	
				$contabx = $contabxTable->newEntity();				
				$contabx->contaid = $conta->contaid;
				$contabx->pessoaidcadastro = $conta->pessoaidcadastro;

				$valorpago = str_replace(',','.',str_replace('.','',$data['valorpago'.$index][$i]));
				$descbaixa = str_replace(',','.',str_replace('.','',$data['descbaixa'.$index][$i]));
				$juros = str_replace(',','.',str_replace('.','',$data['juros'.$index][$i]));
				$contabx->valorpago = $valorpago;
				$contabx->desconto = $descbaixa;
				$contabx->juros = $juros;

				$contabx->contabancoid = $data['idconta'.$index][$i];
				array_push($banco,['bancoid'=>$contabx->contabancoid,'valor'=>$contabx->valorpago]);
				
				$contabx->data_baixa = $data['datapagamento'.$index][$i];
				$contabx->empresaid = $conta->empresaid;

				$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag',$data['idformapag'.$index][$i]);
				$contabx->formapagid = $formapagcondpag->idformapag;
				$contabx->condpagid = $formapagcondpag->idcondpag;

				$contasalva = $contabxTable->save($contabx);
				if($contasalva){
					$dellcontabx = ['contabaixaid'=>$contasalva->contabaixaid];
					$totalpago = $totalpago + $contabx->valorpago;
				}else{
					$contabxTable->deleteAll($dellcontabx);
					return $this->Flash->error(__('Ocorreu um erro ao realizar Baixa da Conta, tente novamente.'));
				}
					
			}
			
		}

		if($totalpago < $conta->totalliquido){
			$arr = ['contaid'=>$conta->contaid,'status'=> strtoupper('Pagamento Parcial')];
			$conta = $contaTable->patchEntity($conta,$arr);
			if($contaTable->save($conta)){	
				for ($i=0; $i < count($banco) ; $i++) { 				
					$contabanco = $this->get('contabanco','contabancoid',$banco[$i]['bancoid']);
					if($conta->tipocontaid==1){ //RECEBER
						$saldoatual = $contabanco->saldoatual + $banco[$i]['valor'];
						$contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
						$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
						$contabancoTable->save($contabanco);
					}else{ //PAGAR
						$saldoatual = $contabanco->saldoatual - $totalpago;
						$contabancosave = ['saldoanterior'=>$conta->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
						$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
						$contabancoTable->save($contabanco);
					}
				}
				return $this->Flash->success(__('Baixa da Conta Realizada com sucesso.'));
			}else{
				return $this->Flash->error(__('Ocorreu um erro ao realizar Baixa da Conta, tente novamente.'));
			}
		}else{
			$arr = ['contaid'=>$conta->contaid,'status'=> strtoupper('Pago')];
			$conta = $contaTable->patchEntity($conta,$arr);
			if($contaTable->save($conta)){
				$contabanco = $this->get('contabanco','contabancoid',$contasalva->contabancoid);
				if($conta->tipocontaid==1){ //RECEBER
					$saldoatual = $contabanco->saldoatual + $totalpago;
					$contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s') ];
					$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
					$contabancoTable->save($contabanco);
				}else{ //PAGAR
					$saldoatual = $contabanco->saldoatual - $totalpago;
					$contabancosave = ['saldoanterior'=>$contabanco->saldoatual,'saldoatual' => $saldoatual,'saldoanterior_data'=> Date('Y-m-d h:i:s')];
					$contabanco = $contabancoTable->patchentity($contabanco,$contabancosave);
					$contabancoTable->save($contabanco);
				}
				return $this->Flash->success(__('Baixa da Conta Realizada com sucesso.'));
			}else{
				$contabxTable->deleteAll($dellcontabx);
				return $this->Flash->error(__('Ocorreu um erro ao realizar Baixa da Conta, tente novamente.'));
			}
		}
	}

	public function edit(){
		$perfilid = $this->perfilid();
        $pessoas = $this->getAllTableWhere('pessoa',[],[]);
        $categorias = $this->getAllTableWhere('categoria',[],[]);
        $centrocusto = $this->getAllTableWhere('centrocusto',[],[]);
        $planoconta = $this->getAllTableWhere('planoconta',[],[]);
		$contabanco = $this->getAllTableWhere('contabanco',[],[]);
		$empresas = $this->getAllTableWhere('empresa_crm',[],[]);
		$tipoconta = $this->getAllTableWhere('tipoconta',[],[]);
		$subtipoconta = $this->getAllTableWhere('subtipoconta',[],[]);
		$formapagcondpag = $this->getAllTablewhere('formapag_condpag',[],[])->all();
		foreach($formapagcondpag as $item){
			$item->formapag = $this->get('formapag','formapagid',$item->idformapag)->nome;
			$item->condpag = $this->get('condpag','idcondpag',$item->idcondpag)->descricao;
		}

		$contaid = $_GET['id'];
		$conta = $this->get('conta','contaid',$contaid);
		$parcelado = $this->getAllTableWhere('conta',['codmov'=>$contaid],[])->all()->first() == null ? $parcelado=0 : $parcelado=1;

		if($conta->parcela==1){
			$conta->valor = $conta->valorparcela;
			$conta->desconto = $conta->valorparcela * ($conta->percdesc/100);
		}else{
			$conta->valor  = $conta->totalbruto;
			$conta->desconto = $conta->valordesc;
		}
		$anexos = $this->getAllTableWhere('contaanexo',['contaid' => $conta->contaid],[]);
		$contabx = $this->getAllTableWhere('contabaixa',['contaid'=>$conta->contaid],[])->all();
		$totalbaixa = 0;
		if($contabx->first()){
			foreach($contabx as $cbx){
				$totalbaixa += $cbx->valorpago;
			}
		}
		
        /* $pessoaarr = [];
        foreach($pessoas as $pessoa){
			array_push($pessoaarr,'('.$pessoa->pessoaid.') '.$pessoa->nome);
			if($conta->pessoaid == $pessoa->pessoaid){
				$conta->pessoa = '('.$pessoa->pessoaid.') '.$pessoa->nome;
			}
		} */

		if ($this->request->is('post')) {
			$data = $this->request->getData();
			$contaTable = TableRegistry::get('conta');
			$contabxTable = TableRegistry::get('contabaixa');
			/* $regex = '/\((.*?)\)/';
			preg_match($regex, $data['pessoaid'][0], $pessoaid);
			$pessoaid = $pessoaid[1]; */
			$pessoaid = $data['pessoaid'];
			$valortotal = str_replace(',','.',str_replace('.','',$data['valor']));
			$desconto = str_replace(',','.',str_replace('.','',$data['descontovalor']));
			$percdesc = str_replace(',','.',str_replace('.','',$data['percdesconto']));
			if($desconto != ''){
				$valor = $valortotal - $desconto;
			}else{
				$valor = $valortotal;
			}
			$data['trecorrencia'] != null ? $recorrente=1 : $recorrente=0;
			if($conta->parcela!=1){
				if($data['nparcelas']=='' && !array_key_exists("checkparcelar", $data)){
					$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag',$data['formapagconta']);
					$contaedit = ['contaid'=>$contaid, 'empresaid' => $data['empresaid'], 'pessoaid'=>$data['pessoaid'], 'descricao' => $data['descricao'],
					'categoriaid' => $data['categoriaid'], 'data_competencia' => $data['datacompetencia'], 'data_vencimento' => $data['datavencimento'],
					'centrocustoid' => $data['centrocustoid'], 'planocontaid' => $data['planocontaid'], 'totalbruto' => $valortotal,'tipocontaid' => $data['tipoconta'],
					'subtipocontaid'=>$data['subtipoconta'],'totalliquido' => $valor, 'valordesc' => $desconto, 'percdesc' => $percdesc, 'observacao' => $data['observacao'],
					'formapagid'=>$formapagcondpag['idformapag'],'condpagid'=>$formapagcondpag['idcondpag']];
					$contasave = $contaTable->newEntity();
					$contasave = $contaTable->patchEntity($contasave,$contaedit);
					$conta = $contaTable->save($contasave);
					if($conta){
						$this->anexoupload($conta);
						if($data['trecorrencia'] != null){
							$this->addrecorrencia($conta,$data);
						}
						$this->Flash->success(__('Conta salva com sucesso.'));
						return $this->redirect(['action' => 'index']);
					}else{
						$this->Flash->error(__('Ocorreu um erro ao salvar alterações da conta.'));
						return $this->redirect(['action' => 'index']);
					}

				}else{
					$dataVenc = $data['datavencimento'];
					
					$arrconta = [];
					for ($i=0; $i < $data['nparcelas'] ; $i++) {

						if($totalbaixa==0){
							if(array_key_exists('valorparcela',$data)){
								$valorparcela = str_replace(',','.',str_replace('.','',$data['valorparcela'][$i])); 
							}else{
								$valorparcela = floatval($conta->totalliquido)/$data['nparcelas'];
								$valorparcela = round($valorparcela,4);
								$erro = ($valorparcela * $data['nparcelas']) -$conta->totalliquido;
								if($erro > 0 && $i==0){
									$valorparcela = $valorparcela - $erro;
								}
							}
						}elseif($totalbaixa < $conta->totalliquido){
							if(array_key_exists('valorparcela',$data)){
								$valorparcela = str_replace(',','.',str_replace('.','',$data['valorparcela'][$i])); 
							}else{
								$valorparcela = ($conta->totalliquido - $totalbaixa)/$data['nparcelas'];
								$valorparcela = round($valorparcela,4);
								$erro = ($valorparcela * $data['nparcelas']) - ($conta->totalliquido - $totalbaixa);
								if($erro > 0 && $i==0){
									$valorparcela = $valorparcela - $erro;
								}
							}

							$valorparcela1 = $totalbaixa;
							$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag',$data['formapagconta']);

							$contaedit = ['contaid'=>$contaid, 'empresaid' => $data['empresaid'], 'pessoaid'=>$pessoaid, 'descricao' => $data['descricao'],
							'categoriaid' => $data['categoriaid'], 'data_competencia' => $data['datacompetencia'], 'data_vencimento' => $data['datavencimento'],
							'centrocustoid' => $data['centrocustoid'], 'planocontaid' => $data['planocontaid'], 'totalbruto' => $valortotal,'tipocontaid' => $data['tipoconta'],
							'subtipocontaid'=>$data['subtipoconta'],'totalliquido' => $valor, 'valordesc' => $desconto, 'percdesc' => $percdesc, 'observacao' => $data['observacao'],
							'valorparcela'=>$valorparcela1,'parcela'=>1,'codmov'=>$conta->contaid,'status'=>strtoupper('Pago'),'formapagid'=>$formapagcondpag['idformapag'],'condpagid'=>$formapagcondpag['idcondpag']];
							
							$conta = $contaTable->patchEntity($conta,$contaedit);
							$conta = $contaTable->save($conta);
							if($conta){
								$this->anexoupload($conta);
							}else{
								$this->Flash->error(__('Ocorreu um erro ao salvar alterações da conta.'));
								return $this->redirect(['action' => 'index']);
							}
						}

						if($i==0){
							if(array_key_exists('datavencparcela',$data)){
								$dataVenc = $data['datavencparcela'][$i];
							}

							$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag',$data['formapagconta']);
							$contaedit = ['empresaid' => $data['empresaid'], 'pessoaid'=>$pessoaid, 'descricao' => $data['descricao'],
							'categoriaid' => $data['categoriaid'], 'data_competencia' => $data['datacompetencia'], 'data_vencimento' => $data['datavencimento'],
							'centrocustoid' => $data['centrocustoid'], 'planocontaid' => $data['planocontaid'], 'totalbruto' => $valortotal,'tipocontaid' => $data['tipoconta'],
							'subtipocontaid'=>$data['subtipoconta'],'totalliquido' => $valor,'totalbruto'=>$conta->totalbruto, 'valordesc' => $desconto, 'percdesc' => $percdesc, 'observacao' => $data['observacao'],
							'valorparcela'=>$valorparcela,'parcela'=>1,'codmov'=>$conta->contaid,'status'=>strtoupper('Pendente Pagamento'),'formapagid'=>$formapagcondpag['idformapag'],
							'condpagid'=>$formapagcondpag['idcondpag']];
							
							if($totalbaixa==0){
								$conta = $contaTable->patchEntity($conta,$contaedit);
								$conta = $contaTable->save($conta);
								if($conta){
									$this->anexoupload($conta);
								}else{
									$this->Flash->error(__('Ocorreu um erro ao salvar alterações da conta.'));
									return $this->redirect(['action' => 'index']);
								}
							}else{
								$contasave = $contaTable->newEntity();
								$contasave = $contaTable->patchEntity($contasave,$contaedit);
								$contasave = $contaTable->save($contasave);
							}
							
							
							
						}else{
							if(array_key_exists('datavencparcela',$data)){
								$dataVenc = $data['datavencparcela'][$i];
							}else{
								$dataVenc = date('Y/m/d', strtotime('+' .$data['vencparcela'] .' days', strtotime($dataVenc)));
							}

							$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag',$data['formapagconta']);
							$contaedit = ['empresaid' => $data['empresaid'], 'pessoaid'=>$pessoaid, 'descricao' => $data['descricao'],
							'categoriaid' => $data['categoriaid'], 'data_competencia' => $data['datacompetencia'], 'data_vencimento' => $dataVenc,
							'centrocustoid' => $data['centrocustoid'], 'planocontaid' => $data['planocontaid'], 'totalbruto' => $valortotal,'tipocontaid' => $data['tipoconta'],
							'subtipocontaid'=>$data['subtipoconta'],'totalliquido' => $valor, 'valordesc' => $desconto, 'percdesc' => $percdesc, 'observacao' => $data['observacao'],
							'valorparcela'=>$valorparcela,'parcela'=>1,'codmov'=>$conta->contaid,'status'=>strtoupper('Pendente Pagamento'),'formapagid'=>$formapagcondpag['idformapag'],'condpagid'=>$formapagcondpag['idcondpag']];
							
							array_push($arrconta,$contaedit);

						}
					}
					$contasave = $contaTable->newEntity();
					$contasave = $contaTable->patchEntities($contasave,$arrconta);
					$contasave = $contaTable->saveMany($contasave);
					
					if($contasave){
						$this->Flash->success(__('Alterações da conta salvas com sucesso.'));
						return $this->redirect(['action' => 'index']);
					}else{
						$this->Flash->error(__('Ocorreu um erro ao salvar alterações da conta.'));
						return $this->redirect(['action' => 'index']);
					}

				}
			}else{
				$formapagcondpag = $this->get('formapag_condpag','idformapagcondpag',$data['formapagconta']);
				$contaedit = ['contaid'=>$contaid, 'empresaid' => $data['empresaid'], 'pessoaid'=>$data['pessoaid'], 'descricao' => $data['descricao'],
				'categoriaid' => $data['categoriaid'], 'data_competencia' => $data['datacompetencia'], 'data_vencimento' => $data['datavencimento'],
				'centrocustoid' => $data['centrocustoid'], 'planocontaid' => $data['planocontaid'], 'valorparcela' => $valortotal,'tipocontaid' => $data['tipoconta'],
				'subtipocontaid' => $data['subtipoconta'], 'valordescparcela' => $desconto, 'percdescparcela' => $percdesc, 'observacao' => $data['observacao'],'formapagid'=>$formapagcondpag['idformapag'],'condpagid'=>$formapagcondpag['idcondpag'] ];
			}
			$contasave = $contaTable->newEntity();
			$contasave = $contaTable->patchEntity($contasave,$contaedit);
			$conta = $contaTable->save($contasave);
			if($conta){
				$this->anexoupload($conta);
				$this->Flash->success(__('Conta salva com sucesso.'));
				return $this->redirect(['action' => 'index']);
			}else{
				$this->Flash->error(__('Ocorreu um erro ao salvar alterações da conta.'));
				return $this->redirect(['action' => 'index']);
			}
		}

		$this->set(compact('conta','contabx','totalbaixa','formapagcondpag','tipoconta','subtipoconta','perfilid',
		'empresas','categorias','parcelado','anexos','centrocusto','planoconta','contabanco'));

	}

    public function dellbaixaconta($dellconta){
		$contabxTable = TableRegistry::get('contabaixa');
		$dellcontabx=[];
		for($i=0; $i<count($dellconta['contaid']); $i++){
			$contasbx = $this->getAllTableWhere('contabaixa',['contaid'=>$dellconta['contaid'],[]])->all();
			foreach($contasbx as $contabx){
				$dellcontabx=['contabaixaid'=>$contabx->contabaixaid];
			}
		}
		$contabxTable->deleteAll($dellcontabx);
    }

    public function extensoesPermitidas(){
		return ['jpg','jpeg','png','pdf','doc','docx','xls','xlsx','txt','zip','rar','csv'];
	}

    public function anexoupload($conta){
		if(!isset($_FILES['File']) || count($_FILES['File']['tmp_name'])==0){
			return;
		}

		for($i=0;$i < count($_FILES['File']['tmp_name']);$i++){
			if(strlen($_FILES['File']['tmp_name'][$i])==0){ return; }

			$extensao = pathinfo($_FILES['File']['name'][$i], PATHINFO_EXTENSION);
			if(!in_array(strtolower($extensao),$this->extensoesPermitidas()) ) {
				$this->Flash->error(__('Arquivo não enviado, formato de arquivo inválido! os formatos suportados são: jpg, jpeg, png, pdf, doc, docx, xls, xlsx, txt, zip, rar e csv.'));
				
			}

			$uploadfile = $this->getUploadDir()
				.basename($conta->empresaid.'_'.$conta->pessoaidcadastro."_".$conta->contaid."_".date('Ymd').$i)
				.".".$extensao;

			if(move_uploaded_file($_FILES['File']['tmp_name'][$i], $uploadfile)){
				$this->insert('contaanexo',[
					'contaid'=>$conta->contaid
					,'nome'=>$_FILES['File']['name'][$i]
					,'caminho'=> "http://" . $_SERVER['SERVER_NAME'].'/flygestor/app/webroot/arquivos/crmmarmore/'.$conta->empresaid.'_'.$conta->pessoaidcadastro."_".$conta->contaid."_".date('Ymd').$i.".".$extensao
				]);
				
			}
		}


		return;
    }
    
    public function getUploadDir(){
		$uploaddir = ROOT."/webroot/arquivos/crmmarmore/";
		if($this->isLocalhost()){
				$uploaddir = ROOT."\webroot\arquivos\\crmmarmore\\";
		}

		return $uploaddir;
	}

	public function dellanexo(){
		$anexoid = $_GET['id'];
		$contaanexoTable = TableRegistry::get('contaanexo');
		$contaanexo = $this->get('contaanexo','contaanexoid',$anexoid);
		$contaanexoTable->delete($contaanexo);
	}

	

}