<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;

class FlyleadsController extends AppController
{
    function index() {

        if ($this->request->is(['post'])) {
            $pessoaTable = TableRegistry::get('pessoa');
            $data = $this->request->getData();

            if(array_key_exists('check', $data)){
                $itens = $data['check'];
                $itens = implode(",",$itens);
                $selected = $this->query("SELECT * from flyleads where id in ($itens)");

                foreach ($selected as $item) {
                    $pessoa = $pessoaTable->newEntity();
                    $pessoa->nome = $item->razaosocial;
                    $pessoa->razaosocial = $item->razaosocial;
                    $pessoa->cpfcnpj = $item->cnpj;
                    $pessoa->email = $item->email;
                    $pessoa->cidade = $item->cidade;
                    $pessoa->estado = $item->estado;
                    $pessoa->cpfmae = $item->telefone;
                    $pessoa->empresaid = $this->empresaid();
                    $pessoa = $pessoaTable->save($pessoa);
                    if (!$pessoa) {
                         $this->Flash->error(__('Selecione pelo menos um Lead da lista.'));
                         return $this->redirect(['controller' => 'painel','action' => 'admsistema']);
                    } else {
                        $this->insert('cliente',[
                            'pessoaid' => $pessoa->pessoaid,
                            'tipocliente' => 'lead',
                            'ativo' => 1,
                            'empresaid'=>$this->empresaid(),
                            'pessoaidcadastro' => $this->pessoaid()
                        ]);

                        $this->insert('endereco',[
                            'pessoaid' => $pessoa->pessoaid,
                            'pessoaidcadastro' => $this->pessoaid(),
                            'logradouro' => $item->logradouro,
                            'cidade' => $item->cidade,
                            'estado' => $item->estado,
                        ]);
                    }
                }
                $this->Flash->success(__('Leads inseridos com Sucesso.'));
                return $this->redirect(['controller' => 'painel','action' => 'admsistema']);
            }
        }

        $this->set(compact('flyleads'));
    }
    public function tabelaleads($estado, $cidade, $cod_secao, $cod_divisao, $cod_grupo, $cod_classe) {
        $estado = explode(',',$estado);
        $cidade = explode(',',$cidade);
        $cod_secao = explode(',',$cod_secao);
        $cod_divisao = explode(',',$cod_divisao);
        $cod_grupo = explode(',',$cod_grupo);
        $cod_classe = explode(',',$cod_classe);

        $flyleadsindex = $this->Flyleads->find('all')->order(['id'=>'asc']);
        $estadoquery = (in_array('todos', $estado)) ? '' : 'WHERE estado IN (\''.implode("','",$estado).'\')';

        $cidadequery = (in_array('todas', $cidade)) ? '' : 'AND cidade IN (\''.implode("','",$cidade).'\')';

        $secoesquery = (in_array('todas', $cod_secao)) ? '' : 'AND cod_secao IN (\''.implode("','",$cod_secao).'\')';

        $divisoesquery = (in_array('todas', $cod_divisao)) ? '' : 'AND cod_divisao IN (\''.implode("','",$cod_divisao).'\')';

        $gruposquery = (in_array('todos', $cod_grupo)) ? '' : 'AND cod_grupo IN (\''.implode("','",$cod_grupo).'\')';

        $classequery = (in_array('todas', $cod_classe)) ? '' : 'AND cod_classe IN (\''.implode("','",$cod_classe).'\')';

        $flyleadsindex = $this->query("
            SELECT * FROM flyleads WHERE 1=1 $estadoquery $cidadequery $secoesquery $divisoesquery $gruposquery $classequery
        ");
        $this->set(compact([
            'flyleadsindex'
        ]));
    }
    public function filtros($estado, $cidade, $cod_secao, $cod_divisao, $cod_grupo, $cod_classe) {
        //$estado, $cidade, $cod_secao, $cod_divisao, $cod_grupo, $cod_classe
        $estado = explode(',',$estado);
        $cidade = explode(',',$cidade);
        $cod_secao = explode(',',$cod_secao);
        $cod_divisao = explode(',',$cod_divisao);
        $cod_grupo = explode(',',$cod_grupo);
        $cod_classe = explode(',',$cod_classe);

        $estadoquery = (in_array('todos', $estado)) ? '' : 'WHERE estado IN (\''.implode("','",$estado).'\')';
        $estados = $this->query("SELECT distinct estado from flyleads $estadoquery");
        $estadosarray = [];
        foreach ($estados as $item) {
            array_push($estadosarray, $item->estado);
        }
        $estadosarray = implode("','",$estadosarray);
        $cidadequery = (in_array('todas', $cidade)) ? '' : 'AND cidade IN (\''.implode("','",$cidade).'\')';

        $cidades = $this->query("SELECT distinct cidade from flyleads WHERE estado IN ('$estadosarray') $cidadequery");
        $cidadesarray = [];
        foreach ($cidades as $item) {
            array_push($cidadesarray, $item->cidade);
        }
        $cidadesarray = implode("','",$cidadesarray);
        $secoesquery = (in_array('todas', $cod_secao)) ? '' : 'AND cod_secao IN (\''.implode("','",$cod_secao).'\')';
        $secoes = $this->query("SELECT distinct cod_secao, nm_secao from flyleads WHERE cidade IN ('$cidadesarray') $secoesquery");

        $secoesarray = [];
        foreach ($secoes as $item) {
            array_push($secoesarray, $item->cod_secao);
        }
        $secoesarray = implode("','",$secoesarray);
        $divisoesquery = (in_array('todas', $cod_divisao)) ? '' : 'AND cod_divisao IN (\''.implode("','",$cod_divisao).'\')';
        $divisoes = $this->query("SELECT distinct cod_divisao, nm_divisao from flyleads WHERE cod_secao IN ('$secoesarray') $divisoesquery");

        $divisoesarray = [];
        foreach ($divisoes as $item) {
            array_push($divisoesarray, $item->cod_divisao);
        }
        $divisoesarray = implode("','",$divisoesarray);
        $gruposquery = (in_array('todos', $cod_grupo)) ? '' : 'AND cod_grupo IN (\''.implode("','",$cod_grupo).'\')';
        $grupos = $this->query("SELECT distinct cod_grupo, nm_grupo from flyleads WHERE cod_divisao IN ('$divisoesarray') $gruposquery");

        $gruposarray = [];
        foreach ($grupos as $item) {
            array_push($gruposarray, $item->cod_grupo);
        }
        $gruposarray = implode("','",$gruposarray);
        $classesquery = (in_array('todas', $cod_classe)) ? '' : 'AND cod_classe IN (\''.implode("','",$cod_classe).'\')';

        $classes = $this->query("SELECT distinct cod_classe, nm_classe from flyleads WHERE cod_grupo IN ('$gruposarray') $classesquery");
        $this->set(compact('secoes','divisoes','grupos','classes','estados','cidades','estado', 'cidade', 'cod_secao', 'cod_divisao', 'cod_grupo', 'cod_classe'));
    }

    public function tabelamodaldivisao($cod_secao, $cod_divisao, $cod_grupo, $cod_classe, $impacto) {
        $cod_divisao = explode(',',$cod_divisao);
        $cod_grupo = explode(',',$cod_grupo);
        $cod_classe = explode(',',$cod_classe);
        $impacto = explode(',',$impacto);
        $anoAtual = Date('Y');
        $mesAtual = Date('m');
        $divisaoquery = (in_array('todas', $cod_divisao)) ? '' : 'AND cod_divisao IN (\''.implode("','",$cod_divisao).'\')';
        $grupoquery = (in_array('todos', $cod_grupo)) ? '' : 'AND cod_grupo IN (\''.implode("','",$cod_grupo).'\')';
        $classequery = (in_array('todas', $cod_classe)) ? '' : 'AND cod_classe IN (\''.implode("','",$cod_classe).'\')';
        $impactoquery = (in_array('todas', $impacto)) ? '' : 'AND setor IN (\''.implode("','",$impacto).'\')';
        $sql = "SELECT * FROM flyleads
            WHERE cod_secao = '$cod_secao' $divisaoquery $grupoquery $classequery $impactoquery
            GROUP BY cd.cod_divisao
        ";
        $modaldivisao = $this->query($sql);


        $this->set(compact(
            'modaldivisao'
            ,'cod_secao'
            ,'modalempresadivisao'
            ,'secao'
            ,'qtd_empresas'
            ,'qtd_individuos'
            ,'total'
            ,'ticket_medio'
            ,'usuario'
            ,'totalvalor'
            ,'empresa'
            ,'ticket_medioemp'
        ));
    }
}
