<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;

/**
 * Funil Controller
 *
 * @property \App\Model\Table\FunilTable $Funil
 *
 * @method \App\Model\Entity\Funil[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class FunilController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $funil = $this->paginate($this->Funil);

        $this->set(compact('funil'));
    }

    /**
     * View method
     *
     * @param string|null $id Funil id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $funil = $this->Funil->get($id, [
            'contain' => []
        ]);

        $this->set('funil', $funil);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $funil = $this->Funil->newEntity();
        if ($this->request->is('post')) {
            $funil = $this->Funil->patchEntity($funil, $this->request->getData());
            if ($this->Funil->save($funil)) {
                $this->Flash->success(__('Funil salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Funil não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('funil'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Funil id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $funil = $this->Funil->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $funil = $this->Funil->patchEntity($funil, $this->request->getData());
            if ($this->Funil->save($funil)) {
                $this->Flash->success(__('Funil salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Funil não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('funil'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Funil id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $funil = $this->Funil->get($id);
        if ($this->Funil->delete($funil)) {
            $this->Flash->success(__('Funil deletado com sucesso.'));
        } else {
            $this->Flash->error(__('Funil não pode ser deletado. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
