<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;

/**
 * Grupoproduto Controller
 *
 * @property \App\Model\Table\GrupoprodutoTable $Grupoproduto
 *
 * @method \App\Model\Entity\Grupoproduto[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class GrupoprodutoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $grupoprodutos = $this->Grupoproduto->find('all');

        $this->set([
			'grupoprodutos'=>$grupoprodutos		
		]);
    }

    /**
     * View method
     *
     * @param string|null $id Grupoproduto id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $grupoproduto = $this->Grupoproduto->get($id, [
            'contain' => []
        ]);

        $this->set('grupoproduto', $grupoproduto);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $grupoproduto = $this->Grupoproduto->newEntity();
        if ($this->request->is('post')) {
            $grupoproduto = $this->Grupoproduto->patchEntity($grupoproduto, $this->request->getData());
			$grupoproduto->pessoaidcadastro = $this->pessoaid();
			$grupoproduto->empresaid        = $this->empresaid();
            if ($this->Grupoproduto->save($grupoproduto)) {
                $this->Flash->success(__('Grupo Produto foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Grupo Produto não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('grupoproduto'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Grupoproduto id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $grupoproduto = $this->Grupoproduto->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $grupoproduto = $this->Grupoproduto->patchEntity($grupoproduto, $this->request->getData());
            if ($this->Grupoproduto->save($grupoproduto)) {
                $this->Flash->success(__('Grupo Produto foi editado com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Grupo Produto não pode ser editado. Por favor tente mais tarde.'));
        }
        $this->set(compact('grupoproduto'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Grupoproduto id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $grupoproduto = $this->Grupoproduto->get($id);
        if ($this->Grupoproduto->delete($grupoproduto)) {
            $this->Flash->success(__('Grupo Produto foi deletado com sucesso.'));
        } else {
            $this->Flash->error(__('Grupo Produto não pode ser deletado. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
