<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

class PainelController extends AppController
{

	public function index(){
		$perfilid = $this->perfilid();
		$session = $this->request->session();
		$pagina_inicial = str_replace('/flystart/painel/','',$session->read('login.perfilcrm')->pagina_inicial);

		return $this->redirect(['controller'=>'Painel', 'action'=>$pagina_inicial]);
	}
    public function admsistema($id=null){
		
		$perfilid = $this->perfilid();
		$idusuario = $this->usuarioid();
		$mesreferencia = $this->mesreferencia();
		$anoreferencia = $this->anoreferencia();
		$datainicio     = date('Y-m-01');
		$datainicioview = date('01/m/Y');
		$datafim	    = date('Y-m-d');
		$datafimview	= date('d/m/Y');

		if(isset($_POST['periodo'])){
			$datainicioview = explode(' - ',$_POST['periodo'])[0];
			$datafimview    = explode(' - ',$_POST['periodo'])[1];

			$datainicio = $this->formatDataToDatabase($datainicioview);
			$datafim    = $this->formatDataToDatabase($datafimview);
		}

		//contexto de vendedor
		$vendedoridcontexto = -1;
		if(in_array($perfilid,[5])){	
			$vendedoridcontexto = $this->getAllTableWhere('vendedor',[
				'idempresa_crm'=> $this->empresaid()
				],[]);
		}

		if($id != null){
			$vendedoridcontexto = $id;
		}
		//fim contexto de vendedor

		$empresaid = -1;
		if(isset($_POST['empresaid'])){
			$empresaid = $_POST['empresaid'];
        }

        $funilTable  = TableRegistry::get('funil');
		$funil = $funilTable->find('all')
        ->innerJoin('usuariofunil',['usuariofunil.idfunil = funil.idfunil'])
		->where(['usuariofunil.idusuario' =>$idusuario, 'funil.ativo' => 1] )
		->order(['funil.idfunil']);
		
		$funilid = $funil->first()->idfunil;
		if(isset($_POST['funilid'])){
			$funilid = $_POST['funilid'];
		}
        $funilidimplode = $funilid;
		if(is_array($funilid)){
			$funilidimplode = implode(',',$funilid);
		}
		
		$funil = $funilTable->find('all')
        ->innerJoin('usuariofunil',['usuariofunil.idfunil = funil.idfunil'])
		->where(['usuariofunil.idusuario' =>$idusuario, 'funil.ativo' => 1] )
		->order(['funil.idfunil']);

		$empresas = [];
		//adm sistema
		if(in_array($perfilid,[1])){
			$empresas = $this->getAllTableWhere('empresa_crm',['ativo'=>1],['empresaid'=>'asc']);
        }

        //$this->d($funil->all());

		$vendedorid = -1;
		if(isset($_POST['vendedorid'])){
			$vendedorid = $_POST['vendedorid'];
		}

		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$empresaidimplode = $empresaid;
		if(is_array($empresaid)){
			$empresaidimplode = implode(',',$empresaid);
		}

		//adm grupo
		if(in_array($perfilid,[2])){
			$empresasidarr = [];
			$usuarios = $this->getAllTableWhere('usuario_crm',['usuarioid'=>$this->sessionread('login.usuario')->idusuario],[]);
			foreach($usuarios as $item){
				array_push($empresasidarr,$item->empresaid);
			}
			$empresas = $this->getAllTableWhere('empresa_crm',['empresaid IN'=>$empresasidarr],['empresaid'=>'asc']);

			if($empresaid == -1){
				$empresaidimplode = implode(',',$empresasidarr);
			}
		}
		
		$this->set([
			'datainicio'=>$datainicio
			,'datainicioview'=>$datainicioview
			,'datafim'=>$datafim
			,'datafimview'=>$datafimview
			,'empresas'=>$empresas
			,'empresaid'=>$empresaid
			,'empresaidimplode'=>$empresaidimplode
			,'mesreferencia'=>$mesreferencia
			,'anoreferencia'=>$anoreferencia
			,'vendedoridcontexto'=>$vendedoridcontexto
			,'vendedorid'=>$vendedorid
			,'vendedoridimplode'=>$vendedoridimplode
			,'funil'=>$funil
			,'funilid'=>$funilid
			,'funilidimplode'=>$funilidimplode
		]);
	}
	
	public function vnd($id = null){
		$perfilid = $this->perfilid();
		$mesreferencia = $this->mesreferencia();
		$anoreferencia = $this->anoreferencia();
		$datainicio     = date('Y-m-01');
		$datainicioview = date('01/m/Y');
		$datafim	    = date('Y-m-d');
		$datafimview	= date('d/m/Y');
		$idusuario = $this->usuarioid();
		$session = $this->request->session();
		if(isset($_POST['periodo'])){
			$datainicioview = explode(' - ',$_POST['periodo'])[0];
			$datafimview    = explode(' - ',$_POST['periodo'])[1];

			$datainicio = $this->formatDataToDatabase($datainicioview);
			$datafim    = $this->formatDataToDatabase($datafimview);
		}

		$usuariocrm = $this->get('usuario_crm','usuarioid',$session->read('login.usuario')->idusuario);
		$empresaid = [ $this->empresaid()]; 
		
		$empresaidimplode = $empresaid;
		if(is_array($empresaid)){
			$empresaidimplode = implode(',',$empresaid);
		}

		//contexto de vendedor
		$vendedoridcontexto = -1;
		if(in_array($perfilid,[5])){
			$vendedoridcontexto = $this->vendedorid();
		}


		if($id != null){
			$vendedoridcontexto = $id;
		}
		//fim contexto de vendedor

		$empresas = [$this->get('empresa_crm','empresaid',$this->empresaid())];
		

        $funil = [];

        $funilTable  = TableRegistry::get('funil');
		$funil = $funilTable->find('all')
        ->innerJoin('usuariofunil',['usuariofunil.idfunil = funil.idfunil'])
		->where(['usuariofunil.idusuario' =>$idusuario, 'funil.ativo' => 1] )
		->order(['funil.idfunil']);
		
		$funilid = $funil->first()->idfunil;
		if(isset($_POST['funilid'])){
			$funilid = $_POST['funilid'];
		}
        $funilidimplode = $funilid;
		if(is_array($funilid)){
			$funilidimplode = implode(',',$funilid);
		}
		
		$funil = $funilTable->find('all')
        ->innerJoin('usuariofunil',['usuariofunil.idfunil = funil.idfunil'])
		->where(['usuariofunil.idusuario' =>$idusuario, 'funil.ativo' => 1] )
		->order(['funil.idfunil']);
		$this->set([
			'mesreferencia'=>$mesreferencia
			,'anoreferencia'=>$anoreferencia
			,'vendedoridcontexto'=>$vendedoridcontexto
			,'vendedoridimplode'=>$vendedoridcontexto
			,'empresaid'=>$this->empresaid()
			,'perfilid'=>$perfilid
			,'empresaid'=>$empresaid
			,'empresaidimplode'=>$empresaidimplode
			,'empresas'=>$empresas
			,'datainicio'=>$datainicio
			,'datainicioview'=>$datainicioview
			,'datafim'=>$datafim
			,'datafimview'=>$datafimview
			,'funil'=>$funil
			,'funilid'=>$funilid
			,'funilidimplode'=>$funilidimplode
		]);
	}
	
	public function admgrupo(){
		$this->admsistema();
		$this->render('admsistema');
	}

	public function sec(){
		$this->admempresa();
		$this->render('admempresa');
    }
	
	public function secsis(){
		$this->admsistema();
		$this->render('admsistema');
	}
	
	public function admempresa(){	
		$idusuario = $this->usuarioid();

		$empresaid =$this->empresaid();
		
		$sql = "
			select
				v.idvendedor
				,p.nome
			from vendedor v
			inner join pessoa p on p.pessoaid = v.pessoaid
			where v.idempresa_crm = $empresaid
			order by p.nome
		";
		$vendedores = $this->query($sql);
		
		$vendedorid = -1;
		if(isset($_POST['vendedorid'])){
			$vendedorid = $_POST['vendedorid'];
		}

		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$this->vnd();
		$this->set([
			'vendedores'=>$vendedores
			,'vendedorid'=>$vendedorid
			,'vendedoridimplode'=>$vendedoridimplode
		]);
    }
}
