<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Datasource\ConnectionManager;
use Cake\Event\Event;
/**
 * Perfil Controller
 *
 * @property \App\Model\Table\ParametroTable $Perfil
 */
class ParametroController extends AppController
{
	public function index()
    {
        $parametro = $this->paginate($this->Parametro);

        $this->set(compact('parametro'));
	}
	public function view($id = null)
    {
        $parametro = $this->Parametro->get($id, [
            'contain' => []
        ]);

        $this->set('parametro', $parametro);
    }
	public function paramentowhatsapp($id = null){
		// $compra = $this->getAllTableWhere('compra',['id'=>$id],[]);
		$compra = $this->query("SELECT * FROM compra WHERE id = $id")[0];
		$compra_produto = $this->getAllTableWhere('compra_produto',['idcompra'=>$id, 'ativo'=> '1'],[]);
		$pessoa = $this->query("SELECT * FROM pessoa as p LEFT JOIN telefone as t on t.pessoaid = p.pessoaid 
        WHERE p.pessoaid = $compra->idpessoa")[0];
		$paramentos = $this->getAllTableWhere('parametro',['tipo'=>'whatsapp'],[]);
		$this->set(compact(
			'compra'
		   ,'compra_produto'
		   ,'paramentos'
		   ,'pessoa'
		));
	}

	 public function mensagem(){
		if (isset($_GET['idparametro'])) {
			$idparametro = $_GET['idparametro'];
			$parametro = $this->query("SELECT * FROM parametro WHERE idparametro = $idparametro")[0];
			//$this->d($parametro->valor);
			$this->set(compact('parametro'));
        }
	}

	public function add($goTo = null,$idgoTo = null){
		$tipo = $this->query("SELECT tipo FROM parametro Group by tipo");
		
		if($this->request->is('post')){
			$data = $this->request->getData();
			$parametro = $this->Parametro->newEntity();
			// $this->d($data);
			if($data['tipo'] == "%+%"){
				$data['tipo'] = $data['novotipo'];
			}
			$parametro->chave = $data['chave'];
			$parametro->descricao = $data['descricao'];
			$parametro->valor = $data['valor'];
			$parametro->ativo = $data['ativo'];
			$parametro->tipo = $data['tipo'];
			$parametro->pessoaidcadastro = $this->pessoaid();
			if ($this->Parametro->save($parametro)) {
				$this->Flash->success(__('Parametro cadastrado com sucesso.'));
				if($goTo == null){
					return $this->redirect(['action' => 'index']);
				}else{
					return $this->redirect(['controller' => $goTo,'action' => 'orcamentoview', $idgoTo]);
				}
			}
		}
		$this->set(compact('tipo'));
	}
	public function edit($id = null){
		$tipo = $this->query("SELECT tipo FROM parametro Group by tipo");
		$parametro = $this->Parametro->get($id, [
            'contain' => []
        ]);
		
		if($this->request->is('post')){
			$data = $this->request->getData();
			$parametro = $this->Parametro->patchEntity($parametro, $data);
			if($data['tipo'] == "%+%"){
				$data['tipo'] = $data['novotipo'];
			}
			$parametro->tipo = $data['tipo'];
			$parametro->pessoaidcadastro = $this->pessoaid();
			if ($this->Parametro->save($parametro)) {
				$this->Flash->success(__('Parametro Editado com sucesso.'));
				return $this->redirect(['action' => 'index']);
			}
		}
		$this->set(compact(
			'tipo'
			,'parametro'
		));
	}
	public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $parametro = $this->Parametro->get($id);
        if ($this->Parametro->delete($parametro)) {
            $this->Flash->success(__('The parametro has been deleted.'));
        } else {
            $this->Flash->error(__('The parametro could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

}
