<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
/**
 * Produto Controller
 *
 * @property \App\Model\Table\ProdutoTable $Produto
 *
 * @method \App\Model\Entity\Produto[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class ProdutoCrmController extends AppController
{
    public function apibuscar(){

        $idade = '';
        if(isset($_GET['idade']) && $_GET['idade']){
            $idade = "and '$idade' between idade_min and idade_max";
        }

        $nomecodigo = '';
        if(isset($_GET['nomecodigo']) && $_GET['nomecodigo']){
            $nomecodigo = "and (produtoid = '".$_GET['nomecodigo']."' OR nome like '%".$_GET['nomecodigo']."%' )";
        }

        $operadora = '';
        if(isset($_GET['operadora']) && $_GET['operadora']){
            $operadora = "and operadora = '".$_GET['operadora']."'";
        }

        $tipocontratacao = '';
        if(isset($_GET['tipocontratacao']) && $_GET['tipocontratacao']){
            $tipocontratacao = "and tipocontratacao = '".$_GET['tipocontratacao']."'";
        }

        $tipoacomodacao = '';
        if(isset($_GET['tipoacomodacao']) && $_GET['tipoacomodacao']){
            $tipoacomodacao = "and tipoacomodacao = '".$_GET['tipoacomodacao']."'";
        }

        $abrangencia = '';
        if(isset($_GET['abrangencia']) && $_GET['abrangencia']){
            $abrangencia = "and abrangencia = '".$_GET['abrangencia']."'";
        }

		$sql = "select 
                    p.produtoid
                    ,p.nome
                    ,p.operadora
                    ,p.tipocontratacao
                    ,p.tipoacomodacao
                    ,p.abrangencia
                    ,CONCAT(p.idade_min,' - ',p.idade_max) as faixaetaria
                    ,p.valor
				from produto_crm p
				where 
                    1=1
                    and ativo = 1
                    $idade
                    $nomecodigo
                    $operadora
                    $tipocontratacao
                    $tipoacomodacao
                    $abrangencia
                order by p.operadora, p.nome, p.abrangencia, p.tipoacomodacao,p.tipocontratacao, p.idade_min, valor
				limit 1000";
		$result = $this->query($sql);
		header('Content-type: application/json');
		echo json_encode( $result );
		exit();
	}

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        
        $produto = $this->getAllTableWhere('Produto_crm',[],[]);

        $this->set([
			'produto'=>$produto		
        ]);
        foreach($produto as $produto){
            $grupo = $this->get('grupoproduto','grupoprodutoid',$produto->grupoid);
            $subgrupo = $this->get('subgrupoproduto','subgrupoprodutoid',$produto->subgrupoid);
            $grupo != null ? $produto->grupo = $grupo->nome : $produto->grupo = '-' ;
            $subgrupo != null ? $produto->subgrupo = $subgrupo->nome : $produto->subgrupo = '-' ;
        }
    }

    /**
     * View method
     *
     * @param string|null $id Produto id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $produto_crmTable = TableRegistry::get('produto_crm');
        $produto = $produto_crmTable->get($id, [
            'contain' => []
        ]);
        $grupo = $this->get('grupoproduto','grupoprodutoid',$produto->grupoid);
        $subgrupo = $this->get('subgrupoproduto','subgrupoprodutoid',$produto->subgrupoid);
        $grupo != null ? $produto->grupo = $grupo->nome : $produto->grupo = '-' ;
        $subgrupo != null ? $produto->subgrupo = $subgrupo->nome : $produto->subgrupo = '-' ;

        $this->set('produto', $produto);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $produto_crmTable = TableRegistry::get('produto_crm');
        $produto = $produto_crmTable->newEntity();
        if ($this->request->is('post')) {
            $produto_crmTable = TableRegistry::get('produto_crm');
            $produto = $produto_crmTable->patchEntity($produto, $this->request->getData());
			$produto->pessoaidcadastro = $this->pessoaid();
			$produto->empresaid        = $this->empresaid();
			
			if(isset($_POST['data_inicio']) && $_POST['data_inicio']) {
				$produto->data_inicio = $this->formatDataToDatabase($_POST['data_inicio']);
			}
			
			if(isset($_POST['data_fim']) && $_POST['data_fim']){
				$produto->data_fim = $this->formatDataToDatabase($_POST['data_fim']);
			}
			
			$produto->valor = str_replace('.','',$produto->valor);
			$produto->valor = str_replace(',','.',$produto->valor);
			
            if ($produto_crmTable->save($produto)) {
                $this->Flash->success(__('O produto foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
			
            $this->Flash->error(__('O produto não pode ser solvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('produto'));
    }

    public function addrapido(){
        $produto_crmTable = TableRegistry::get('produto_crm');
        if ($this->request->is('post')) {
            $produto_crmTable = TableRegistry::get('produto_crm');
            $produto = $produto_crmTable->newEntity();
            $produto = $produto_crmTable->patchEntity($produto, $this->request->getData());
            $produto = $produto_crmTable->save($produto);
            if($produto){
                $this->set('val','Produto salvo com sucesso.');
                $this->set('id',$produto->centrocustoid);
                $this->set('nome',$produto->nome);
                $this->set('_serialize',array('val','id','nome'));
                $this->response->statusCode(200);
            }else{
                $this->set('val','Produto não pode ser salvo.');
                $this->set('_serialize',array('val'));
                $this->response->statusCode(500);
            }
        }
    }

    /**
     * Edit method
     *
     * @param string|null $id Produto id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $produto_crmTable = TableRegistry::get('produto_crm');
        $produto = $produto_crmTable->get($id, [
            'contain' => []
        ]);
        $grupo = $this->get('grupoproduto','grupoprodutoid',$produto->grupoid);
        $subgrupo = $this->get('subgrupoproduto','subgrupoprodutoid',$produto->subgrupoid);
        $grupo != null ? $produto->grupo = $grupo->nome : $produto->grupo = '-' ;
        $subgrupo != null ? $produto->subgrupo = $subgrupo->nome : $produto->subgrupo = '-' ;

		$produto->valor = str_replace('.','',$produto->valor);
		$produto->valor = str_replace(',','',$produto->valor);
		
        if ($this->request->is(['patch', 'post', 'put'])) {
            $produto_crmTable = TableRegistry::get('produto_crm');
            $produto = $produto_crmTable->patchEntity($produto, $this->request->getData());
           // $this->d($produto);
			if(isset($_POST['data_inicio']) && $_POST['data_inicio']) {
				$produto->data_inicio = $this->formatDataToDatabase($_POST['data_inicio']);
			}
			
			if(isset($_POST['data_fim']) && $_POST['data_fim']){
				$produto->data_fim = $this->formatDataToDatabase($_POST['data_fim']);
			}
			
			$produto->valor = str_replace('.','',$produto->valor);
			$produto->valor = str_replace(',','.',$produto->valor);
			
            if ($produto_crmTable->save($produto)) {
                $this->Flash->success(__('O produto foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('O produto não pode ser salvo. Por favor, tente mais tarde.'));
        }
		
		if($produto->data_inicio != null){
			$produto->data_inicio = $produto->data_inicio->format('d-m-Y');
		}
		
		if($produto->data_fim != null){
			$produto->data_fim = $produto->data_fim->format('d-m-Y');
		}
        $this->set(compact('produto'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Produto id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $produto_crmTable = TableRegistry::get('produto_crm');
        $produto = $produto_crmTable->get($id);
        if ($produto_crmTable->delete($produto)) {
            $this->Flash->success(__('O produto foi deletado com sucesso.'));
        } else {
            $this->Flash->error(__('O produto não pode ser deletado. Por favor, tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
