<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Datasource\ConnectionManager;
use Cake\Event\Event;
/**
 * Perfil Controller
 *
 * @property \App\Model\Table\PerfilTable $Perfil
 */
class RelatorioController extends AppController
{
	public function index(){

		$empresas = $this->getAllTableWhere('empresa_crm',['ativo'=>1],['nomefantasia'=>'asc']);
		$perfilid = $this->perfilid();
		$this->set([
			'perfilid'=>$perfilid
			,'empresas'=>$empresas
		]);
	}

	public function produtosporvendedor(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$sql = "
			select
				emp.nomefantasia
				,pes.nome as vendedor
				,concat(prod.nome
					,' [',prod.idade_min,'-',prod.idade_max,'] '
					,' ',prod.operadora,' ',prod.administradora,' ',prod.tipocontratacao,' ',prod.tipoacomodacao
					,' ',prod.abrangencia,' ',COALESCE(prod.grupo,''),' ',COALESCE(prod.subgrupo,'')) as produto
				,sum(pi.quantidade) as quantidade
				,sum(pi.valor) as valor
			from contato con
			inner join produtointeresse pi on pi.contatoid = con.contatoid
			inner join produto_crm prod on prod.produtoid = pi.produtoid
			inner join cliente cli on cli.clienteid = con.clienteid
			inner join vendedor ven on ven.idvendedor = cli.vendedorid
			inner join pessoa pes on pes.pessoaid = ven.pessoaid
			inner join empresa_crm emp on emp.empresaid = cli.empresaid
			where
				('-1' = '$vendedoridimplode' or cli.vendedorid in ($vendedoridimplode))
				and ('-1' = '$empresaidimplode' or cli.empresaid in ($empresaidimplode))
				and cast(cli.data_criacao as date) between '$datainicio' and '$datafim'
			group by
				emp.nomefantasia
				,pes.nome
				,3
			order by 4 desc,pes.nome
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'PRD.1 | Produtos por vendedor'
			,'colunas'=>['Empresa','Vendedor','Produto','Quantidade','R$']
			,'format'=>[null,null,null,'toNumber','toFloat']
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[4,5]
		]);
		$this->render('leadsporempresacidade');
	}

	public function produtospororigem(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$sql = "
			SELECT
				emp.nomefantasia
				,cli.origemlead
				,concat(prod.nome
					,' [',prod.idade_min,'-',prod.idade_max,'] '
					,' ',prod.operadora,' ',prod.administradora,' ',prod.tipocontratacao,' ',prod.tipoacomodacao
					,' ',prod.abrangencia,' ',COALESCE(prod.grupo,''),' ',COALESCE(prod.subgrupo,'')) as produto
				,sum(pi.quantidade) as quantidade
				,sum(pi.valor) as valor
			from contato con
			inner join cliente cli on cli.clienteid = con.clienteid
			inner join empresa_crm emp on emp.empresaid = cli.empresaid
			inner join produtointeresse pi on pi.contatoid = con.contatoid
			inner join produto_crm prod on prod.produtoid = pi.produtoid
			where
				('-1' = '$vendedoridimplode' or cli.vendedorid in ($vendedoridimplode))
				and ('-1' = '$empresaidimplode' or cli.empresaid in ($empresaidimplode))
				and cast(cli.data_criacao as date) between '$datainicio' and '$datafim'
			group by
				emp.nomefantasia
				,cli.origemlead
				,3
			order by 4 desc,origemlead
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'PRD.2 | Produtos por origem'
			,'colunas'=>['Empresa','Origem','Produto','Quantidade','R$']
			,'format'=>[null,null,null,'toNumber','toFloat']
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[4,5]
		]);
		$this->render('leadsporempresacidade');

	}

	public function origemporcidade(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$sql = "SELECT
				emp.nomefantasia
				,cli.origemlead
				,UPPER(ende.cidade) AS cidade
				,UPPER(ende.estado) AS estado
				,COUNT(DISTINCT cli.clienteid) AS quantidade
			FROM cliente cli
			INNER JOIN vendedor ven ON ven.idvendedor = cli.vendedorid
			INNER JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
			LEFT JOIN (
				SELECT
					p1.pessoaid
					,COALESCE(NULLIF(CONCAT(e.cidade,'/',e.estado),'/'),NULLIF(CONCAT(p1.cidade,'/',p1.estado),'/'),'(SEM CIDADE)') AS cidade
					,COALESCE(NULLIF(TRIM(e.estado),''),NULLIF(TRIM(p1.estado),''),'(SEM ESTADO)') AS estado
				FROM pessoa p1
				LEFT JOIN endereco e ON e.pessoaid = p1.pessoaid AND e.enderecoid = (
					SELECT MIN(e1.enderecoid) FROM endereco e1 WHERE e1.pessoaid = e.pessoaid
				)
			) ende ON ende.pessoaid = cli.pessoaid
			WHERE
				('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
				AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
				AND CAST(cli.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
			GROUP BY
				emp.nomefantasia
				,cli.origemlead
				,cidade
				,estado
			ORDER BY 5 DESC,cli.origemlead
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'CLI.4 | Origem de Leads por cidade'
			,'colunas'=>['Empresa','Origem','Cidade','Estado','Qtd']
			,'format'=>[null,null,null,null,'toNumber']
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[5]
		]);
		$this->render('leadsporempresacidade');

	}

	public function leadsconvertidas(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$sql = "SELECT cli.clienteid AS clienteid_, p.nome, p.email, cli.origemlead,
		 			COALESCE(con.data_fechamento,con.data_contato) AS data_fechamento
				FROM contato con
				INNER JOIN (SELECT contatoidpai, MAX(contatoid) AS contatoid FROM contato GROUP BY contatoidpai) max_con ON (max_con.contatoid = con.contatoid)
				INNER JOIN cliente cli ON (cli.clienteid = con.clienteid)
				INNER JOIN pessoa p ON (p.pessoaid = cli.pessoaid)
				WHERE
					('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
					AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
					AND CAST(cli.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
					AND con.statuscontato = 'Negócio Fechado'
				ORDER BY cli.clienteid ASC
		";
		$arr = $this->queryarr($sql);

		$this->set([
			'nomeRelatorio'=>'CLI.5 | Leads Convertidas'
			,'colunas'=>['Nome','Email','Origem','Data Fechamento']
			,'format'=>[null,null,null,'formatDataHora',null,null]
			,'idregistro'=>'clienteid_'
			,'linkRegistro'=>$this->request->base.'/flystart/cliente/view/'
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[]
		]);
		$this->render('leadsporempresacidade');

	}

	public function produtosporcidade(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$sql = "
			select
				emp.nomefantasia
				,UPPER(ende.cidade) as cidade
				,UPPER(ende.estado) as estado
				,concat(prod.nome
					,' [',prod.idade_min,'-',prod.idade_max,'] '
					,' ',prod.operadora,' ',prod.administradora,' ',prod.tipocontratacao,' ',prod.tipoacomodacao
					,' ',prod.abrangencia,' ',COALESCE(prod.grupo,''),' ',COALESCE(prod.subgrupo,'')) as produto
				,sum(pi.quantidade) as quantidade
				,sum(pi.valor) as valor
			from contato con
			inner join produtointeresse pi on pi.contatoid = con.contatoid
			inner join produto_crm prod on prod.produtoid = pi.produtoid
			inner join cliente cli on cli.clienteid = con.clienteid
			inner join vendedor ven on ven.idvendedor = cli.vendedorid
			inner join pessoa pes on pes.pessoaid = ven.pessoaid
			inner join empresa_crm emp on emp.empresaid = cli.empresaid
			left join (
				select
					p1.pessoaid
					,COALESCE(NULLIF(concat(e.cidade,'/',e.estado),'/'),NULLIF(concat(p1.cidade,'/',p1.estado),'/'),'(SEM CIDADE)') as cidade
					,COALESCE(NULLIF(trim(e.estado),''),NULLIF(trim(p1.estado),''),'(SEM ESTADO)') as estado
				from pessoa p1
				left join endereco e on e.pessoaid = p1.pessoaid and e.enderecoid = (
					select min(e1.enderecoid) from endereco e1 where e1.pessoaid = e.pessoaid
				)
			) end on ende.pessoaid = cli.pessoaid
			where
				('-1' = '$vendedoridimplode' or cli.vendedorid in ($vendedoridimplode))
				and ('-1' = '$empresaidimplode' or cli.empresaid in ($empresaidimplode))
				and cast(cli.data_criacao as date) between '$datainicio' and '$datafim'
			group by
				emp.nomefantasia
				,cidade
				,estado
				,produto
			order by 5 desc,pes.nome
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'PRD.3 | Produtos por cidade'
			,'colunas'=>['Empresa','Cidade','Estado','Produto','Quantidade','R$']
			,'format'=>[null,null,null,null,'toNumber','toFloat']
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[5,6]
		]);
		$this->render('leadsporempresacidade');

	}


	public function vendedortempoquantitativo(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();

		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}

		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$sql = "SELECT
					con.contatoid AS contatoid_
					,emp.nomefantasia AS empresa
					,UPPER(COALESCE(pes.nome,'(SEM VENDEDOR)')) AS vendedor
					,cli.origemlead AS origem
					,UPPER(LEFT((SELECT p1.nome FROM pessoa p1 WHERE p1.pessoaid = cli.pessoaid), 20)) AS cliente
					,cli.data_criacao AS data_criacaoA
					,con.data_criacao AS data_contatoB
					,DATEDIFF(cli.data_criacao, con.data_criacao) AS diferencaBA
					,con.data_criacao AS data_ultimocontatoC
					,DATEDIFF(cli.data_criacao, con.data_criacao) AS diferencaCA
					,DATEDIFF(con.data_criacao, NOW()) AS semcontato
					,con.statuscontato
				FROM contato con
				INNER JOIN cliente cli ON cli.clienteid = con.clienteid
				INNER JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
				LEFT JOIN vendedor ven ON ven.idvendedor = cli.vendedorid
				LEFT JOIN pessoa pes ON pes.pessoaid = ven.pessoaid
				WHERE
					con.pessoaidcadastro = ven.pessoaid
					AND ('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
					AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
					AND (con.contatoid, con.contatoidpai) IN (
										SELECT
										MAX(con.contatoid) AS contatoid
										,con.contatoidpai
										FROM contato con
										WHERE
											CAST(con.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
										GROUP BY contatoidpai
									)

				ORDER BY vendedor, diferencaCA, origem
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'VEN.1 | Tempo de atendimento por vendedor (quantitativo)'
			,'colunas'=>['Empresa','Vendedor','Origem','Cliente' ,'Data criação lead(A)','Data 1o contato(B)','Diferença B-A','Data Último Con.(C)', 'Diferença C-A','Tempo sem contato','Status do con.']
			,'format'=>[      null,"truncate",null    ,"truncate",'formatDataHora'      ,'formatDataHora'    ,null           ,'formatDataHora'     ,null            ,null               ,null            ]
			,'idregistro'=>'contatoid_'
			,'linkRegistro'=>$this->request->base.'/flystart/contato/view/'
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[]
		]);
		$this->render('leadsporempresacidade');
	}

	public function vendedortempoqualitativo(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}


		$sql = "SELECT res.empresa, res.vendedor, SUM(res.qtd) AS qtd, TIME_FORMAT(SEC_TO_TIME(SUM(res.media)/SUM(res.qtd)),'%H:%i') AS media FROM (
				SELECT
					emp.nomefantasia AS empresa
					,COALESCE(pes.nome, '(SEM VENDEDOR)') AS vendedor
					,count(DISTINCT con.contatoid) AS qtd
					,TIME_TO_SEC(TIMEDIFF(con.data_criacao, cli.data_criacao)) AS media
				FROM contato con
				INNER JOIN cliente cli ON cli.clienteid = con.clienteid
				INNER JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
				INNER JOIN vendedor ven ON ven.idvendedor = cli.vendedorid
				INNER JOIN pessoa pes ON pes.pessoaid = ven.pessoaid
				WHERE
					con.pessoaidcadastro = ven.pessoaid
					AND ('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
					AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
					AND CAST(cli.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
					AND (con.contatoid, con.contatoidpai) IN (
									SELECT
									MAX(con.contatoid) AS contatoid
									,con.contatoidpai
									FROM contato con
									WHERE
										CAST(con.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
									GROUP BY contatoidpai
								)

				GROUP BY empresa, vendedor
			) res
			GROUP BY res.empresa, res.vendedor
			ORDER BY 4
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'VEN.2 | Tempo de atendimento por vendedor (qualitativo)'
			,'colunas'=>['Empresa','Vendedor','Qtd leads','Média atendimento (H:m)']
			,'format'=>[null,null,'toNumber',null]
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[3]
		]);
		$this->render('leadsporempresacidade');
	}

	public function leadsporempresacidade(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}


		$sql = "SELECT
					emp.nomefantasia
					,UPPER(ende.cidade) AS cidade
					,COALESCE((SELECT estado FROM endereco e WHERE e.pessoaid = pes.pessoaid LIMIT 1),pes.estado) AS estado
					,count(1) AS total
				FROM cliente cli
				INNER JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
				INNER JOIN pessoa pes ON pes.pessoaid = cli.pessoaid
				LEFT JOIN (
					SELECT
						p1.pessoaid
						,COALESCE(NULLIF(concat(e.cidade,'/',e.estado),'/'),NULLIF(concat(p1.cidade,'/',p1.estado),'/'),'(SEM CIDADE)') AS cidade
					FROM pessoa p1
					LEFT JOIN endereco e ON e.pessoaid = p1.pessoaid AND e.enderecoid = (
						SELECT min(e1.enderecoid) FROM endereco e1 WHERE e1.pessoaid = e.pessoaid
					)
				) ende ON ende.pessoaid = cli.pessoaid
				WHERE
					('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
					AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
					AND CAST(cli.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
				GROUP BY
					emp.nomefantasia
					,2
				ORDER BY 4 DESC,2,3
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'CLI.2 | Leads por cidade e estado'
			,'colunas'=>['Empresa','Cidade','Estado','Leads']
			,'format'=>[null,null,null,'toNumber']
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[4]
		]);
	}

	public function leadsporempresavendedorcidade(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}


		$sql = "SELECT
					emp.nomefantasia
					,(SELECT p3.nome FROM pessoa p3 WHERE p3.pessoaid = ven.pessoaid LIMIT 1) AS vendedor
					,UPPER(ende.cidade) AS cidade
					,COALESCE((SELECT estado FROM endereco e WHERE e.pessoaid = pes.pessoaid LIMIT 1), pes.estado) AS estado
					,COUNT(1) AS total
				FROM cliente cli
				INNER JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
				LEFT JOIN pessoa pes ON pes.pessoaid = cli.pessoaid
				LEFT JOIN vendedor ven ON ven.idvendedor = cli.vendedorid
				LEFT JOIN (
					SELECT
						p1.pessoaid
						,COALESCE(NULLIF(CONCAT(e.cidade,'/',e.estado),'/'),NULLIF(CONCAT(p1.cidade,'/',p1.estado),'/'),'(SEM CIDADE)') AS cidade
					FROM pessoa p1
					LEFT JOIN endereco e ON e.pessoaid = p1.pessoaid AND e.enderecoid = (
						SELECT MIN(e1.enderecoid) FROM endereco e1 WHERE e1.pessoaid = e.pessoaid
					)
				) ende ON ende.pessoaid = cli.pessoaid
				WHERE
					('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
					AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
					AND CAST(cli.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
				GROUP BY
					emp.nomefantasia
					,2
					,3
				ORDER BY 5 DESC,3,4
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'CLI.3 | Leads por vendedor e cidade'
			,'colunas'=>['Empresa','Vendedor','Cidade','Estado','Leads']
			,'format'=>[null,null,null,null,'toNumber']
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>[5]
		]);

		$this->render('leadsporempresacidade');
	}

	public function leadsporempresavendedorcidadestatus(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$statuscontatos = $this->getAllTableWhere('statuscontato',[],['ordem'=>'asc'])->toArray();

		$sqlstatuscontato = "";
		$counter = 0;
		$colunas = ['Empresa','Vendedor','Cidade'];
		$format  = [null,null,null];
		$auxsqlsum = "";
		$colunastotal = [];
		foreach($statuscontatos as $item){
			$counter++;
			$sqlstatuscontato = $sqlstatuscontato.",SUM(case when con.statuscontato = '".$item->nome."' THEN 1 ELSE 0 END) AS col$counter";
			$auxsqlsum = $auxsqlsum.",SUM(col$counter) AS col$counter, (SUM(col$counter)/SUM(total_))*100 AS perccol$counter";
			array_push($colunas,$item->nome);
			array_push($colunas,'%');
			array_push($format,'toNumber');
			array_push($format,'toNumber');
			array_push($colunastotal,(count($colunas)-1));
		}
		array_push($colunastotal,(count($colunas)+1));
		array_push($colunas,'Total');
		array_push($format,'toNumber');
		$sql = "SELECT nomefantasia, vendedor, cidade $auxsqlsum, SUM(total_) AS total FROM(

				SELECT
					emp.nomefantasia
					,pes.nome AS vendedor
					,UPPER(ende.cidade) AS cidade
					,COUNT(DISTINCT con.contatoid) AS total_
					$sqlstatuscontato
				FROM contato con
				INNER JOIN cliente cli ON cli.clienteid = con.clienteid
				INNER JOIN vendedor ven ON ven.idvendedor = cli.vendedorid
				INNER JOIN pessoa pes ON pes.pessoaid = ven.pessoaid
				INNER JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
				LEFT JOIN (
					SELECT
						p1.pessoaid
						,COALESCE(NULLIF(CONCAT(e.cidade, '/', e.estado), '/'), NULLIF(CONCAT(p1.cidade, '/', p1.estado), '/'), '(SEM CIDADE)') AS cidade
					FROM pessoa p1
					LEFT JOIN endereco e ON e.pessoaid = p1.pessoaid AND e.enderecoid = (
						SELECT MIN(e1.enderecoid) FROM endereco e1 WHERE e1.pessoaid = e.pessoaid
					)
				) ende ON ende.pessoaid = cli.pessoaid
				WHERE
					con.statuscontato IS NOT NULL
					AND con.statuscontato <> trim('')
					AND ('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
					AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
					AND CAST(con.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
				GROUP BY emp.nomefantasia, pes.nome, cidade

			) AS resultado
			GROUP BY nomefantasia, vendedor, cidade
			ORDER BY total_ DESC, vendedor
		";

		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'CON.3 | Contatos por vendedor, cidade e status'
			,'colunas'=>$colunas
			,'format'=>$format
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>$colunastotal
		]);

		$this->render('leadsporempresacidade');
	}

	public function leadspororigem(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();

		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			$empresaidimplode = $_GET['empresa'];
		}

		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$colunastotal = [4];
		$sql = "SELECT
					emp.nomefantasia
					,pes.nome as vendedor
					,cli.origemlead
					,count(DISTINCT cli.clienteid) AS total
				FROM cliente cli
				LEFT JOIN vendedor ven ON ven.idvendedor = cli.vendedorid
				LEFT JOIN pessoa pes ON pes.pessoaid = ven.pessoaid
				LEFT JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
				WHERE
					('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
					AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
					AND CAST(cli.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
				GROUP BY
					emp.nomefantasia
					,pes.nome
					,cli.origemlead
				ORDER BY emp.nomefantasia,pes.nome,total DESC
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'CLI.1 | Leads por vendedor e origem'
			,'colunas'=>['Empresa','Vendedor','Origem','Leads']
			,'format'=>[null,null,null,'toNumber']
			,'idregistro'=>null
			,'linkRegistro'=>null
			,'arr'=>$arr
			,'totalizadores'=>[]//$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>$colunastotal
		]);
	}

	public function vendedorstatus(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();


		//empresa
		$empresaidimplode = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa'])>0){
			//$this->d($_GET['empresa']);
			$empresaidimplode = $_GET['empresa'];
		}


		//vendedor
		$vendedorid = -1;
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}
		$vendedoridimplode = $vendedorid;
		if(is_array($vendedorid)){
			$vendedoridimplode = implode(',',$vendedorid);
		}

		$statuscontatos = $this->getAllTableWhere('statuscontato',[],['ordem'=>'ASC'])->toArray();

		$sqlstatuscontato = "";
		$counter = 0;
		$colunas = ['Empresa','Vendedor'];
		$format  = [null,null];
		$auxsqlsum = "";
		$colunastotal = [];
		foreach($statuscontatos as $item){
			$counter++;
			$sqlstatuscontato = $sqlstatuscontato.",SUM(case WHEN con.statuscontato = '".$item->nome."' THEN 1 ELSE 0 END) AS col$counter";
			$auxsqlsum = $auxsqlsum.",SUM(col$counter) AS col$counter, (SUM(col$counter)/SUM(total_))*100 AS perccol$counter";
			array_push($colunas,$item->nome);
			array_push($colunas,'%');
			array_push($format,'toNumber');
			array_push($format,'toNumber');
			array_push($colunastotal,(count($colunas)-1));
		}
		array_push($colunastotal,(count($colunas)+1));
		array_push($colunas,'Total');
		array_push($format,'toNumber');
		$sql = "SELECT UPPER(nomefantasia), UPPER(vendedor) $auxsqlsum, SUM(total_) AS total FROM(
				SELECT
					emp.nomefantasia
					,pes.nome AS vendedor
					,COUNT(DISTINCT con.contatoid) AS total_
					$sqlstatuscontato
				FROM contato con
				INNER JOIN cliente cli ON cli.clienteid = con.clienteid
				INNER JOIN vendedor ven ON ven.idvendedor = cli.vendedorid
				INNER JOIN pessoa pes ON pes.pessoaid = ven.pessoaid
				INNER JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
				WHERE
					con.statuscontato IS NOT NULL
					AND con.statuscontato <> trim('')
					AND ('-1' = '$vendedoridimplode' OR cli.vendedorid IN ($vendedoridimplode))
					AND ('-1' = '$empresaidimplode' OR cli.empresaid IN ($empresaidimplode))
					AND CAST(con.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
				GROUP BY emp.nomefantasia,pes.nome


			) AS resultado
			GROUP BY nomefantasia,vendedor
			ORDER BY nomefantasia,vendedor
		";
		$arr = $this->query($sql);

		$this->set([
			'nomeRelatorio'=>'CON.2 | Contatos por vendedor'
			,'colunas'=>$colunas
			,'format'=>$format
			,'idregistro'=>null
			,'linkRegistro'=>$this->request->getAttribute('base').'/flystart/contato/view/'
			,'arr'=>$arr
			,'totalizadores'=>[]
			,'periodo'=>$periodo
			,'colunastotal'=>$colunastotal
		]);
	}

	public function contatoobservacao(){
		$periodo    = $_GET['periodo'];
		$datainicio = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[0]);
		$datafim    = $this->formatDataToDatabase(explode(' - ',$_GET['periodo'])[1]);
		$perfilid   = $this->perfilid();

		//empresa
		$empresa = $this->empresaid();
		if(isset($_GET['empresa']) && strlen($_GET['empresa']) > 0){
			$empresa = $_GET['empresa'];
		}

		//vendedor
		$vendedorid = "-1";
		if(in_array($perfilid,[5])){
			$vendedorid = $this->vendedorid();
		}

		$colunastotal = [];
		$sql = "SELECT
				con.contatoid AS contatoid_
				,emp.nomefantasia
				,(
					SELECT
						pes.nome
					FROM vendedor ven
					INNER JOIN pessoa pes ON pes.pessoaid = ven.pessoaid
					WHERE ven.idvendedor = cli.vendedorid
				) AS vendedor
				,CONCAT(p.nome,' (',cli.clienteid,')') AS nome
				,p.email
				,(SELECT CONCAT(COALESCE(ddd,''),' ',numero) FROM telefone t WHERE t.pessoaid = p.pessoaid LIMIT 1) AS telefone
				,CONCAT(p.cidade ,' ',p.estado)
				,con.observacao
				,con.laudo
				,con.grauinteresse
				,con.statuscontato
				,con.data_criacao AS data_criacao
			FROM contato con
			INNER JOIN cliente cli ON cli.clienteid = con.clienteid
			INNER JOIN pessoa p ON p.pessoaid = cli.pessoaid
			INNER JOIN empresa_crm emp ON emp.empresaid = cli.empresaid
			LEFT JOIN vendedor v ON v.idvendedor = cli.vendedorid
			WHERE
				con.empresaid IN ($empresa)
				AND con.statuscontato <> trim('')
				AND CAST(con.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim'
				AND (-1 = $vendedorid OR cli.vendedorid = $vendedorid )
			ORDER BY
				con.data_criacao DESC
		";

		$arr = $this->query($sql);

		$totalizador = count($arr);
		$totalizadores = [
							[
								'label'=>'Total'
								,'valor'=>$totalizador
								,'format'=>'toNumber'
							]
						];
		//fim totalizadores======================================================

		$this->set([
			'nomeRelatorio'=>'CON.1 | Contato - Observações e Laudo'
			,'colunas'=>['Empresa','Vendedor','Cliente' ,'Email','Telefone','Cidade','Observação','Laudo','Grau Interesse','Status Contato','Data']
			,'format'=>["truncate","truncate" ,null,null,null,null,'strip_tags',null   ,null            ,null            ,'formatDataHora']
			,'idregistro'=>'contatoid_'
			,'linkRegistro'=>$this->request->base.'/flystart/contato/view/'
			,'arr'=>$arr
			,'totalizadores'=>$totalizadores
			,'periodo'=>$periodo
			,'colunastotal'=>$colunastotal
		]);
	}

	private function array_to_csv_download($array) {
		$filename = "export.csv";
		$delimiter=";";
		header('Content-Type: application/csv');
		header('Content-Disposition: attachment; filename="'.$filename.'";');

		$f = fopen('php://output', 'w');

		foreach ($array as $line) {
			fputcsv($f, $line, $delimiter);
		}
	}

}
