<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
use \DateTime;

class RelatoriosfinanceiroController extends AppController
{
    public function finrecebido(){
        $periodo = $_GET['periodo'];
        $periodo = $this->getPeriodo('periodo');

        $nomerelatorio = 'Recebido em (data pagamento)';

        $sqlconta = 'SELECT *, (c.totalliquido - SUM(COALESCE(bx.valorpago,0))) AS baixado, SUM(COALESCE(bx.valorpago,0)) AS pago, p.nome FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido, data_criacao FROM conta) c 
        INNER JOIN contabaixa bx on bx.contaid = c.contaid
        LEFT JOIN pessoa p ON (p.pessoaid = c.pessoaid)
        WHERE c.tipocontaid =1  AND CAST(bx.data_baixa AS DATE) BETWEEN \''.$periodo[0] .'\' AND \'' .$periodo[1] .'\' 
        GROUP BY c.contaid';

        $contas = $this->query($sqlconta);
          
        $this->set(compact('contas','nomerelatorio','periodo'));

        $this->render('relatorio');

    }

    public function finreceberemissao(){
        $periodo = $_GET['periodo'];
        $periodo = $this->getPeriodo('periodo');

        $nomerelatorio = 'Contas a Receber (data emissão)';

        $sqlconta = 'SELECT c.*, (c.totalliquido - SUM(COALESCE(bx.valorpago,0))) AS baixado, SUM(COALESCE(bx.valorpago,0)) AS pago, p.nome FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido, data_criacao FROM conta) c 
        LEFT JOIN contabaixa AS bx ON bx.contaid = c.contaid
        LEFT JOIN pessoa p ON (p.pessoaid = c.pessoaid)
        WHERE c.tipocontaid =1 AND c.status <> \'PAGO\'  AND CAST(c.data_criacao AS DATE) BETWEEN \''.$periodo[0] .'\' AND \'' .$periodo[1] .'\'
        GROUP BY c.contaid';

        $contas = $this->query($sqlconta);
        $this->set(compact('contas','nomerelatorio','periodo'));

        $this->render('relatorio');
    }

    public function finrecebervencimento(){
        $periodo = $_GET['periodo'];
        $periodo = $this->getPeriodo('periodo');

        $nomerelatorio = 'Contas a Receber (data vencimento)';

        $sqlconta = 'SELECT c.*, (c.totalliquido - SUM(COALESCE(bx.valorpago,0))) AS baixado, SUM(COALESCE(bx.valorpago,0)) AS pago, p.nome FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido, data_criacao FROM conta) c 
        LEFT JOIN contabaixa as bx on bx.contaid = c.contaid
        LEFT JOIN pessoa p ON (p.pessoaid = c.pessoaid)
        WHERE c.tipocontaid =1  AND c.status <> \'PAGO\' AND CAST(c.data_vencimento AS DATE) BETWEEN \''.$periodo[0] .'\' AND \'' .$periodo[1] .'\'
        GROUP BY c.contaid';

        $contas = $this->query($sqlconta);
        
        $this->set(compact('contas','nomerelatorio','periodo'));

        $this->render('relatorio');
    }

    public function finrecebervencido(){
        $periodo = $_GET['periodo'];
        $periodo = $this->getPeriodo('periodo');

        $nomerelatorio = 'Contas a Receber Vencidas em (data vencimento) ';

        $datainicio = $periodo[0];
        $datafim = $periodo[1];
        $hoje = Date('Y-m-d');
        $contas = $this->query(
            "SELECT c.contaid, c.pessoaid, c.data_vencimento, c.totalliquido, c.status, (c.totalliquido - SUM(COALESCE(bx.valorpago,0))) AS baixado, SUM(COALESCE(bx.valorpago,0)) AS pago, p.nome FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido, data_criacao FROM conta) c 
                LEFT JOIN contabaixa bx ON (bx.contaid = c.contaid) 
                LEFT JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                WHERE CAST(c.data_vencimento AS DATE) BETWEEN '$datainicio' AND '$datafim' AND c.data_vencimento < '$hoje'
                    AND c.tipocontaid = 1 AND c.status <> 'PAGO'
                GROUP BY c.contaid"
        );
        $this->set(compact('contas','nomerelatorio','periodo'));
        $this->render('relatorio');
    }

    public function finpago() {
        $periodo = $this->getPeriodo('periodo');

        $nomerelatorio = 'Pago em (data pagamento)';

        $datainicio = $periodo[0];
        $datafim = $periodo[1];
        $contas = $this->query(
            "SELECT c.contaid, c.pessoaid, c.data_vencimento, c.totalliquido, c.status, (c.totalliquido - SUM(COALESCE(bx.valorpago,0))) AS baixado, SUM(COALESCE(bx.valorpago,0)) AS pago, p.nome FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido, data_criacao FROM conta) c 
                INNER JOIN contabaixa bx ON (bx.contaid = c.contaid) 
                LEFT JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                WHERE bx.data_baixa BETWEEN '$datainicio' AND '$datafim' 
                    AND c.tipocontaid = 2
                GROUP BY c.contaid"
        );
        $this->set(compact('contas','nomerelatorio','periodo'));
        $this->render('relatorio');
    }

    public function finpagarvencimento() {
        $periodo = $this->getPeriodo('periodo');

        $nomerelatorio = 'Contas a pagar (data vencimento)';

        $datainicio = $periodo[0];
        $datafim = $periodo[1];
        $contas = $this->query(
            "SELECT c.contaid, c.pessoaid, c.data_vencimento, c.totalliquido, c.status, (c.totalliquido - SUM(COALESCE(bx.valorpago,0))) AS baixado, SUM(COALESCE(bx.valorpago,0)) AS pago, p.nome FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido, data_criacao FROM conta) c 
                LEFT JOIN contabaixa bx ON (bx.contaid = c.contaid) 
                LEFT JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                WHERE c.data_vencimento BETWEEN '$datainicio' AND '$datafim' 
                    AND c.tipocontaid = 2 AND c.status <> 'PAGO'
                GROUP BY c.contaid"
        );
        $this->set(compact('contas','nomerelatorio','periodo'));
        $this->render('relatorio');
    }

    public function finpagaremissao() {
        $periodo = $this->getPeriodo('periodo');

        $nomerelatorio = 'Contas a Pagar (data emissão)';

        $datainicio = $periodo[0];
        $datafim = $periodo[1];
        $contas = $this->query(
            "SELECT c.contaid, c.pessoaid, c.data_vencimento, c.totalliquido, c.status, (c.totalliquido - SUM(COALESCE(bx.valorpago,0))) AS baixado, SUM(COALESCE(bx.valorpago,0)) AS pago, p.nome FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido, data_criacao FROM conta) c 
                LEFT JOIN contabaixa bx ON (bx.contaid = c.contaid) 
                LEFT JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                WHERE CAST(c.data_criacao AS DATE) BETWEEN '$datainicio' AND '$datafim' 
                    AND c.tipocontaid = 2 AND c.status <> 'PAGO'
                GROUP BY c.contaid"
        );
        $this->set(compact('contas','nomerelatorio','periodo'));
        $this->render('relatorio');
    }

    public function finpagarvencido() {
        $periodo = $this->getPeriodo('periodo');

        $nomerelatorio = 'Contas a Pagar Vencido em (data vencimento)';

        $datainicio = $periodo[0];
        $datafim = $periodo[1];
        $hoje = Date('Y-m-d');
        $contas = $this->query(
            "SELECT c.contaid, c.pessoaid, c.data_vencimento, c.totalliquido, c.status, (c.totalliquido - SUM(COALESCE(bx.valorpago,0))) AS baixado, SUM(COALESCE(bx.valorpago,0)) AS pago, p.nome FROM (SELECT contaid, data_vencimento, pessoaid, status, tipocontaid, descricao, empresaid, CASE WHEN parcela = 0 THEN totalliquido ELSE valorparcela END AS totalliquido, data_criacao FROM conta) c 
                LEFT JOIN contabaixa bx ON (bx.contaid = c.contaid) 
                LEFT JOIN pessoa p ON (p.pessoaid = c.pessoaid)
                WHERE CAST(c.data_vencimento AS DATE) BETWEEN '$datainicio' AND '$datafim' AND c.data_vencimento < '$hoje'
                    AND c.tipocontaid = 2 AND c.status <> 'PAGO'
                GROUP BY c.contaid"
        );
        $this->set(compact('contas','nomerelatorio','periodo'));
        $this->render('relatorio');
    }
    
    
}