<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;

/**
 * Subgrupoproduto Controller
 *
 * @property \App\Model\Table\SubgrupoprodutoTable $Subgrupoproduto
 *
 * @method \App\Model\Entity\Subgrupoproduto[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class SubgrupoprodutoController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $subgrupoprodutos = $this->Subgrupoproduto->find('all');

        $this->set([
			'subgrupoprodutos'=>$subgrupoprodutos		
		]);
    }

    /**
     * View method
     *
     * @param string|null $id Subgrupoproduto id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $subgrupoproduto = $this->Subgrupoproduto->get($id, [
            'contain' => []
        ]);

        $this->set('subgrupoproduto', $subgrupoproduto);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $subgrupoproduto = $this->Subgrupoproduto->newEntity();
        if ($this->request->is('post')) {
            $subgrupoproduto = $this->Subgrupoproduto->patchEntity($subgrupoproduto, $this->request->getData());
			$subgrupoproduto->pessoaidcadastro = $this->pessoaid();
			$subgrupoproduto->empresaid        = $this->empresaid();
            if ($this->Subgrupoproduto->save($subgrupoproduto)) {
                $this->Flash->success(__('Subgrupo Produto foi salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Subgrupo Produto não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('subgrupoproduto'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Subgrupoproduto id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $subgrupoproduto = $this->Subgrupoproduto->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $subgrupoproduto = $this->Subgrupoproduto->patchEntity($subgrupoproduto, $this->request->getData());
            if ($this->Subgrupoproduto->save($subgrupoproduto)) {
                $this->Flash->success(__('Subgrupo Produto foi editado com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Subgrupo Produto não pode ser editado. Por favor tente mais tarde.'));
        }
        $this->set(compact('subgrupoproduto'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Subgrupoproduto id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $subgrupoproduto = $this->Subgrupoproduto->get($id);
        if ($this->Subgrupoproduto->delete($subgrupoproduto)) {
            $this->Flash->success(__('Subgrupo Produto foi deletado com sucesso.'));
        } else {
            $this->Flash->error(__('Subgrupo Produto não pode ser deletado. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
