<?php
namespace App\Controller\Flystart;
use CAKE\ORM\TableRegistry;
use App\Controller\AppController;

/**
 * Telefone Controller
 *
 * @property \App\Model\Table\TelefoneTable $Telefone
 *
 * @method \App\Model\Entity\Telefone[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TelefoneController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $telefone = $this->paginate($this->Telefone);

        $this->set(compact('telefone'));
    }

    /**
     * View method
     *
     * @param string|null $id Telefone id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $telefone = $this->Telefone->get($id, [
            'contain' => []
        ]);

        $this->set('telefone', $telefone);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add($id = null)
    {
        $telefone = $this->Telefone->newEntity();
		$pessoa  = $this->get('pessoa','pessoaid',$id);
		$cliente = $this->get('cliente','pessoaid',$id);
		$usuario = $this->get('usuario_crm','pessoaid',$id);
        $numeroTelefone = $this->query("SELECT * FROM telefone WHERE pessoaid = $id");
        //$this->d($numeroTelefone[0]->numero);
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $telefoneTable = TableRegistry::get('telefone');
            $telefones = $this->getAllTableWhere('telefone', ['pessoaid'=>$id],[]);
            foreach ($telefones as $telefone) {
                $telefoneTable->delete($telefone);
            }
            if(isset($data['numero1']) && $data['numero1']){
				$this->insert('telefone',[
					'pessoaid'	     	=>$id
					,'codigopais'	 	=>$data['codigopais1']
					,'ddd'				=>$data['ddd1']
					,'numero'			=>$data['numero1']
					,'tipotelefone'	    =>$data['tipotelefone1']
					,'empresaid'	 	=>$this->empresaid()
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(isset($data['numero2']) && $data['numero2']){
				$this->insert('telefone',[
					'pessoaid'	     	=>$id
					,'codigopais'	 	=>$data['codigopais2']
					,'ddd'				=>$data['ddd2']
					,'numero'			=>$data['numero2']
					,'tipotelefone'  	=>$data['tipotelefone2']
					,'empresaid'	 	=>$this->empresaid()
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			if(isset($data['numero3']) && $data['numero3']){
				$this->insert('telefone',[
					'pessoaid'	     	=>$id
					,'codigopais'	 	=>$data['codigopais3']
					,'ddd'				=>$data['ddd3']
					,'numero'			=>$data['numero3']
					,'tipotelefone'  	=>$data['tipotelefone3']
					,'empresaid'	 	=>$this->empresaid()
					,'pessoaidcadastro'	=>$this->pessoaid()
				]);
			}
			
			$redirect = ['controller'=>'cliente','action' => 'edit',$cliente->clienteid];
			
			
			$this->Flash->success(__('Telefone salvo com sucesso.'));
			return $this->redirect($redirect);
        }

        $this->set(compact('telefone'));

		$this->set([
			'pessoa'=>$pessoa
			,'cliente'=>$cliente
            ,'usuario'=>$usuario
            ,'numeroTelefone'=> $numeroTelefone
		]);
    }

    /**
     * Edit method
     *
     * @param string|null $id Telefone id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $telefone = $this->Telefone->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $telefone = $this->Telefone->patchEntity($telefone, $this->request->getData());
            if ($this->Telefone->save($telefone)) {
                $this->Flash->success(__('Telefone salvo com sucesso'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The telefone could not be saved. Please, try again.'));
        }
		
		$pessoa = $this->get('pessoa','pessoaid',$id);
        $this->set(compact('telefone'));
		$this->set(['pessoa'=>$pessoa]);
    }

    /**
     * Delete method
     *
     * @param string|null $id Telefone id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $telefone = $this->Telefone->get($id);
        if ($this->Telefone->delete($telefone)) {
            $this->Flash->success(__('The telefone foi excluído.'));
        } else {
            $this->Flash->error(__('The telefone could not be deleted. Please, try again.'));
        }

        return $this->redirect($this->referer());
    }
}
