<?php
namespace App\Controller\Flystart;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

/**
 * Usuariofunil Controller
 *
 * @property \App\Model\Table\UsuariofunilTable $Usuariofunil
 *
 * @method \App\Model\Entity\Usuariofunil[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsuariofunilController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $sql = "SELECT  p.nome, u.usuarioid, GROUP_CONCAT(f.descricao SEPARATOR ', ') AS funis
        FROM usuario_crm u
        LEFT JOIN pessoa p ON (p.pessoaid = u.pessoaid)
        INNER JOIN usuariofunil uf ON (uf.idusuario = u.usuarioid)
        LEFT JOIN funil f ON (uf.idfunil = f.idfunil)
        GROUP BY  p.nome, u.usuarioid";

        $usuariofunil = $this->query($sql);
        $this->set(compact('usuariofunil'));
    }

    /**
     * View method
     *
     * @param string|null $id Usuariofunil id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $sql = "SELECT  uf.id, p.nome, u.usuarioid, GROUP_CONCAT(f.descricao SEPARATOR ', ') AS funis
        FROM usuario_crm u
        LEFT JOIN pessoa p ON (p.pessoaid = u.pessoaid)
        INNER JOIN usuariofunil uf ON (uf.idusuario = u.usuarioid)
        LEFT JOIN funil f ON (uf.idfunil = f.idfunil)
        WHERE u.usuarioid = " .$id. " 
        GROUP BY  uf.id, p.nome, u.usuarioid";

        $usuariofunil =  $this->query($sql)[0];
        //$this->d($usuariofunil);
        $this->set(compact('usuariofunil'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $session = $this->request->session();
        $usuarios = $session->read('login.usuario_lista');
        $usuariofunil = $this->Usuariofunil->newEntity();
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            $usuariosave = [];
            for($i=0; $i < count($data['idfunil']); $i++){
                $usuariofunilsave = ['idusuario' => $data['idusuario'], 'idfunil' => $data['idfunil'][$i], 'data_cricacao' => $data['data_criacao']];
                array_push($usuariosave,$usuariofunilsave);
            }
            $usuariofunil = $this->Usuariofunil->patchEntities($usuariofunil, $usuariosave);
            if ($this->Usuariofunil->saveMany($usuariofunil)) {
                $this->Flash->success(__('Funil de usuário salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Funil de usuário não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('usuariofunil','usuarios'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Usuariofunil id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $session = $this->request->session();
        $usuarios = $session->read('login.usuario_lista');
        $funilTable  = TableRegistry::get('funil');
        $funisedit = $funilTable->find('all')
        ->innerJoin('usuariofunil',['usuariofunil.idfunil = funil.idfunil'])
        ->where('usuariofunil.id');
        
        $usuariofunil = $this->Usuariofunil->get($id, [
            'contain' => []
        ]);
        foreach($usuarios as $usuario){
            if($usuario->idusuario == $usuariofunil->idusuario){
                $usuarioedit = $usuario;
            }
        }
        if ($this->request->is(['patch', 'post', 'put'])) {
            $data = $this->request->getData();
            $usuariofunildel = $this->getAllTableWhere('usuariofunil',['idusuario'=>$data['idusuario']],[]);
            foreach ($usuariofunildel as $item) {
                $this->Usuariofunil->delete($item);
            }
            $usuariofunil = $this->Usuariofunil->newEntity();
            $usuariosave = [];
            for($i=0; $i < count($data['idfunil']); $i++){
                $usuariofunilsave = ['idusuario' => $data['idusuario'], 'idfunil' => $data['idfunil'][$i], 'data_cricacao' => $data['data_criacao']];
                array_push($usuariosave,$usuariofunilsave);
            }
            $usuariofunil = $this->Usuariofunil->patchEntities($usuariofunil, $usuariosave);
            if ($this->Usuariofunil->saveMany($usuariofunil)) {
                $this->Flash->success(__('Funil de usuário salvo com sucesso.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('Funil de usuário não pode ser salvo. Por favor tente mais tarde.'));
        }
        $this->set(compact('usuariofunil','usuarios','usuarioedit','funisedit'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Usuariofunil id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $usuariofunil = $this->Usuariofunil->get($id);
        if ($this->Usuariofunil->delete($usuariofunil)) {
            $this->Flash->success(__('Funil de usuário deletado com sucesso.'));
        } else {
            $this->Flash->error(__('Funil de usuário não pode ser deletado. Por favor tente mais tarde.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
