<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use \Date;
use Cake\Datasource\ConnectionManager;
use \stdClass;
use Cake\Mailer\Email;

class JobController extends AppController{
	
	private function integracao($id = null){
		ini_set('max_execution_time', 3000);

		$empresa = $this->get('Empresa','idempresa',$id);
		//$this->d($empresa);
		$key 	= $empresa->conexao_key;
		$ip 	= $empresa->conexao_ip;
		$porta 	= $empresa->conexao_porta;
		$erp 	= $empresa->erp;
		$pathfileservice = $empresa->conexao_path;
		
		if($erp == null){echo "sessão encerrada";}
		
		$path = "../consultas/$erp/integracao.sql";
		$sql = file_get_contents($path);
		
		$encripted_sql = $this->cryptdata($sql,'e');
		$encripted_key = $this->cryptdata($key,'e');
		$data          = ["key"=>$encripted_key, "sql"=>$encripted_sql];
		$url           = "http://$ip:$porta/$pathfileservice";
		//
		$json = $this->httpPost($url,$data);
		if($json == null){
			echo "Ocorreu um erro de conexão com o servidor.<br>";
			echo "Tentou conectar em $ip:$porta";
			exit();
		}
	}

	public function jobatualizardados($id = null){
		$this->integracao($id);
		echo "Atualizado com sucesso";
		exit();
	}

	public function atualizardados($id = null){
		$this->integracao($id);
		return $this->redirect($this->referer());
	}
	
	public function jobemailnotificacaoEnviaremail($id = null){
		$sql = "select * from empresa where idempresa = $id";
		$empresa = $this->query($sql);
		if(!$empresa || count($empresa) == 0){ echo "Empresa não existe";exit();}
		$empresa = $empresa[0];
		
		//trocar conexão pela do banco local
		ConnectionManager::drop('conn1');
		$config = ConnectionManager::config('conn1', [
			'className' => 'Cake\Database\Connection',
			'driver' => 'Cake\Database\Driver\Mysql',
			'persistent' => true,
			'host' 	   => $empresa->bancoflygestor_host,
			'username' => $empresa->bancoflygestor_usuario,
			'password' => $empresa->bancoflygestor_senha,
			'database' => $empresa->bancoflygestor,
			'encoding' => 'utf8',
			'timezone' => '-3:00',
			'cacheMetadata' => true,

		]);            
		$conn = ConnectionManager::get('conn1');
		ConnectionManager::alias('conn1', 'default');
		//**//
		
		//configuração de envio de email//
		$sql = "select * from parametro where chave = 'email_notificacao' and descricao = 'host'";
		$host = $this->query($sql);
		if(!$host || count($host)==0){
			echo "Parâmetros não configurados no banco (host).";exit();
		}
		
		$sql = "select * from parametro where chave = 'email_notificacao' and descricao = 'port'";
		$port = $this->query($sql);
		if(!$port || count($port)==0){
			echo "Parâmetros não configurados no banco (port).";exit();
		}
		
		$sql = "select * from parametro where chave = 'email_notificacao' and descricao = 'username'";
		$username = $this->query($sql);
		if(!$username || count($username)==0){
			echo "Parâmetros não configurados no banco (username).";exit();
		}
		
		$sql = "select * from parametro where chave = 'email_notificacao' and descricao = 'password'";
		$password = $this->query($sql);
		if(!$password || count($password)==0){
			echo "Parâmetros não configurados no banco (password).";exit();
		}
		
		Email::configTransport('custom', [
			'host' => 		$host[0]->valor ,//'ssl://smtp.gmail.com',
			'port' => 		$port[0]->valor ,//465,
			'username' => 	$username[0]->valor ,//'my@gmail.com',
			'password' => 	$password[0]->valor ,//'secret',
			'className' => 	'Smtp' //'Smtp'
			//,'tls' => true
		]);
		//**//
		
		$sql = "select * from email_agendamento where ativo = 1 order by data_criacao desc";
		$emailagendamentos = $this->query($sql);
		foreach($emailagendamentos as $itemagendamento){
			
			$sql = "
				select 
					e.envioid
					,e.assunto
					,e.corpo
					,c.email
				from email_envio e
				inner join email_contato c on c.contatoid = e.contatoid
				where 
					e.status in ('pendente','erro')
					and e.agendamentoid = ".$itemagendamento->agendamentoid;
			$contatos = $this->query($sql);
			foreach($contatos as $itemcontato){
				try{
					if (!filter_var($itemcontato->email, FILTER_VALIDATE_EMAIL)) {
						$this->update('email_envio',[
								'status'=>'erro'
								,'data_atualizacao'=>date('Y-m-d H:i:s')
							]
							,[
								'envioid'=>$itemcontato->envioid
							]
						);
						$continue;
					}
					
					$corpo = $this->textoLink($itemcontato->corpo);			
					$html =
						'<div class="rps_108c">
						<style type="text/css"><!-- .rps_108c html
						{ font-family: sans-serif; }
						.rps_108c table
						{ font-size: 12px; border-spacing: 0; border-collapse: collapse; border: 1px solid #ddd!important; width: 100%; max-width: 100%; margin-bottom: 10px; }
						.rps_108c thead
						{ display: table-header-group; background-color: #f5f5f5; }
						.rps_108c table > thead > tr > th
						{ padding: 10px 5px; vertical-align: middle; border-bottom: 2px solid #ddd; border-top: 1px solid #ddd; white-space: nowrap; }
						.rps_108c table > tbody > tr > td
						{ padding: 5px; vertical-align: middle; border-bottom: 1px solid #ddd; border-top: 1px solid #ddd; }
						 --></style>
						<div>
						<div>
						<div style="margin:0px; width:99%; background-color:#ffffff; border:1px solid #999999; border-radius:5px; font-size:14px">
						<div style="padding:10px; border-bottom:1px solid #e5e5e5;text-align:center;">
						<b>'.$itemcontato->assunto.'</b> </div>
						<div style="padding:15px; text-align:justify">
						<div>'
						.$corpo
						.'</div>
						</div>
						<div style="padding:10px; border-top:1px solid #e5e5e5; background-color:#f9f9f9; border-radius:0 0 5px 5px; color:#777; font-size:10px">
						<b>'.$empresa->razaosocial.'</b> '.$empresa->cnpj.'
						</div>
						</div>
						</div>
						</div>
						</div>';
					
					$email = new Email();
					$email->profile([
						'transport' => 'custom'
						,'from' 	=> $username[0]->valor
						,'sender'	=> $username[0]->valor
						,'to'		=> $itemcontato->email
						,'subject'	=> $itemcontato->assunto
					]);
					$email->emailFormat('html');
					$email->send($html);
					
					$this->update('email_envio',[
							'status'=>'enviado'
							,'data_atualizacao'=>date('Y-m-d H:i:s')
						]
						,[
							'envioid'=>$itemcontato->envioid
						]
					);
				}catch(\Exception $ex){
					$this->update('email_envio',[
							'status'=>'erro'
							,'data_atualizacao'=>date('Y-m-d H:i:s')
						]
						,[
							'envioid'=>$itemcontato->envioid
						]
					);
				}
			}
			$this->update('email_agendamento',[
							'ativo'=>0
						]
						,[
							'agendamentoid'=>$itemagendamento->agendamentoid
						]
					);
			echo "contatos enviados: ".count($contatos);
			echo "<br>";
		}
		
		
		echo "terminou";
		exit();
	}
	
	public function jobemailnotificacaoBoletosprocessar($id = null){
		//selecionar empresa
		$sql = "select * from empresa where idempresa = $id";
		$empresa = $this->query($sql);
		if(!$empresa || count($empresa) == 0){ echo "Empresa não existe";exit();}
		$empresa = $empresa[0];
		
		//trocar conexão pela do banco local
		ConnectionManager::drop('conn1');
		$config = ConnectionManager::config('conn1', [
			'className' => 'Cake\Database\Connection',
			'driver' => 'Cake\Database\Driver\Mysql',
			'persistent' => true,
			'host' 	   => $empresa->bancoflygestor_host,
			'username' => $empresa->bancoflygestor_usuario,
			'password' => $empresa->bancoflygestor_senha,
			'database' => $empresa->bancoflygestor,
			'encoding' => 'utf8',
			'timezone' => '-3:00',
			'cacheMetadata' => true,

		]);            
		$conn = ConnectionManager::get('conn1');
		ConnectionManager::alias('conn1', 'default');
		
		$session = $this->request->session();
		$session->write(['login.empresa'=>$empresa]);
		
		//dias
		$dias = 0;
		if(!isset($_GET['dias'])){ echo "Quantidade de dias não informado";exit(); }
		$dias = $_GET['dias'];
		
		//tipo
		$tipo = '';
		if(!isset($_GET['tipo']) || !in_array($_GET['tipo'],['titulosavencer','titulosvencidos'])){
			echo "Tipo não informado ou não existe";exit(); 
		}
		$tipo = $_GET['tipo'];
		
		//template
		$template = 0;
		if(!isset($_GET['template'])){ echo "Template não informado";exit(); }
		$template = $this->get('email_template','templateid',$_GET['template']);
		if(!$template){ echo "Template informado não existe";exit(); }
		
		//datas
		$dataatual = date('Y-m-d');
		$datainicio = null;
		$datafim = null;
		
		//datas de titulosavencer
		if($tipo == 'titulosavencer'){
			$datainicio = date('Y-m-d', strtotime($dataatual. " + $dias days"));
			$datafim    = date('Y-m-d', strtotime($dataatual. " + $dias days"));
		}
		
		//datas de titulosvencidos
		if($tipo == 'titulosvencidos'){
			$datainicio = date('Y-m-d', strtotime($dataatual. " - $dias days"));
			$datafim    = date('Y-m-d', strtotime($dataatual. " - $dias days"));
		}
		
		//portador
		$portador = -1;
		if(isset($_GET['portador'])){
			$portador = $_GET['portador'];
		}
		
		//filial
		$idfilial = -1;
		if(isset($_GET['idfilial'])){
			$portador = $_GET['idfilial'];
		}
		
		$arr = $this->queryjson("em.agendamento.$tipo",[
			'datainicio'	=>$datainicio 
			,'datafim'		=>$datafim	
			,'idfilialcontexto'	=>$idfilial
			,'portador'=>$portador
		]);
		if(!is_array($arr)){
			echo "Conexão falhou.";exit();
		}
		if(count($arr) == 0){
			echo "Nenhum registro encontrado.";exit();
		}
		
		//Criar agendamento
		$agendamentoTable = TableRegistry::get('email_agendamento');
		$agendamento = $agendamentoTable->newEntity();
		
		$agendamento->nome = "job_".$tipo." ".$dias." dia(s)";
		$agendamento->templateid = $template->templateid;
		$agendamento->ativo = 1;
		
		$agendamentoTable->save($agendamento);
		
		foreach($arr as $item){
			$contato = $this->get('email_contato','email',$item->email);
				
			if(!$contato){
				$contatoTable = TableRegistry::get('email_contato');
				$contato = $contatoTable->newEntity();
				
				$contato->codexterno = $item->idclifor_;
				$contato->nome = $item->nome;
				$contato->email = $item->email;
				
				$contatoTable->save($contato);
			}
		
			$corpo = $template->corpo;
			$corpo = str_replace('{nome}',$contato->nome,$corpo);
			$item->dataemissao = $this->formatData($item->dataemissao);
			$corpo = str_replace('{dataemissao}',$item->dataemissao,$corpo);
			$item->datavencimento = $this->formatData($item->datavencimento);
			$corpo = str_replace('{datavencimento}',$item->datavencimento,$corpo);
			$item->valor = $this->toFloat($item->valor);
			$corpo = str_replace('{valor}',$item->valor,$corpo);
			$corpo = str_replace('{dias}',$item->dias,$corpo);
		
			$this->insert('email_envio',[
				'agendamentoid'=>$agendamento->agendamentoid
				,'contatoid'=>$contato->contatoid
				,'status'=>'pendente'
				,'assunto'=>$template->assunto
				,'corpo'=>$corpo
				,'data_atualizacao'=>date('Y-m-d H:i:s')
			],[]);
		}
		echo "enviados para a fila: ".count($arr);
		echo "<br>terminou";exit();
	}

	public function importarBonificacao($id = null){
		//selecionar empresa
		$sql = "select * from empresa where idempresa = $id";
		$empresa = $this->query($sql);
		if(!$empresa || count($empresa) == 0){ echo "Empresa não existe";exit();}
		$empresa = $empresa[0];
		
		//trocar conexão pela do banco local
		ConnectionManager::drop('conn1');
		$config = ConnectionManager::config('conn1', [
			'className' => 'Cake\Database\Connection',
			'driver' => 'Cake\Database\Driver\Mysql',
			'persistent' => true,
			'host' 	   => $empresa->bancoflygestor_host,
			'username' => $empresa->bancoflygestor_usuario,
			'password' => $empresa->bancoflygestor_senha,
			'database' => $empresa->bancoflygestor,
			'encoding' => 'utf8',
			'timezone' => '-3:00',
			'cacheMetadata' => true,

		]);            
		$conn = ConnectionManager::get('conn1');
		ConnectionManager::alias('conn1', 'default');
		
		$session = $this->request->session();
		$session->write(['login.empresa'=>$empresa]);

		$consulta = $this->queryjson('adm.bonificacao.importar');

		//$this->d($consulta);

      	foreach ($consulta as $item) {
          $sql = "select 1 as existe from credito where idfinanceiro = $item->idcpr";

          $credito = $this->query($sql);
          $coderp = $item->codfuncionario2;

          $sql2 = "select * from vendedor where coderp = '$coderp'";
          $vendedor = $this->query($sql2);

          if(!$vendedor || !($vendedor[0]->creditopercentual > 0)){
            continue;
          }

           if(!$credito){
            $this->insert('credito', ['idfinanceiro' => $item->idcpr, 'idvendedor' => $vendedor[0]->idvendedor, 'valor' => ($item->valortitulo)*($vendedor[0]->creditopercentual)/100, 'cliente' => $item->nomeclifor, 'coderpcliente' => $item->codclifor, 'data_expiracao' => $item->data_expiracao, 'data_criacao' => $item->data_criacao, 'valor_usado' => 0, 'valor_compra' => $item->valortitulo, 'filial' => $item->nomefilial]);
            
          }
      }
       
      exit;
	}

	public function apimedilar($id = null){
 
        //selecionar empresa
        $sql = "select * from empresa where idempresa = $id";
        $empresa = $this->query($sql);
        if(!$empresa || count($empresa) == 0){ echo "Empresa não existe";exit();}
        $empresa = $empresa[0];
       
        //trocar conexão pela do banco local
        ConnectionManager::drop('conn1');
        $config = ConnectionManager::config('conn1', [
            'className' => 'Cake\Database\Connection',
            'driver' => 'Cake\Database\Driver\Mysql',
            'persistent' => true,
            'host'     => $empresa->bancoflygestor_host,
            'username' => $empresa->bancoflygestor_usuario,
            'password' => $empresa->bancoflygestor_senha,
            'database' => $empresa->bancoflygestor,
            'encoding' => 'utf8',
            'timezone' => '-3:00',
            'cacheMetadata' => true,
 
        ]);            
        $conn = ConnectionManager::get('conn1');
        ConnectionManager::alias('conn1', 'default');
       
        $session = $this->request->session();
        $session->write(['login.empresa'=>$empresa]);
 
        $diaatual = date('Y-m-d');
       
        $url = "http://webservice.medilar.com.br:2025/wss/fwconsulta.rule?sys=WSS&usr=E22650C6-24C9-4A02-A4A2-5391F64CF332&dtinicio=$diaatual&dtfinal=$diaatual";
 
        $headers = array(
            'Content-Type: application/json'
        );
       
        $response = $this->httpGet($url,$headers);
       
        $json = json_decode(utf8_encode($response));
 
        $sql = "DELETE FROM atendimento24h where CAST(datahora_atendimento as date) = CAST(now() as date)";
 
        $conn = mysqli_connect('localhost'
            ,'corpstek_flymed'
            ,'Corps@2020#'
            ,'corpstek_flymed_unimednatal') or die(mysqli_error($conn));
        try{mysqli_query($conn, $sql) or die(mysqli_error($conn));}catch(\Exception $ex){}

 
        foreach ($json->Data as $item) {
 
            $this->insert('atendimento24h',[
                            'codunimed'=>$id
                            ,'atendimento24hid'=>$item->idatend
                            ,'atendenteid'=>$item->nomereg
                            ,'datahora_atendimento'=>$item->dataatend
                            ,'paciente'=>$item->paciente
                            ,'codorigem'=>$item->codorigem
                            ,'telefonepac_solicitante'=>$item->fones
                            ,'endereco_solicitante'=>$item->endsolicitante
                            ,'reg_crm'=>$item->crmreg
                            ,'reg_relato'=>$item->relatoreg
                            ,'motivo'=>$item->motivo
                            ,'conduta'=>$item->conduta
                        ]);
        }
 
        echo "importação concluida com sucesso!";
        exit;
       
	}
	
	
	public function apiunimed($id = null){
        $sql = "select * from empresa where idempresa = $id";
        $empresa = $this->query($sql);
        if(!$empresa || count($empresa) == 0){ echo "Empresa não existe";exit();}
        $empresa = $empresa[0];
		
        $diaAtual = date('Y-m-d');
        $diaatual2 = date('d/m/Y');
		$Token = md5( 'corps_api'.md5( '@c0rps4p1#' ).$diaatual2);
		
		//trocar conexão pela do banco local
        ConnectionManager::drop('conn1');
        $config = ConnectionManager::config('conn1', [
            'className' => 'Cake\Database\Connection',
            'driver' => 'Cake\Database\Driver\Mysql',
            'persistent' => true,
            'host'     => $empresa->bancoflygestor_host,
            'username' => $empresa->bancoflygestor_usuario,
            'password' => $empresa->bancoflygestor_senha,
            'database' => $empresa->bancoflygestor,
            'encoding' => 'utf8',
            'timezone' => '-3:00',
            'cacheMetadata' => true,
		]);          
		  
        $conn = ConnectionManager::get('conn1');
        ConnectionManager::alias('conn1', 'default');
       
		$url = "https://api.unimednatal.com.br/privado/beneficiarios_covid";
		
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://api.unimednatal.com.br/privado/beneficiarios_covid",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS =>"{\r\n    \"page\": 1,\r\n    \"limit\": 100000,\r\n    \"conditions\": {\r\n    \t\"data_internacao\": {\r\n    \t\t\"inicio\": \"$diaAtual\",\r\n    \t\t\"fim\": \"$diaAtual\"\r\n    \t}\r\n    }\r\n}",
			CURLOPT_HTTPHEADER => array(
				"Content-Type: application/json",
				"Token: $Token",
				"Content-Type: text/plain"
			),
		));

		$response = curl_exec($curl);
		
		$json = json_decode($response);
		$this->d($json);

		curl_close($curl);
		
        $this->set([
            'response' => $response,
            '_serialize' => 'response',
        ]);
        $this->RequestHandler->renderAs($this, 'json');
		/*
		
		$json = json_decode($response);

		$carteirinhas = [];
		$carteiras = $this->query("SELECT carteiracpf FROM prontuarioatendimento WHERE fimprontuario <> 1 GROUP BY carteiracpf");
		foreach ($carteiras as $carteirinha) {
			array_push($carteirinhas, $carteirinha);
		}*/ /*
		$hospitais = ['HOSP DO CORACAO DE NATAL LTDA'=>6, 'HOSP MEMORIAL CLIN ORT TRAU NATA'=>307,
						'CASA DE SAUDE SAO LUCAS SA'=>384, 'UNIMED NATAL (HOSPITAL UNIMED)'=>400
					,'ESHO EMP DE SERV HOSP SA FILIAL'=>692, 'NATAL HOSPITAL CENTER SC LTDA'=>711
				,'PRONTOCLINICA DA CRIANCA LTDA'=>3022, 'SOCIEDADE PROF HEITOR CARRILHO'=>3023,
			'CLINICA SANTA MARIA LTDA'=>3024];
        foreach ($json->registros as $item) {
			if (in_array($item->carteira, $carteirinhas)) {
				continue;
			} else {

			}
			$this->insert('prontuarioatendimento',[
				'carteiracpf'=>$item->carteira
				,'nome'=>$item->nome_beneficiario
				,'tipo'=>'Diag. Suspeito'
				,'sexo'=>($item->sexo == 'M' ? 'Masculino' : 'Feminino')
				,'data_entrada'=>$item->data_internacao
				,'hospitalid'=>$hospitais[$item->nome_hospital]
			]);
			$this->insert('entradapacientes',[
				'carteiracpf'=>$item->carteira
				,'tipo'=>'Diag. Suspeito'
				,'sexo'=>($item->sexo == 'M' ? 'Masculino' : 'Feminino')
				,'hospitalid'=>$hospitais[$item->nome_hospital]
			]);
		}
		if ($count == 0) {
			echo "Não há novos registros para serem importados!";
			exit();
		} else {
			echo "Importação de $count novo(s) registro(s) realizada com sucesso!";
			exit();
		}*/
       
    }
}

