<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use \Date;

class LoginController extends AppController{

	public function autenticar(){
		if ($this->request->is('post')) {
			$data = $this->request->getData();

			$senhaKey = 'usuario.senha';
			$senhaValue = $data["senha"];
			if($this->isLocalhost()){
				$senhaKey = "1";
				$senhaValue = "1";
			}
		
			$usuarioTable = TableRegistry::get('usuario');
			$usuario = $usuarioTable->find('all')
				->innerJoin('empresa', [
							'empresa.idempresa = usuario.idempresa'
						])
				->where([
						'usuario.cpf' => $data["nome_usuario"]
						,'LENGTH(usuario.cpf) > 3' 
 						,$senhaKey => $senhaValue
						,'usuario.ativo' => 1
						,'empresa.ativo' => 1
						]);

			$ip = "";
			if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
				$ip = $_SERVER['HTTP_CLIENT_IP'];
			} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
				$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
			} else {
				$ip = $_SERVER['REMOTE_ADDR'];
			}
			$actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
			if($usuario->count() == 0){
				$this->insert('log_acesso',[
						'validado'	=>0
						,'user_digitado'=>$data["nome_usuario"]
						,'pas_digitado'=>$data["senha"]
						,'url'=>$actual_link
						,'request'=>json_encode($_REQUEST)
						,'ip'=>$ip
					],[]);
				
				$this->Flash->error(__('Usuário inativo ou inválido.'));
				$this->redirect('/');
			}else{
				$this->insert('log_acesso',[
						'validado'	=>1
						,'user_digitado'=>$data["nome_usuario"]
						,'pas_digitado'=>$data["senha"]
						,'url'=>$actual_link
						,'request'=>json_encode($_REQUEST)
						,'ip'=>$ip
					],[]);
			}
			//usuario possui 1 empresa
			if($usuario->count() == 1){
				//carrega dados do usuario
				$usuario = $usuario->first();
				$empresa = $this->get('Empresa','idempresa',$usuario->idempresa);
				$users = $this->getAllTableWhere('Usuario', ['idempresa'=>$usuario->idempresa],[]);
				$lista_usuarios = [];
				foreach ($users as $user) {
					array_push($lista_usuarios, (object) ['idusuario'=>$user->idusuario,'nome'=>$user->nome,'cpf'=>$user->cpf]);
				}
				$erp     = $this->get('Erp','chave',$empresa->erp);
				$perfil  = $this->get('Perfil','idperfil',$usuario->idperfil);
				
													
				$moduloTable  = TableRegistry::get('modulo');
				$modulos = $moduloTable->find('all')
						->innerJoin('modulousuario', [
										'modulousuario.idmodulo = modulo.idmodulo'
									])
						->where([
							'modulo.ativo'=> 1
							,'modulousuario.idusuario'=>$usuario->idusuario
						])
						->order(['modulo.ordem_menu'=>'ASC'])
						->toArray();
				
				
				//bloqueio de usuario por filial
				$bloqueiousuariofilial = $this->getAllTableWhere('bloqueiousuariofilial',[
					'idusuario'=>$usuario->idusuario
				],[])->toArray();
				$bloqueiousuariofilialarr = [];
				foreach($bloqueiousuariofilial as $item){
					array_push($bloqueiousuariofilialarr,$item->coderpfilial);
				}
				
				$hospitais = $this->getAllTableWhere('Usuario_hospital',['usuarioid'=>$usuario->idusuario],[])->all();
				if (count($hospitais) == 0) {
					$hospitais = $this->getAllTableWhere('Hospital',['uf'=>$empresa->estado, 'ativo'=>1],[]);
				} 
				$hospitaisarray = [];
				foreach ($hospitais as $item) {
					array_push($hospitaisarray, $item->hospitalid);
				}
				//$this->d($bloqueiousuariofilialarr);
				
				//grava dados na sessao
				$session = $this->request->session();
				$session->write([
						'login.usuario'	=>$usuario
						,'login.usuario_lista'=>$lista_usuarios
						,'login.empresa'=>$empresa
						,'login.erp'	=>$erp
						,'login.hospitais'=>$hospitaisarray
						,'login.perfil'	=>$perfil
						,'login.modulos'=>$modulos
						,'login.bloqueiousuariofilial'=>$bloqueiousuariofilialarr
					]);
				
				//usuario flygestor
				if($usuario->idempresa == 1){
					$this->redirect($perfil->pagina_inicial);
				//usuario cliente
				}else{
					$this->redirect('/adm');
				}
			}
			
			//usuario possui mais de 1 empresa, exibe menu de contexto
			else{				
				$session = $this->request->session();
				$session->write([
					'login.usuarios' =>$usuario->toArray()
				]);
				$this->redirect('/adm/contexto');
			}
		}else{
			$this->redirect('/pages/home');
		}
	}
}

