<?php

namespace App\Controller\Medico;



use App\Controller\AppController;
use Cake\ORM\TableRegistry;


class TelemedicinaController extends AppController{


    public function initialize() {
        parent::initialize();
        date_default_timezone_set("America/Bahia");
        // $medico = $this->query("SELECT * FROM `usuario` WHERE idusuario = ".$this->usuarioid())[0];
        // if($medico->idperfil != 10){
        //     $this->redirect("/");
        // }
    }
    public function index(){

        $medico = $this->query("SELECT u.nome,h.nomefantasia,e.nome as especialidade FROM medico as m
        INNER JOIN usuario as u ON u.idusuario = m.usuarioid
        INNER JOIN horario_medico as hm ON hm.medicoid = m.medicoid
        INNER JOIN hospital as h ON h.hospitalid = hm.hospitalid 
        INNER JOIN medico_especialidade mh ON mh.medicoid = m.medicoid 
        INNER JOIN especialidade e ON e.especialidadeid = mh.especialidadeid WHERE m.medicoid = ".$this->medicoid())[0];
        $this->set([
            'medico' => $medico
        ]);
    }

    public function agendamentosconferencia(){
        
        if($this->request->is(['patch', 'post', 'put'])){
            $data = $this->request->getData();
            $inicio = date("Y-m-d H:i:s",strtotime($data['start']));
            $termino = date("Y-m-d H:i:s",strtotime($data['end']));
            $horario = $this->query("SELECT p.nome as parciente,hm.inicio,hm.status,h.nomefantasia, v.salavirtual,hm.horariomedicoid FROM `horario_medico` as hm 
            LEFT JOIN videoconferencia as v ON v.conferenciaid = hm.conferenciaid
            INNER JOIN medico as m ON m.medicoid = hm.medicoid
            LEFT JOIN (SELECT * FROM usuario) as p ON p.idusuario = hm.parcienteid 
            INNER JOIN hospital as h ON h.hospitalid = hm.hospitalid
            INNER JOIN usuario as u ON u.idusuario = m.usuarioid 
            WHERE hm.status != 'Cancelada' AND u.idusuario = ".$this->usuarioid()." AND hm.inicio BETWEEN '$inicio' AND '$termino'");
            $json = [];
            foreach ($horario as $key => $value) {
                $json[$key]['start'] = date("Y-m-d\TH:i:sO",strtotime($value->inicio));
                $json[$key]['end'] = date("Y-m-d\TH:i:sO",strtotime($value->inicio));
                $json[$key]['hospital'] = $value->nomefantasia;
                $json[$key]['paciente'] = $value->parciente;
                $json[$key]['salavirtual'] = $value->salavirtual;
                $json[$key]['horariomedicoid'] = $value->horariomedicoid;
                if($value->status == "Disponível"){
                    $json[$key]['title'] = "Consulta Disponível";
                    $json[$key]['backgroundColor'] = "#00A5A8";
                    $json[$key]['status'] = "Disponível";
                    
                }
                if($value->status == "Agendada"){
                    $json[$key]['title'] = "Consulta do paciente ".strtolower($value->parciente)." para o ".strtolower($value->nomefantasia);
                    $json[$key]['backgroundColor'] = "#FF976A";
                    $json[$key]['status'] = "Agendada";
                }
                if($value->status == "Realizada"){
                    $json[$key]['title'] = "Consulta do paciente ".strtolower($value->parciente)." para o ".strtolower($value->nomefantasia);
                    $json[$key]['backgroundColor'] = "#3788d8";
                    $json[$key]['status'] = "Realizado";
                }
            }
            $this->response->body(json_encode($json));
            return $this->response;
        }
    }

    public function videoconferencia(){
        if ($this->request->is('get')) {
            $conferenciatable = TableRegistry::get("videoconferencia");
            $medicoTable = TableRegistry::get("medico");
            $conferencia = $conferenciatable->find("all")->where(['salavirtual'=>$_GET['sala']])->first();
            $medico = $medicoTable->find("all")->where(['usuarioid'=>$this->usuarioid()])->first();
            if($conferencia->medicoid != $medico->medicoid){
                return $this->render("errorconferencia");
            }
            $horaatual = strtotime(date("Y-m-d H:i"));
            $inicio = strtotime($conferencia->inicio->i18nFormat("yyyy-MM-dd HH:mm"));
            $termino = strtotime($conferencia->termino->i18nFormat("yyyy-MM-dd HH:mm"));
            if($horaatual >= $inicio && $horaatual < $termino){
                $paciente = $this->query("SELECT u.nome FROM usuario as u WHERE u.idusuario = $conferencia->pacientesid")[0];
                if($conferencia->status == "Pendente"){
                    $sala = $_GET['sala'];
                    $this->set([
                        'sala' => $sala,
                        'url'=>$this->request->getAttribute('base')."/medico/telemedicina/avaliacao?sala=".$_GET['sala'],
                        "paciente"=>$paciente
                    ]);
                    $this->render("/Adm/Telemedicina/videoconferencia");
                }else{
                    $this->set([
                        'conferencia' => $conferencia,
                    ]);
                    $this->render("errorconferencia");
                }
            }else{
                $this->set([
                    'conferencia' => $conferencia,
                ]);
                $this->render("errorconferencia");
            }
             
        }
    }

    public function avaliacao(){
        $conferenciatable = TableRegistry::get("videoconferencia");
        $conferencia = $conferenciatable->find("all")->where(['salavirtual'=>$_GET['sala']])->first();
        $conferencia->status = "Realizado";
        if($conferencia->medicoid  == $this->medicoid()){
            $medico = $this->query("SELECT u.nome FROM `medico` as m
                INNER JOIN usuario as u ON u.idusuario = m.usuarioid WHERE m.medicoid = ".$conferencia->medicoid)[0];
            if($this->request->is('get')){
                $data = $this->request->getData();
                if($conferencia->consultafinalizada == null){
                    $conferencia->consultafinalizada = date("Y-m-d H:i:s");
                    $horario_medicoTable = TableRegistry::get("horario_medico");
                    $horario = $horario_medicoTable->find("all")->where(['conferenciaid'=>$conferencia->conferenciaid ])->first();
                    $horario->status = "Realizada";
                    $horario_medicoTable->save($horario);
                }
                if($conferenciatable->save($conferencia)){
                    return $this->redirect(['action'=>"index"]);
                }
            }
            if($conferencia->consultafinalizada == null){
                if($conferenciatable->save($conferencia)){
                    $this->set([
                        'medico' => $medico
                    ]);
                    return;
                }
            }else{
                $this->set([
                    'medico' => $medico,
                    'conferencia'=>$conferencia
                ]);
            }
            
        }else{
            
            $this->set([
                'conferencia' => $conferencia
            ]);
            return;
        }
    }

    public function cancelarConsulta($id){
        if($this->request->is('post')){
            $horario_medicotable = TableRegistry::get("horario_medico");
            $horario = $horario_medicotable->get($id);
            if($horario->status != "Realizada" || $horario->status != "Cancelada"){
                $data = $this->request->getData();
                $horario->status = "Cancelada";
                $horario->comentario = $data['motivo'];
                if($horario_medicotable->save($horario)){
                    $conferenciatable = TableRegistry::get("videoconferencia");
                    $conferencia = $conferenciatable->get($horario->conferenciaid);
                    $conferencia->status = "Cancelada";
                    $conferenciatable->save($conferencia);
                }
                return $this->redirect(['action'=>"index"]);
            }
            
        }
    }

    public function retirarhorario($id){
        $horario_medicotable = TableRegistry::get("horario_medico");
        $horario = $horario_medicotable->get($id);
        if($horario->status == "Disponível"){
            $horario_medicotable->delete($horario);
        }
    }
}
