<?php
namespace App\Controller\Paciente;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
use Cake\Event\Event;
/**
 * DashboardCorona Controller
 *
 *
 * @method \App\Model\Entity\DashboardCorona[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TelemedicinaController extends AppController{
    
    public function initialize() {
        parent::initialize();
        date_default_timezone_set("America/Bahia");
        // $paciente = $this->query("SELECT * FROM `usuario` WHERE idusuario = ".$this->usuarioid())[0];
        // if($paciente->idperfil != 9){
        //     $this->redirect("/");
        // }
    }
    public function index(){
        $especialidades = $this->query('SELECT e.especialidadeid,e.nome 
        FROM `medico_especialidade` as me 
        LEFT JOIN especialidade as e ON e.especialidadeid = me.especialidadeid
        INNER JOIN horario_medico as hm ON hm.medicoid = me.medicoid
        WHERE (hm.status = "Disponível" AND hm.inicio >= "'.date("Y-m-d H:i:s").'") GROUP BY e.especialidadeid');
        $this->set(compact('especialidades'));
    }

    public function agendamentosconferencia(){
        $consultas = $this->query("SELECT vc.conferenciaid,vc.inicio,vc.termino,vc.salavirtual,u.nome,vc.status,hm.comentario,vc.comentario as comentario_usuario
        FROM `videoconferencia` as vc 
        LEFT JOIN medico as m ON vc.medicoid = m.medicoid
        LEFT JOIN horario_medico as hm ON hm.conferenciaid = vc.conferenciaid
        LEFT JOIN usuario as u ON m.usuarioid = u.idusuario  
        WHERE vc.pacientesid = ".$this->usuarioid());
        $this->set(compact('consultas'));
    }

    public function getUnidade(){
        $data = $this->request->getData();
        $unidades = $this->query('SELECT h.nomefantasia,h.hospitalid FROM `medico_hospital` as mh
        LEFT JOIN hospital as h ON h.hospitalid = mh.hospitalid
        LEFT JOIN medico as m ON m.medicoid = mh.medicoid
        LEFT JOIN horario_medico as hm ON hm.medicoid = m.medicoid
        INNER JOIN medico_especialidade as me ON me.medicoid = m.medicoid
        WHERE hm.status = "Disponível" AND me.especialidadeid = '.$data['especialidade'] .' GROUP BY h.hospitalid');
        $this->set("json",array('msg'=>'getUnidade',"unidades"=>json_encode($unidades)));
        $this->set('_serialize',array('json'));
        $this->response->statusCode(200);
        return;
    }

    public function getMedico(){
        $data = $this->request->getData();
        $medico = $this->query('SELECT m.medicoid,u.nome FROM `medico_hospital` as mh 
        INNER JOIN medico as m ON m.medicoid = mh.medicoid 
        INNER JOIN usuario as u ON u.idusuario = m.usuarioid 
        INNER JOIN hospital as h ON h.hospitalid = mh.hospitalid 
        WHERE h.hospitalid = '.$data['unidade']);
        $this->set("json",array('msg'=>'getMedico',"medico"=>json_encode($medico)));
        $this->set('_serialize',array('json'));
        $this->response->statusCode(200);
        return;
    }

    public function getHorarios(){
        $data = $this->request->getData();
        $inicio = date("Y-m-d H:i");
        $horario = $this->query('SELECT GROUP_CONCAT(hm.horariomedicoid SEPARATOR ", ") as horariomedicoid, DATE(hm.inicio) as inicio,
        GROUP_CONCAT(TIME_FORMAT(hm.inicio,"%H:%i") SEPARATOR ", ") as horario FROM `horario_medico` as hm 
        LEFT JOIN medico as m ON m.medicoid = hm.medicoid 
        WHERE hm.inicio >= "'.$inicio.'" AND hm.status = "Disponível" AND hm.medicoid = '.$data['medico'].' GROUP BY DATE(hm.inicio)');
        foreach ($horario as $value) {
            $value->horario = explode(", ", $value->horario);
            $value->horariomedicoid = explode(", ", $value->horariomedicoid);
            $value->horario = array_combine($value->horariomedicoid,$value->horario);
            $value->inicio = date("d/m/Y",strtotime($value->inicio));
        }
        $this->set("json",array('msg'=>'ggetHorarioset',"horarios"=>json_encode($horario)));
        $this->set('_serialize',array('json'));
        $this->response->statusCode(200);
        return;

    }

    public function preconfirmar($especialidade,$unidade,$medico,$horario){
        $especialidade = $this->query("SELECT nome,especialidadeid FROM especialidade WHERE especialidadeid = ".$especialidade)[0];
        $unidade = $this->query("SELECT nomefantasia,logradouro,numero,bairro,municipio,hospitalid FROM hospital WHERE hospitalid = ".$unidade)[0];
        $medico = $this->query("SELECT u.nome,m.medicoid FROM medico as m INNER JOIN usuario as u ON u.idusuario = m.usuarioid WHERE medicoid = ".$medico)[0];
        $horario = $this->query("SELECT inicio,horariomedicoid FROM horario_medico WHERE horariomedicoid = ".$horario)[0];
        $this->set(compact('especialidade','unidade','medico','horario'));
    }

    
    function confirmar($especialidade,$unidade,$medico,$horario){
        $marcacaoTable = TableRegistry::get("horario_medico");
        $marcacao = $marcacaoTable->get($horario);
        if($marcacao->status == "Disponível"){
            $conferenciaTable = TableRegistry::get("videoconferencia");
            $conferencia = $conferenciaTable->newEntity();
            $conferencia->pacientesid = $this->usuarioid();
            $conferencia->medicoid = $medico;
            $conferencia->inicio = $marcacao->inicio;
            $conferencia->termino = date("Y-m-d H:i:s",strtotime(date("Y-m-d H:i:s",strtotime($marcacao->inicio->i18nFormat("yyyy-MM-dd HH:mm:ss")))." + 1 hours"));
            $conferencia->salavirtual = md5(uniqid(rand(), true));
            if($conferenciaTable->save($conferencia)){
                $marcacao->status = "Agendada";
                $marcacao->parcienteid = $this->usuarioid();
                $marcacao->hospitalid = $unidade;
                $marcacao->especialidade = $especialidade;
                $marcacao->conferenciaid = $conferencia->conferenciaid;
                if($marcacaoTable->save($marcacao)){
                    $this->set("json",array('msg'=>'agendado'));
                    $this->set('_serialize',array('json'));
                    $this->response->statusCode(200);
                    return;
                }
                
            }else{
                $this->set("json",array('msg'=>'não salvou o horario do médico '));
                $this->set('_serialize',array('json'));
                $this->response->statusCode(500);
                return;
            }
        }
        if($marcacao->status == "Agendada"){
            $this->set("json",array('msg'=>'agendada',"horarioid"=>$horario));
            $this->set('_serialize',array('json'));
            $this->response->statusCode(500);
            return;
        }
    }

    public function videoconferencia(){
        if ($this->request->is('get')) {

            $conferenciatable = TableRegistry::get("videoconferencia");
            $conferencia = $conferenciatable->find("all")->where(['salavirtual'=>$_GET['sala']])->first();
            if($conferencia->pacientesid != $this->usuarioid()){
                return $this->render("errorconferencia");
            }
            $horaatual = strtotime(date("Y-m-d H:i"));
            $inicio = strtotime($conferencia->inicio->i18nFormat("yyyy-MM-dd HH:mm"));
            $termino = strtotime($conferencia->termino->i18nFormat("yyyy-MM-dd HH:mm"));
            if($horaatual >= $inicio && $horaatual < $termino){
                $medico = $this->query("SELECT u.nome,h.nomefantasia,e.nome as especialidade FROM medico as m
                INNER JOIN usuario as u ON u.idusuario = m.usuarioid
                INNER JOIN horario_medico as hm ON hm.medicoid = m.medicoid
                INNER JOIN hospital as h ON h.hospitalid = hm.hospitalid 
                INNER JOIN medico_especialidade mh ON mh.medicoid = m.medicoid 
                INNER JOIN especialidade e ON e.especialidadeid = mh.especialidadeid WHERE m.medicoid = $conferencia->medicoid GROUP BY hm.medicoid")[0];
                if($conferencia->status == "Pendente"){
                    $sala = $_GET['sala'];
                    $this->set([
                        'sala' => $sala,
                        'is_paciente'=>true,
                        'url'=>$this->request->getAttribute('base')."/paciente/telemedicina/avaliacao?sala=".$_GET['sala'],
                        "medico"=>$medico
                    ]);
                    $this->render("/Adm/Telemedicina/videoconferencia");
                }else{
                    $this->set([
                        'conferencia' => $conferencia,
                    ]);
                    $this->render("errorconferencia");
                }
            }else{
                $this->set([
                    'conferencia' => $conferencia,
                ]);
                $this->render("errorconferencia");
            }
             
        }
    }

    public function avaliacao(){
        $conferenciatable = TableRegistry::get("videoconferencia");
        $conferencia = $conferenciatable->find("all")->where(['salavirtual'=>$_GET['sala']])->first();
        if($conferencia->pacientesid == $this->usuarioid()){
            $medico = $this->query("SELECT u.nome FROM `medico` as m
                INNER JOIN usuario as u ON u.idusuario = m.usuarioid WHERE m.medicoid = ".$conferencia->medicoid)[0];
            if($this->request->is('post')){
                $data = $this->request->getData();
                if(isset($data['notaconsulta'])){
                    $conferencia->notaconsulta = $data['notaconsulta'];
                }
                if(isset($data['comentario'])){
                    $conferencia->comentario = $data['comentario'];
                }
                if($conferenciatable->save($conferencia)){
                    return $this->redirect(['action'=>"index"]);
                }
            }
            if($conferencia->consultafinalizada == null){
                if($conferenciatable->save($conferencia)){
                    $this->set([
                        'medico' => $medico
                    ]);
                    return;
                }
            }else{
                $this->set([
                    'medico' => $medico,
                    'conferencia'=>$conferencia
                ]);
            }
            
        }else{
            
            $this->set([
                'conferencia' => $conferencia
            ]);
            return;
        }

    }

    public function cancelar(){
        if($this->request->is('post')){
            $conferenciatable = TableRegistry::get("videoconferencia");
            $conferencia = $conferenciatable->find("all")->where(['salavirtual'=>$_GET['sala']])->first();
            if($conferencia->pacientesid == $this->usuarioid()){
                $data = $this->request->getData();
                $conferencia->status = "Cancelada";
                $conferencia->comentario = "Cancelado por você";
                $horario_medicoTable = TableRegistry::get("horario_medico");
                $horario = $horario_medicoTable->find("all")->where(['conferenciaid'=>$conferencia->conferenciaid ])->first();
                $horario->parcienteid = null;
                $horario->conferenciaid = null;
                $horario->status = "Disponível";
                $horario->comentario =  $data['motivo'];
                if($horario_medicoTable->save($horario) && $conferenciatable->save($conferencia)){
                    return $this->redirect(['action'=>"index"]);
                }
            }
        }

    }



}