<?php

namespace App\Controller\Secretaria;



use App\Controller\AppController;
use Cake\ORM\TableRegistry;


class MedicoController extends AppController{

    public function initialize() {
        parent::initialize();
        // $secretaria = $this->query("SELECT * FROM `usuario` WHERE idusuario = ".$this->usuarioid())[0];
        // if($secretaria->idperfil != 11){
        //     $this->redirect("/");
        // }
    }
    public function index(){
        $medico = $this->query("SELECT m.medicoid,u.nome,m.crm,GROUP_CONCAT(h.nomefantasia SEPARATOR ', ') as hospitais FROM `medico` as m 
        INNER JOIN usuario as u ON u.idusuario = m.usuarioid 
        LEFT JOIN medico_hospital as mh ON mh.medicoid = m.medicoid 
        LEFT JOIN hospital as h ON h.hospitalid = mh.hospitalid GROUP BY m.medicoid");
        $this->set(compact('medico'));
    }

    public function edit($id){

        if($this->request->is(['patch', 'post', 'put'])){
            $data = $this->request->getData();
            $horariotable = TableRegistry::get("horario_medico");
            $horario = $horariotable->find("all")->where(['medicoid'=>$id,'hospitalid'=>$data['hospitais']
            ,'DATE(inicio)'=>date("Y-m-d",strtotime($data['diahorario'])),'status'=>"Disponível"])->toArray();
            foreach ($horario as $value) {
                $horariotable->delete($value);
            }
            foreach ($data['horarios'] as $value) {
                $horario = $horariotable->newEntity();
                $horario->medicoid = $id;
                $horario->hospitalid = $data['hospitais'];
                $horario->inicio = date('Y-m-d H:i:00',strtotime($data['diahorario']." ".$value));
                $horario->status = "Disponível";
                if(!$horariotable->save($horario)){
                    $this->set('mensagem',"ERRO ao cadastra horario!");
                    $this->set('_serialize',array('mensagem'));
                    $this->response->statusCode(500);
                    return;
                }
            }
            $this->response->body(json_encode(array("msg"=>"sucesso")));
            return $this->response;

        }

        $medico = $this->query("SELECT m.medicoid,u.nome,m.crm FROM `medico` as m 
        INNER JOIN usuario as u ON u.idusuario = m.usuarioid 
        LEFT JOIN medico_hospital as mh ON mh.medicoid = m.medicoid 
        LEFT JOIN hospital as h ON h.hospitalid = mh.hospitalid WHERE m.medicoid = $id")[0];

        $medico->hospitais = $this->query("SELECT h.hospitalid,h.nomefantasia FROM medico_hospital as mh 
        LEFT JOIN hospital as h ON h.hospitalid = mh.hospitalid WHERE mh.medicoid = ".$medico->medicoid);
        $this->set(compact('medico'));
    }

    public function add(){
        if($this->request->is(['patch', 'post', 'put'])){
            $data = $this->request->getData();
            $medicotable = TableRegistry::get("medico");
            $medico = $medicotable->newEntity();
            $medico->usuarioid = $data['medicoid'];
            $medico->crm = $data['crm'];
            $medico->medico_especialidadeid = 1;
            if(!$medicotable->save($medico)){
                $this->Flash->error(__('Error ao cadastra médico'));
                return $this->redirect(['action' => 'index']);
            }
            $medicohospitaltable = TableRegistry::get("medico_hospital");
            $hospital = $medicohospitaltable->newEntity();
            $hospital->hospitalid = $data['hospitais'];
            $hospital->medicoid = $medico->medicoid;
            if(!$medicohospitaltable->save($hospital)){
                $this->Flash->error(__('Error ao cadastra médico'));
                return $this->redirect(['action' => 'index']);
            }
            $medicoespecialidadetable = TableRegistry::get("medico_especialidade");
            foreach ($data['especialidades'] as $value) {
               $especialidade = $medicoespecialidadetable->newEntity();
               $especialidade->medicoid = $medico->medicoid;
               $especialidade->especialidadeid = $value;
               if(!$medicoespecialidadetable->save($especialidade)){
                    $this->Flash->error(__('Error ao cadastra médico'));
                    return $this->redirect(['action' => 'index']);
               }
            }
            $horariotable = TableRegistry::get("horario_medico");
            foreach ($data['horarios'] as $value) {
                $horario = $horariotable->newEntity();
                $horario->medicoid = $medico->medicoid;
                $horario->hospitalid = $data['hospitais'];
                $horario->inicio = date('Y-m-d H:i:00',strtotime($data['diahorario']." ".$value));
                $horario->status = "Disponível";
                if(!$horariotable->save($horario)){
                    $this->set('mensagem',"ERRO ao cadastra horario!");
                    $this->set('_serialize',array('mensagem'));
                    $this->response->statusCode(500);
                    return;
                }
            }
            $this->Flash->success(__('Salvo com sucesso'));
            return $this->redirect(['action' => 'index']);
        }
        $medico = $this->query("SELECT * FROM `usuario` as u LEFT JOIN medico as m ON m.usuarioid = u.idusuario WHERE m.medicoid IS NULL AND u.idperfil = 10");
        $hospitais = $this->query("SELECT * FROM `hospital`");
        $especialidade = $this->query("SELECT * FROM `especialidade`");
        $this->set(compact('medico','hospitais','especialidade'));
    }

    public function horarios($hospital,$medico,$diahorario){
        $horarios = $this->queryArr("SELECT TIME_FORMAT(TIME(hm.inicio),'%H:%i') as hora,hm.`status` FROM `horario_medico` as hm
        LEFT JOIN medico as m ON m.medicoid = hm.medicoid
        WHERE (hm.medicoid = $medico OR m.usuarioid = $medico) AND hm.hospitalid = $hospital AND DATE(inicio) = ".date("'Y-m-d'",strtotime($diahorario)));
        $this->set(compact('horarios'));
    }


}