<?php

namespace App\Controller\Secretaria;



use App\Controller\AppController;
use Cake\ORM\TableRegistry;


class TelemedicinaController extends AppController{


    public function index(){
        
    }

    public function agendamentosconferencia(){
        if($this->request->is(['patch', 'post', 'put'])){
            $data = $this->request->getData();
            $inicio = date("Y-m-d H:i:s",strtotime($data['start']));
            $termino = date("Y-m-d H:i:s",strtotime($data['end']));
            $horario = $this->query("SELECT p.nome as parciente,hm.inicio,hm.status,h.nomefantasia, v.salavirtual,hm.horariomedicoid,u.nome as medico FROM `horario_medico` as hm 
            LEFT JOIN videoconferencia as v ON v.conferenciaid = hm.conferenciaid
            INNER JOIN medico as m ON m.medicoid = hm.medicoid
            LEFT JOIN (SELECT * FROM usuario) as p ON p.idusuario = hm.parcienteid 
            INNER JOIN hospital as h ON h.hospitalid = hm.hospitalid
            INNER JOIN usuario as u ON u.idusuario = m.usuarioid 
            WHERE hm.status != 'Cancelada' AND hm.inicio BETWEEN '$inicio' AND '$termino'");
            $json = [];
            foreach ($horario as $key => $value) {
                $json[$key]['start'] = date("Y-m-d\TH:i:sO",strtotime($value->inicio));
                $json[$key]['end'] = date("Y-m-d\TH:i:sO",strtotime($value->inicio));
                $json[$key]['hospital'] = $value->nomefantasia;
                $json[$key]['paciente'] = $value->parciente;
                $json[$key]['salavirtual'] = $value->salavirtual;
                $json[$key]['horariomedicoid'] = $value->horariomedicoid;
                $json[$key]['medico'] = $value->medico;
                if($value->status == "Disponível"){
                    $json[$key]['title'] = "Consulta Disponível";
                    $json[$key]['backgroundColor'] = "#00A5A8";
                    $json[$key]['status'] = "Disponível";
                    
                }
                if($value->status == "Agendada"){
                    $json[$key]['title'] = "Consulta do paciente ".strtolower($value->parciente)." para o ".strtolower($value->nomefantasia);
                    $json[$key]['backgroundColor'] = "#FF976A";
                    $json[$key]['status'] = "Agendada";
                }
                if($value->status == "Realizada"){
                    $json[$key]['title'] = "Consulta do paciente ".strtolower($value->parciente)." para o ".strtolower($value->nomefantasia);
                    $json[$key]['backgroundColor'] = "#3788d8";
                    $json[$key]['status'] = "Realizado";
                }
            }
            $this->response->body(json_encode($json));
            return $this->response;
        }
    }

    public function cancelarConsulta($id){
        if($this->request->is('post')){
            $horario_medicotable = TableRegistry::get("horario_medico");
            $horario = $horario_medicotable->get($id);
            if($horario->status != "Realizada" || $horario->status != "Cancelada"){
                $data = $this->request->getData();
                $horario->status = "Cancelada";
                $horario->comentario = $data['motivo'];
                if($horario_medicotable->save($horario)){
                    $conferenciatable = TableRegistry::get("videoconferencia");
                    $conferencia = $conferenciatable->get($horario->conferenciaid);
                    $conferencia->status = "Cancelada";
                    $conferenciatable->save($conferencia);
                }
                return $this->redirect(['action'=>"index"]);
            }
            
        }
    }

    public function retirarhorario($id){
        $horario_medicotable = TableRegistry::get("horario_medico");
        $horario = $horario_medicotable->get($id);
        if($horario->status == "Disponível"){
            $horario_medicotable->delete($horario);
        }
    }



}
