<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Atendimento Entity
 *
 * @property int $atendimentoid
 * @property string $observacao
 * @property bool $historicocovid
 * @property string $contatocovid
 * @property string $unidadesaude
 * @property int $motivo
 * @property string $cid
 * @property int $pessoaid
 * @property int $usuariocadastro
 * @property \Cake\I18n\FrozenTime $datahora_atendimento
 * @property bool $alta
 * @property bool $obito
 * @property string $origemligacao
 * @property bool $testecolhido
 * @property string $codigoteste
 * @property bool $covidpositivo
 * @property \Cake\I18n\FrozenDate $datateste
 * @property \Cake\I18n\FrozenDate $dataatendimento
 * @property string $direcionamento
 * @property int $hospitalid
 * @property string $hospitalnome
 * @property bool $wpp
 * @property string $tratamento
 * @property \Cake\I18n\FrozenDate $datatratamento
 * @property bool $fimsintoma
 * @property bool $metastasepulmonar
 * @property string $tumorprimario
 * @property string $usuariocadastronome
 * @property \Cake\I18n\FrozenDate $dataprimeirosintoma
 */
class Atendimento extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'observacao' => true,
        'historicocovid' => true,
        'contatocovid' => true,
        'unidadesaude' => true,
        'motivo' => true,
        'cid' => true,
        'pessoaid' => true,
        'usuariocadastro' => true,
        'datahora_atendimento' => true,
        'alta' => true,
        'obito' => true,
        'origemligacao' => true,
        'testecolhido' => true,
        'codigoteste' => true,
        'covidpositivo' => true,
        'datateste' => true,
        'dataatendimento' => true,
        'direcionamento' => true,
        'hospitalid' => true,
        'hospitalnome' => true,
        'wpp' => true,
        'tratamento' => true,
        'datatratamento' => true,
        'fimsintoma' => true,
        'metastasepulmonar' => true,
        'tumorprimario' => true,
        'usuariocadastronome' => true,
        'dataprimeirosintoma' => true
    ];
}
