<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Evento Entity
 *
 * @property int $eventoid
 * @property string $nome
 * @property string $descricao
 * @property string $imagem
 * @property string $responsavel
 * @property string $url
 * @property \Cake\I18n\FrozenTime $datahora_inicio
 * @property \Cake\I18n\FrozenTime $datahora_fim
 * @property float $valor
 * @property int $usuario_criacao
 * @property \Cake\I18n\FrozenTime $data_criacao
 */
class Evento extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'nome' => true,
        'descricao' => true,
        'imagem' => true,
        'responsavel' => true,
        'url' => true,
        'datahora_inicio' => true,
        'datahora_fim' => true,
        'valor' => true,
        'usuario_criacao' => true,
        'data_criacao' => true
    ];
}
