<?php
namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Hospital Entity
 *
 * @property int $hospitalid
 * @property string $ibge
 * @property string $uf
 * @property string $municipio
 * @property string $cnes
 * @property string $nomefantasia
 * @property string $razaosocial
 * @property string $cnpjproprio
 * @property string $cnpjmantedora
 * @property string $tipogestao
 * @property string $logradouro
 * @property int $numero
 * @property string $bairro
 * @property string $cep
 * @property float $latitude
 * @property float $longitude
 * @property int $codunimed
 * @property bool $ativo
 *
 * @property \App\Model\Entity\Usuario[] $usuario
 */
class Hospital extends Entity
{

    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array
     */
    protected $_accessible = [
        'ibge' => true,
        'uf' => true,
        'municipio' => true,
        'cnes' => true,
        'nomefantasia' => true,
        'razaosocial' => true,
        'cnpjproprio' => true,
        'cnpjmantedora' => true,
        'tipogestao' => true,
        'logradouro' => true,
        'numero' => true,
        'bairro' => true,
        'cep' => true,
        'latitude' => true,
        'longitude' => true,
        'codunimed' => true,
        'ativo' => true,
        'usuario' => true
    ];
}
