<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * AcompanhamentoHospital Model
 *
 * @method \App\Model\Entity\AcompanhamentoHospital get($primaryKey, $options = [])
 * @method \App\Model\Entity\AcompanhamentoHospital newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\AcompanhamentoHospital[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\AcompanhamentoHospital|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\AcompanhamentoHospital patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\AcompanhamentoHospital[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\AcompanhamentoHospital findOrCreate($search, callable $callback = null, $options = [])
 */
class AcompanhamentoHospitalTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('acompanhamento_hospital');
        $this->setDisplayField('raw_rnum');
        $this->setPrimaryKey('raw_rnum');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->scalar('paciente_registro')
            ->maxLength('paciente_registro', 255)
            ->allowEmpty('paciente_registro');

        $validator
            ->date('data_atendimento')
            ->allowEmpty('data_atendimento');

        $validator
            ->scalar('setor_nome')
            ->maxLength('setor_nome', 255)
            ->allowEmpty('setor_nome');

        $validator
            ->scalar('tipo_atendimento')
            ->maxLength('tipo_atendimento', 255)
            ->allowEmpty('tipo_atendimento');

        $validator
            ->scalar('conduta')
            ->maxLength('conduta', 255)
            ->allowEmpty('conduta');

        $validator
            ->scalar('benef_carteira')
            ->maxLength('benef_carteira', 255)
            ->allowEmpty('benef_carteira');

        $validator
            ->scalar('benef_cpf')
            ->maxLength('benef_cpf', 255)
            ->allowEmpty('benef_cpf');

        $validator
            ->integer('raw_rnum')
            ->allowEmpty('raw_rnum', 'create');

        $validator
            ->dateTime('data_import')
            ->requirePresence('data_import', 'create')
            ->notEmpty('data_import');

        return $validator;
    }
}
