<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Acompanhamentocasos Model
 *
 * @method \App\Model\Entity\Acompanhamentocaso get($primaryKey, $options = [])
 * @method \App\Model\Entity\Acompanhamentocaso newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Acompanhamentocaso[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Acompanhamentocaso|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Acompanhamentocaso patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Acompanhamentocaso[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Acompanhamentocaso findOrCreate($search, callable $callback = null, $options = [])
 */
class AcompanhamentocasosTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('acompanhamentocasos');
        $this->setDisplayField('acompanhamentocasosid');
        $this->setPrimaryKey('acompanhamentocasosid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('acompanhamentocasosid')
            ->allowEmpty('acompanhamentocasosid', 'create');

        $validator
            ->integer('hospitalid')
            ->requirePresence('hospitalid', 'create')
            ->notEmpty('hospitalid');

        $validator
            ->scalar('hospital')
            ->maxLength('hospital', 255)
            ->requirePresence('hospital', 'create')
            ->notEmpty('hospital');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 255)
            ->requirePresence('observacao', 'create')
            ->notEmpty('observacao');

        $validator
            ->dateTime('data_cadastro')
            ->requirePresence('data_cadastro', 'create')
            ->notEmpty('data_cadastro');

        $validator
            ->integer('enfgeral')
            ->allowEmpty('enfgeral');

        $validator
            ->integer('enfunimed')
            ->allowEmpty('enfunimed');

        $validator
            ->integer('utiadgeral')
            ->allowEmpty('utiadgeral');

        $validator
            ->integer('utiadunimed')
            ->allowEmpty('utiadunimed');

        $validator
            ->integer('utipgeral')
            ->allowEmpty('utipgeral');

        $validator
            ->integer('utipunimed')
            ->allowEmpty('utipunimed');

        $validator
            ->integer('enfcovidsusp')
            ->allowEmpty('enfcovidsusp');

        $validator
            ->integer('enfcovidconf')
            ->allowEmpty('enfcovidconf');

        $validator
            ->integer('uticovidsusp')
            ->allowEmpty('uticovidsusp');

        $validator
            ->integer('uticovidconf')
            ->allowEmpty('uticovidconf');

        $validator
            ->integer('utipcovidsusp')
            ->allowEmpty('utipcovidsusp');

        $validator
            ->integer('utipcovidconf')
            ->allowEmpty('utipcovidconf');

        $validator
            ->integer('ucigeral')
            ->allowEmpty('ucigeral');

        $validator
            ->integer('uciunimed')
            ->allowEmpty('uciunimed');

        $validator
            ->integer('ucicovidsusp')
            ->allowEmpty('ucicovidsusp');

        $validator
            ->integer('ucicovidconf')
            ->allowEmpty('ucicovidconf');

        $validator
            ->scalar('usuariocadastro')
            ->maxLength('usuariocadastro', 255)
            ->allowEmpty('usuariocadastro');

        return $validator;
    }
}
