<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Administradora Model
 *
 * @method \App\Model\Entity\Administradora get($primaryKey, $options = [])
 * @method \App\Model\Entity\Administradora newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Administradora[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Administradora|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Administradora|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Administradora patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Administradora[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Administradora findOrCreate($search, callable $callback = null, $options = [])
 */
class AdministradoraTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('administradora');
        $this->setDisplayField('administradoraid');
        $this->setPrimaryKey('administradoraid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('administradoraid')
            ->allowEmpty('administradoraid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('logo')
            ->maxLength('logo', 500)
            ->allowEmpty('logo');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        return $validator;
    }
}
